<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Projects;
use App\Models\Accounts;
use App\Models\RvoucherModel;
use App\Models\AccountsModel;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;


class Account extends Controller
{
    
    public function login(Request $req) {


        $req->validate(
            [
                'user_name' => 'required',
                'password' => 'required',
            ]);
            $current_date = Carbon::now()->addDays(2)->format('Y-m-d');
            $user = DB::table('users')->where('password', $req->password)->where('name', $req->user_name)->first();
             $unclearedCount = DB::table('tbl_cheque_sub')
                        ->Where('clear', 0)
                        ->Where('cheque_date','<=',$current_date)
                        ->count();
             
            if (isset($user)){
                session()->put('user_name',$req['user_name']) ;
                session()->put('role',$user->role) ;
                session()->put('user_id',$user->id) ;
                
                session()->put('unclearedCount',$unclearedCount) ;
            
                return redirect('/');
            }else{
                return redirect('/login');
            }

    }
    public function test(Request $req){
        
           $titles = DB::table('installment')->pluck('category', 'customer_name');
 
            foreach ($titles as $name => $categry) {
                echo $category;
            }
    }
    public function fetchAccounts(Request $request){
        $id = $request->post('projectid');
        $account['accounts']=Accounts::where('project_id',$id)->get();
        return response()->json($account);
   
       }
    public function getProjectName(){
    
    
    $user_id = session()->get('user_id');
   $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Accounts')->where('user_id',$user_id)->first();

        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
            
        $accountdata = DB::table('tbl_header')->get();
         
    
		    if($users_menu->role == 0){
            
            if($users_menu->user_add == 1){
			    return view('account.add',compact('projectdata','accountdata','users_menu'));
             }
            else{
              return view('/restricted');
            }
        }
            
         
         if($users_menu->role == 1){
             return view('account.add',compact('projectdata','accountdata','users_menu'));
         }

         return view('account.add',compact('projectdata','accountdata','users_menu'));
        
        // echo "<pre>";
        // print_r($accountdata);
       
    }
    public function addNew(Request $request){

            $request->validate(
                [
                    'projectid' => 'required',
                    'headercode' => 'required',
                ]);
          $Rvoucher = new Accounts;
          
          $Rvoucher->project_name = $request->project_name;
          $Rvoucher->project_id = $request->projectid;
          $Rvoucher->header_code = $request->headercode;          
          $Rvoucher->account_type = $request->account_name;
          $Rvoucher->account_name = $request->account_title;
          $Rvoucher->limit_amount = $request->limit_amount;

          $Rvoucher->save();
           return redirect('/account/index');

        //  echo "<pre>";
        //  print_r($request->all());
        //  echo "</pre>";
    }
    public function index(Request $req){
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Accounts')->where('user_id',$user_id)->first();
        $search = $req['search'] ?? "";
        $sortby = $req['sortby'];
        
        
        
         if($search != ""){    
             
              if($req->sortby == 'project_name'){
            
                 $data = Accounts::whereIn('project_id', function($query) {
                    $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
                })      ->Where('project_name','LIKE',"%$search%")
                        ->orderBy('id','DESC')
                        ->Paginate(10);
              }
              if($req->sortby == 'account_name'){
            
                 $data = Accounts::whereIn('project_id', function($query) {
                    $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
                })      ->Where('account_name','LIKE',"%$search%")
                        ->orderBy('id','DESC')
                        ->Paginate(10);
              }              
                        
         }
         else{
            
            $data = Accounts::whereIn('project_id', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
        ->orderBy('id','desc')->Paginate(10);
         } 
         


	if($users_menu->role == 0){
             if($users_menu->user_read == 1){
                   
			return view('account.index',compact('data','users_menu','sortby'));
             }
         else{
              return view('/restricted');
         }
        }
         
         if($users_menu->role == 1){
             return view('account.index',compact('data','users_menu','sortby'));
         }
         
    
         
        
    }
    public function edit($id){

        $projectdata = Projects::all();
        $accountdata = DB::table('tbl_header')->get();
        $record = DB::table('tbl_account')->where('id','=',$id)->first();
        
        $user_id = session()->get('user_id');
    $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Accounts')->where('user_id',$user_id)->first();     

	if($users_menu->role == 0){
             if($users_menu->user_edit == 1){
                   
			return view('account.edit',compact('projectdata','accountdata','record','users_menu'));
             }
         else{
              return view('/restricted');
         }
        }
         
         if($users_menu->role == 1){
             
             return view('account.edit',compact('projectdata','accountdata','record','users_menu'));
         }
        
        
        // echo "<pre>";
        // print_r($record->toArray());

    }
public function update($id, Request $request)
{
    $request->validate([
        'projectid'   => 'required',
        'headercode'  => 'required',
    ]);

    // Retrieve the existing account record
    $Rvoucher = Accounts::findOrFail($id);

    // Save old values before updating
    $old_header_code = $Rvoucher->header_code;
    $old_account_id  = $Rvoucher->id;

    // New values
    $account_name  = $request->input('account_title');
    $projectid     = $request->input('projectid');
    $header_code   = $request->input('headercode');
    
    

    // Update account record
    $Rvoucher->project_name   = $request->input('project_name');
    $Rvoucher->project_id     = $projectid;
    $Rvoucher->header_code    = $header_code;
    $Rvoucher->account_type   = $request->input('account_name');
    $Rvoucher->account_name   = $account_name;
    $Rvoucher->limit_amount   = $request->input('limit_amount');

    // Save updated account
    $Rvoucher->save();

    // Update related records using old values
    DB::table('tbl_credit_vouchers')
        ->where('header_code', $old_header_code)
        ->where('account_id', $old_account_id)
        ->update([
            'account_name' => $account_name,
            'header_code'  => $header_code
        ]);

    DB::table('tbl_debit_vouchers')
        ->where('header_code', $old_header_code)
        ->where('account_id', $old_account_id)
        ->update([
            'account_name' => $account_name,
            'header_code'  => $header_code
        ]);

    return redirect('/account/index')->with('success', 'Account and related vouchers updated successfully.');
}



    public function show($id){


    $projectdata = Projects::all();
    $accountdata = Accounts::all();
    $record = RvoucherModel::find($id);
    
    return view('Rvoucher.show',compact('projectdata','accountdata','record'));
   

}



}
