<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Projects;
use App\Models\Accounts;
use App\Models\RvoucherModel;
use App\Models\ApplicationModel;

use Illuminate\Support\Facades\DB;

use Illuminate\Support\Carbon;

class Application extends Controller
{
    
    public function home(){
        
        $role = session()->get('role');

        $output = DB::table('cashbook')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })->whereDate('date', DB::raw('CURDATE()'))
                 ->select('ProjectID','ProjectName','account_name','debit','credit','date','description')
                ->get();
                
        $total_cost =  DB::table('tbl_application')->whereIn('project_id', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })->where('Vacant',0)->sum(DB::raw('COALESCE(total_cost,0)'));   
        
        
        $total_received = DB::table('cb_jv')
        ->whereIn('header_code',[101])
        ->sum(DB::raw('COALESCE(debit,0)-COALESCE(credit,0)'));
        

        
        $receivables = $total_received;
        
        $payable =  DB::table('cb_jv')
        ->whereBetween('header_code', [302, 399])
        ->sum(DB::raw('COALESCE(debit,0)-COALESCE(credit,0)'));   
        
        $capital = DB::table('cb_jv')->whereIn('header_code',[601])->sum(DB::raw('coalesce(credit,0)-coalesce(debit,0)'));
        
        $cash_in_hand = DB::table('cb_jv')->where('header_code',901)->sum(DB::raw('COALESCE(credit,0)-COALESCE(debit,0)'));   
        
        $expense = DB::table('cb_jv')->whereBetween('header_code', [300, 399])->sum(DB::raw('COALESCE(debit,0)-COALESCE(credit,0)'));   
    
        $vacant = DB::table('tbl_application')->where('Vacant',1)->sum(DB::raw('COALESCE(total_cost,0)'));  
        
        $vacant_count = DB::table('tbl_application')->where('Vacant',1)->count(DB::raw('id'));   
        
        $project_count = DB::table('tbl_projects')->count(DB::raw('id'));   
        
        return view('main',compact('output','cash_in_hand','vacant','vacant_count','project_count','receivables','payable','capital','role','expense'));
        //dd($output);
        }
    public function fetchAccounts(Request $request){
        $id = $request->post('projectid');
        $account['accounts']=ApplicationModel::where('project_id',$id)->get();
        return response()->json($account);
   
       }
    public function getProjectName(){

        
        $accountdata = Accounts::all();
        $brokerName = DB::table('tbl_account')->where('header_code','=', 304)->get();
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Application Form')->where('user_id',$user_id)->first();
        
        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
	
	
	if($users_menu->role == 0){
             if($users_menu->user_add == 1){
                
                
        

                return view('Application.add',compact('projectdata','accountdata','users_menu','brokerName'));
                
             }
             else{
                 return view('/restricted');
             }
	}
	if($users_menu->role == 1){

	    return view('Application.add',compact('projectdata','accountdata','users_menu','brokerName'));
	}
       
    }
    public function addNew(Request $request){
        
    
            $request->validate(
                [
                    'projectid' => 'required',
                    'category' => 'required',
                    'unit_type' => 'required',
                    'customer_name' => 'required',
                    'unit_no' => 'required',
                    'years' => 'required',
                    'date_of_booking' => 'required',
                ]);
                
                
          $unit_no = $request->unit_no;
          $Application = new ApplicationModel;
          $Application->project_id = $request->projectid;
          $Application->CNIC = $request->cnic;
          $Application->project_name = $request->project_name;
          $Application->category = $request->category;
          $Application->unit_type = $request->unit_type;
          $Application->unit_no = $request->unit_no;
          $Application->customer_name = $request->customer_name;
          $Application->header_code = 101;
          $Application->customer_father_name = $request->customer_father_name;
          $Application->customer_address = $request->customer_address;
          $Application->customer_mobile = $request->customer_mobile;
          $Application->customer_phone = $request->customer_phone;
          $Application->broker_id = $request->broker_id;
          $Application->broker_name = $request->broker_name;
          $Application->broker_amount = $request->broker_amount;
          $Application->sort_by = $request->sort_by;
 
          $Application->date_of_booking = $request->date_of_booking;
          $Application->booking = $request->booking;
          $Application->installment = $request->installment;
          $Application->total_cost = $request->total_cost;
          $Application->installment_start = $request->installment_start;
          $Application->S_D_F = $request->S_D_F;
          $Application->nominee_address = $request->nominee_address;
          $Application->nominee_mobile = $request->nominee_mobile;
          $Application->nominee_cnic = $request->nominee_cnic;
          $Application->relation = $request->relation;
          $Application->utility_charges = $request->utility_charges;
          $Application->years = $request->years;
          $Application->cancelled = $request->has('cancelled');
          $Application->vacant = $request->has('vacant');
          $Application->removed = $request->has('removed');
          
          
        //   echo "<pre>";
        //   print_r($Application->toArray());
        
        $months = $request->years * 12 ;
        $installment_amount = $request->installment;
        $installment_start = $request->installment_start;
          $Application->save();
          $lastInsertedId = $Application->id;
        
        $user = DB::table('tblSchdule')->where('customer_id', '=',$lastInsertedId )->first();
        
if ($user === null) {
// user doesn't exist
}
else{

         if(empty($months)){
             $months = 12;
         }
            

              for ($i=0; $i<$months; $i++) {

                       $datasave =  [
                          'customer_id' => $lastInsertedId,
                          'installment_amount' => $installment_amount ?? 0,
                          'installment_date' =>  $date =  Carbon::parse($installment_start)->addMonth($i)->format('Y-m-d'),

                        ];
                        
                        DB::table('tblSchdule')->insert($datasave);    
                }
                
}

    $utility = DB::table('tbl_account')->where('customer_id',$lastInsertedId)->first();
        
        if ($utility === null) {
            DB::table('tbl_account')->insert([
            'project_id' => $request->projectid,
            'project_name' => $request->project_name,
            'utility_charges' => $request->utility_charges,
            'customer_id' => $lastInsertedId,
            'account_type' => 'Utility Charges',
            'header_code' => 401,
            'account_name' => $unit_no .' '. 'Utility Charges'
            ]);
        }
        
return redirect('/Application/index');

    }
    public function index(Request $req){
        
        $search = $req['search'] ?? "";
        
        $user_id = session()->get('user_id');
        
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Application Form')->where('user_id',$user_id)->first();
        
             $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
            
            
         if($search != "") {
    $data = DB::table('tbl_application')
        ->whereIn('project_id', function($query) {
            $query->select('project_id')->from('tbl_users_sub')
                ->where('user_read', 1)
                ->where('user_id', session()->get('user_id'));
        })
        ->where(function($query) use ($search) {
            $query->where('customer_name', 'LIKE', "%$search%")
                ->orWhere('id', 'LIKE', "%$search%")
                ->orWhere('unit_no', 'LIKE', "%$search%")
                ->orWhere('project_name', 'LIKE', "%$search%");
        })
        ->orderBy('project_name','desc')
        ->orderBy('sort_by','asc')
        ->paginate(10)
        ->appends(['search' => $search]); // <- This line preserves the search
} else {
    $data = DB::table('tbl_application')
        ->whereIn('project_id', function($query) {
            $query->select('project_id')->from('tbl_users_sub')
                ->where('user_read',1)
                ->where('user_id', session()->get('user_id'));
        })
        ->orderBy('sort_by','asc')
        ->paginate(10);
}

         

        if($users_menu->role == 0){
             if($users_menu->user_read == 1){
                   return view('Application.index',compact('data','projectdata','users_menu','search'));
             }
         else{
              return view('/restricted');
         }
        }
         
         if($users_menu->role == 1){
             return view('Application.index',compact('data','projectdata','users_menu','search'));
         }
         
       

    }
    public function edit($id){


        $brokerName = DB::table('tbl_account')->where('header_code','=', 304)->get();
        $record = ApplicationModel::find($id);
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Application Form')->where('user_id',$user_id)->first();
        
     $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();

	if($users_menu->role == 0){
             if($users_menu->user_edit == 1){
                 
                return view('Application.edit',compact('projectdata','record','users_menu','brokerName'));
             }
             else{
                 return view('/restricted');
             }
	}
	if($users_menu->role == 1){
	    
	    return view('Application.edit',compact('projectdata','record','users_menu','brokerName'));
	}
	
        

    }
    public function update($id, Request $request){
        
        $request->validate(
            [
                'projectid' => 'required',
                'category' => 'required',
                'unit_type' => 'required',
                'customer_name' => 'required',
                'unit_no' => 'required',
                'years' => 'required',
            ]);
            
            
      $Application = ApplicationModel::find($id);
      
      $Application->project_id = $request->projectid;
      $Application->project_name = $request->project_name;
      $Application->category = $request->category;
      $Application->unit_type = $request->unit_type;
      $Application->unit_no = $request->unit_no;
      $Application->customer_name = $request->customer_name;
      $Application->header_code = 101;
      $Application->customer_father_name = $request->customer_father_name;
      $Application->customer_address = $request->customer_address;
      $Application->customer_mobile = $request->customer_mobile;
      $Application->customer_phone = $request->customer_phone;
      $Application->CNIC = $request->cnic;
      $Application->date_of_booking = $request->date_of_booking;
      $Application->booking = $request->booking;
      $Application->installment = $request->installment;
      $Application->total_cost = $request->total_cost;
      $Application->installment_start = $request->installment_start;
      $Application->S_D_F = $request->s_d_f;
      $Application->nominee_address = $request->nominee_address;
      $Application->nominee_cnic = $request->nominee_cnic;
      $Application->nominee_name = $request->nominee_name;
      $Application->sort_by = $request->sort_by;
      $Application->nominee_mobile = $request->nominee_mobile;
      $Application->relation = $request->relation;
      $Application->utility_charges = $request->utility_charges;
      $Application->years = $request->years;
      $Application->Cancelled = $request->has('cancelled');
      $Application->Vacant = $request->has('vacant');
      $Application->Removed = $request->has('removed');
      $Application->broker_id = $request->broker_id;
                $Application->broker_name = $request->broker_name;
          $Application->broker_amount = $request->broker_amount;
      
      
        
        $installment_amount = $request->installment;
        $installment_start = $request->installment_start;
        $months = $request->years * 12;
        
        
      $Application->save();



        $customer = DB::table('tblSchdule')->where('customer_id',$id)->first();
        
        if ($customer === null) {
            
            for ($i=0; $i<$months; $i++) {

           $datasave =  [
              'customer_id' => $id,
              'installment_amount' => $installment_amount ?? 0,
              'installment_date' =>  $date =  Carbon::parse($installment_start)->addMonth($i)->format('Y-m-d'),

            ];
            
            DB::table('tblSchdule')->insert($datasave);    
    }
           
           
        }
        else{
            
           //return 'got some values';

        }
        
    $utility = DB::table('tbl_account')->where('customer_id',$id)->first();
        
        if ($utility === null) {
            DB::table('tbl_account')->insert([
            'project_id' => $request->projectid,
            'project_name' => $request->project_name,
            'utility_charges' => $request->utility_charges,
            'customer_id' => $id,
            'account_type' => 'Utility Charges',
            'header_code' => 401,
            'account_name' => $request->unit_no .' '. 'Utility Charges'
            ]);
        }


         return redirect($request->last_url);
         //return back();
         


  }
    public function show($id){


    $projectdata = Projects::all();
    $accountdata = Accounts::all();
    $record = RvoucherModel::find($id);
    
    return view('Cvoucher.show',compact('projectdata','accountdata','record'));
   

}
    public function abc($id){

    $schdule = DB::table('tblSchdule')->orderBy('installment_date')->WhereNotNull('installment_date')->where('installment_amount','>',0)->where('customer_id',$id)->get();
    $record = ApplicationModel::find($id);
    $total = DB::table('tblSchdule')->where('customer_id',$id)->sum('installment_amount');

    
    return view('Application.abc',compact('schdule','record','total'));
    
        
    }
    public function abcUpdate($id, Request $request){
        
        
        $installment_amount = $request->installment_amount;
        $installment_date = $request->installment_date;
        $sub_id= $request->id;
          
          
          for ($i=0; $i<count($request->id); $i++) {

                       $datasave =  [
                          
                          'installment_amount' => $installment_amount[$i] ?? 0,
                          'installment_date' => $installment_date[$i] ?? date('Y-m-d'),

                        ];
                        
                        DB::table('tblSchdule')->where('id',$sub_id[$i])->update($datasave);    
                }
                //return redirect('/Application/index');
                return back();
}
    public function abcDelete($id){

    
    $schdule = DB::table('tblSchdule')->where('customer_id', $id)->delete();


 return redirect('/Application/index');
    
        
    }
    public function appDelete($id){

    
    $applicationForm = DB::table('tbl_application')->where('id', $id)->delete();


 return redirect('/Application/index');
    
        
    }
    
    
    
}
