<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Symfony\Component\Process\Process;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Illuminate\Support\Facades\Response;

class BackupController extends Controller
{
    public function download()
    {
        $connection = config('database.connections.mysql');

        $dbHost = $connection['host'];
        $dbName = $connection['database'];
        $dbUser = $connection['username'];
        $dbPass = $connection['password'];

        $fileName = 'backup_' . date('Y-m-d_H-i-s') . '.sql';
        $filePath = storage_path($fileName);

        $command = "mysqldump -h {$dbHost} -u {$dbUser} -p'{$dbPass}' {$dbName}";

        $process = Process::fromShellCommandline($command);
        $process->run();

        if (!$process->isSuccessful()) {
            throw new ProcessFailedException($process);
        }

        file_put_contents($filePath, $process->getOutput());

        return response()->download($filePath)->deleteFileAfterSend(true);
    }
}