<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Projects;
use App\Models\Accounts;
use Carbon\Carbon;

use Illuminate\Support\Facades\DB;


class Cheques extends Controller
{
    
public function clr($id){
    
            $user_id = session()->get('user_id');
            $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Cheques')->where('user_id',$user_id)->first();
            
            $provisional = DB::table('tbl_cheque')
                ->join('tbl_cheque_sub','tbl_cheque.id','=','tbl_cheque_sub.cheque_id')
                ->select('tbl_cheque_sub.cheque_date',
                        'tbl_cheque.account_id',
                        'tbl_cheque.project_id',
                        'tbl_cheque_sub.cheque_no',
                        'tbl_cheque_sub.id',
                        'tbl_cheque_sub.bank_name',
                        'tbl_cheque.header_code',
                        'tbl_cheque_sub.cheque_date',
                        'tbl_cheque.project_name',
                        'tbl_cheque.account_name',
                        'tbl_cheque.description',
                        'tbl_cheque.source_header_code',
                        'tbl_cheque.source_account_id',
                        'tbl_cheque.source_account_name',
                        'tbl_cheque_sub.dr',
                        'tbl_cheque_sub.cr',
                        'tbl_cheque_sub.clear',
                        'tbl_cheque_sub.cheque_id')
                ->where('tbl_cheque_sub.id',$id)->first();
    
    
    $application = DB::table('tbl_application')->where('id',$provisional->account_id)->first();
    
        $current_date = date('Y-m-d');
        
        if(empty($provisional->cr)){ 
                    
        $lastid = DB::table('tbl_debit_vouchers')->insertGetId([
         'DVManual' => $provisional->cheque_id,
         'header_code' => $provisional->header_code,
         'ProjectID' => $provisional->project_id,
         'ProjectName' => $provisional->project_name,
         'account_name' =>$provisional->account_name,
         'account_id' => $provisional->account_id,
         'total_amount' => $provisional->dr,
         'description' => $provisional->description,
         'payment_type' => 'Cheque',
         'dvdate' => $current_date,
         'last_updated_person' => session()->get('user_name')
        ]);
        

        $lastid = DB::table('tbl_credit_vouchers')->insertGetId([
         'manual_no' => $provisional->cheque_id,
         'header_code' => $provisional->source_header_code,
         'ProjectID' => $provisional->project_id,
         'ProjectName' => $provisional->project_name,
         'account_name' =>$provisional->source_account_name,
         'account_id' => $provisional->source_account_id,
         'total_amount' => $provisional->dr,
         'description' => $provisional->description,
         'payment_type' => 'Cash',
         'cvdate' => $current_date,
         'last_updated_person' => session()->get('user_name')
        ]);
        
        
        }else{
                    
        $lastid = DB::table('tbl_credit_vouchers')->insertGetId([
         'manual_no' => $provisional->cheque_id,
         'header_code' => $provisional->header_code,
         'ProjectID' => $provisional->project_id,
         'ProjectName' => $provisional->project_name,
         'account_name' =>$provisional->account_name,
         'account_id' => $provisional->account_id,
         'total_amount' => $provisional->cr,
         'description' => 'Cash Received Against Cheque :'.$provisional->cheque_no. ' ' .$provisional->bank_name,
         'unit_no' => $application->unit_no,
         'payment_type' => 'Cheque',
         'cvdate' => $current_date,
         'category' => $application->category,
         'last_updated_person' => session()->get('user_name')
        ]);
        
        

        
        }
        





    $affected = DB::table('tbl_cheque_sub')
              ->where('id', $id)
              ->update(['clear' => '1']);
    
              
    
 $current_date = Carbon::now()->subDays(2)->format('Y-m-d');
 $unclearedCount = DB::table('tbl_cheque_sub')
                        ->Where('clear', 0)
                        ->Where('cheque_date','<',$current_date)
                        ->count();
session()->put('unclearedCount',$unclearedCount) ;                        
                        
                        
                
        $data = DB::table('tbl_cheque')
                ->join('tbl_cheque_sub','tbl_cheque.id','=','tbl_cheque_sub.cheque_id')
                ->select('tbl_cheque_sub.cheque_no',
                'tbl_cheque_sub.id as d',
                'tbl_cheque.id as m',
                'tbl_cheque_sub.bank_name',
                'tbl_cheque.header_code',
                'tbl_cheque_sub.cheque_date',
                'tbl_cheque.project_name',
                'tbl_cheque.account_name',
                'tbl_cheque_sub.dr',
                'tbl_cheque_sub.cr',
                'tbl_cheque_sub.clear',
                'tbl_cheque_sub.cheque_id')
                ->orderBy('tbl_cheque_sub.cheque_date','ASC')
                ->where('tbl_cheque_sub.clear','=','0')
                ->Paginate(10);
                
         return view('cheques.index',compact('data','users_menu'));
    
    
}
public function delete($id)
{
    $user_id = session()->get('user_id');
    
    $users_menu = DB::table('tbl_users_sub')
        ->where('menu_name', '=', 'Cheques')
        ->where('user_id', $user_id)
        ->first();

    // Delete the cheque sub record
    DB::table('tbl_cheque_sub')->where('id', $id)->delete();

    // Get sorting parameters from the request (with defaults)
    $sortby = request('sortby', 'tbl_cheque_sub.id');
    $order = request('order', 'asc');

    // Fetch data with sorting
    $data = DB::table('tbl_cheque')
        ->join('tbl_cheque_sub', 'tbl_cheque.id', '=', 'tbl_cheque_sub.cheque_id')
        ->select(
            'tbl_cheque_sub.cheque_no',
            'tbl_cheque_sub.id as d',
            'tbl_cheque.id as m',
            'tbl_cheque_sub.bank_name',
            'tbl_cheque.header_code',
            'tbl_cheque_sub.cheque_date',
            'tbl_cheque.project_name',
            'tbl_cheque.account_name',
            'tbl_cheque_sub.dr',
            'tbl_cheque_sub.cr',
            'tbl_cheque_sub.clear',
            'tbl_cheque_sub.cheque_id'
        )
        ->where('tbl_cheque_sub.clear', '=', '0')
        ->orderBy($sortby, $order)
        ->paginate(10);

    return view('cheques.index', compact('data', 'users_menu', 'sortby', 'order'));
}

public function lookup(Request $req) {
    $user_id = session()->get('user_id');

    $users_menu = DB::table('tbl_users_sub')
        ->where('menu_name', '=', 'Cheques')
        ->where('user_id', $user_id)
        ->first();

    $sortby = $req->get('sortby', 'id'); // Default sort by id
    $order = $req->get('order', 'desc'); // Default order

    $search = $req->get('search');

    $clear_button = 1;
    if ($users_menu->role == 0) {
        if ($users_menu->user_edit == 0 || $users_menu->user_delete == 0) {
            $clear_button = 0;
        }
    }

    // Determine sort column
    $sortColumn = match ($sortby) {
        'cheque_date' => 'tbl_cheque_sub.cheque_date',
        'cheque_no' => 'tbl_cheque_sub.cheque_no',
        default => 'tbl_cheque_sub.id',
    };

    // Build the query
    $data = DB::table('tbl_cheque')
        ->join('tbl_cheque_sub', 'tbl_cheque.id', '=', 'tbl_cheque_sub.cheque_id')
        ->select(
            'tbl_cheque_sub.cheque_no',
            'tbl_cheque_sub.id as d',
            'tbl_cheque.id as m',
            'tbl_cheque_sub.bank_name',
            'tbl_cheque.header_code',
            'tbl_cheque_sub.cheque_date',
            'tbl_cheque.project_name',
            'tbl_cheque.account_name',
            'tbl_cheque_sub.dr',
            'tbl_cheque_sub.cr',
            'tbl_cheque_sub.clear',
            'tbl_cheque_sub.cheque_id'
        )
        ->where('tbl_cheque_sub.clear', '=', '0')
        ->whereIn('tbl_cheque.project_id', function ($query) use ($user_id) {
            $query->select('project_id')
                ->from('tbl_users_sub')
                ->where('user_read', 1)
                ->where('user_id', $user_id);
        })
        ->when($search, function ($q) use ($search) {
            $q->where(function ($q2) use ($search) {
                $q2->orWhere('tbl_cheque_sub.id', '=', $search)
                    ->orWhere('tbl_cheque.project_name', 'LIKE', "%$search%")
                    ->orWhere('tbl_cheque.account_name', 'LIKE', "%$search%")
                    ->orWhere('tbl_cheque_sub.cheque_date', 'LIKE', "%$search%")
                    ->orWhere('tbl_cheque_sub.cheque_no', 'LIKE', "%$search%");
            });
        })
        ->orderBy($sortColumn, $order)
        ->paginate(10)
        ->appends([
            'sortby' => $sortby,
            'order' => $order,
            'search' => $search,
        ]);

    return view('cheques.index', compact('data', 'clear_button', 'users_menu', 'sortby', 'order', 'search'));
}

public function index(){
    

    
    $accountdata = DB::table('tbl_header')->get();
    $projectdata = Projects::all();
    
    
    
   
    
    return view('cheques.add',compact('projectdata','accountdata'));
}
public function addNew(Request $request){
    
            $request->validate(
                [
                    'header_code' => 'required',
                    'project_id' => 'required',
                    'project_name' => 'required',
                    'account_name' => 'required',
                    'account_id' => 'required',
            ]);
    
        $Userid = DB::table('tbl_cheque')->insertGetId([
         'header_code' => $request->header_code,
         'source_header_code' => $request->source_header_code,
         'project_id' => $request->project_id,
         'project_name' => $request->project_name,
         'account_name' =>$request->account_name,
         'source_account_name' =>$request->source_account_name,
         'source_account_id' => $request->source_account_id,
         'account_id' => $request->account_id,
         'description' => $request->description,
         'date' => $request->date

         
      ]);
      
      $bank_name = $request->bank_name;
      $cheque_no = $request->cheque_no;
      $dr = $request->dr;
      $cr = $request->cr;
      $cheque_date = $request->cheque_date;
      
      for ($i=0; $i<count($bank_name); $i++) {
          
          $datasave = [
          'cheque_id' => $Userid,
          'bank_name' => $bank_name[$i],
          'cheque_no' => $cheque_no[$i],
          'dr' => $dr[$i],
          'cr' => $cr[$i],
          'cheque_date' => $cheque_date[$i],
          'clear' => '0'
          ];
          DB::table('tbl_cheque_sub')->insert($datasave);
      }
      
      return redirect('/cheques/index');
      //echo $Userid;

}
public function show(Request $request, $id)
{
    $projectdata = Projects::all();
    $accountdata = Accounts::all();
    $record = DB::table('tbl_cheque')->find($id);

    $search = $request->query('search', '');

    $records = DB::table('tbl_cheque_sub')
        ->where('cheque_id', $id)
        ->when($search, function ($query, $search) {
            return $query->where('description', 'like', "%{$search}%"); // Example column for filtering
        })
        ->paginate(10)
        ->appends(['search' => $search]);

    return view('cheques.show', compact('projectdata', 'accountdata', 'record', 'records', 'search'));
}


}
