<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Projects;
use App\Models\Accounts;
use App\Models\RvoucherModel;
use App\Models\ApplicationModel;
use Illuminate\Support\Facades\DB;


class Cvoucher extends Controller
{

    public function delete($id){
        
                
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Customer Receipts')->where('user_id',$user_id)->first();
	
    	if($users_menu->role == 0){
                 if($users_menu->user_delete == 1){
                       
        	DB::table('tbl_credit_vouchers')->where('id',$id)->delete();
            return redirect('/Cvoucher/index');
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
            
            
                    DB::table('tbl_credit_vouchers')->where('id',$id)->delete();
                    return redirect('/Cvoucher/index');
             }
        
        
    }
    
    public function fetchAccounts(Request $request){
        $id = $request->post('projectid');        
        $account['accounts']=DB::table('allaccounts')->orderby('customer_name')->where('project_id',$id)->get();
        return response()->json($account);
       }
       
    public function fetchCustLedger(Request $request){
            $id = $request->post('account_id');   
            $ledger=DB::table('cashbook')->where('header_code','=',101)->where('account_id',$id)->orderby('date','desc')->limit(5)->get();
            $output = '';
            foreach($ledger as $row){
        	$output .= '<tr>
        	            <td>'. date("d-M-y", strtotime($row->date)) . '</td>
        	            <td>'. $row->Description . '</td>
        	            <td>'. $row->debit . '</td>
        	            <td>'. $row->credit . '</td>
        	            </tr>';
            }
        
            return response()->json($output);
            
       }
       
    public function fetchCustomers(Request $request){
        
        
        $id = $request->POST('projectid');        
        //$account['accounts']=DB::table('tbl_application')->orderby('cvdate','desc')->where('header_code',101)->where('project_id',$id)->get();
        $account['accounts']=DB::table('tbl_application')->where('project_id',$id)->where('header_code',101)->where('Cancelled',0)->get();
        
        
        return response()->json($account);
        
       }    

    public function fetchVendors(Request $request){
        
        $id = $request->POST('projectid');        
        $account['accounts']=DB::table('tbl_account')->whereIn('header_code',[301,302])->where('project_id',$id)->get();
        return response()->json($account);
        
       }       
  
    public function getProjectName(){
        
        
         $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Customer Receipts')->where('user_id',$user_id)->first();
         $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
        $accountdata = Accounts::all();
        
       
	
    	if($users_menu->role == 0){
                 if($users_menu->user_add == 1){
                       
    			        return view('Cvoucher.add',compact('projectdata','accountdata','users_menu'));
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
            
            return view('Cvoucher.add',compact('projectdata','accountdata','users_menu'));
             }

        
        
       
    }
    
    public function addNew(Request $request){
          
        $request->validate(
            [
                'projectid' => 'required',
                'accountid' => 'required',
                'headercode' => 'required',
            ]);
    
        $current_date = date('Y-m-d');
        $lastid = DB::table('tbl_credit_vouchers')->insertGetId([
         'header_code' => $request->headercode,
         'ProjectID' => $request->projectid,
         'ProjectName' => $request->project_name,
         'account_name' =>$request->account_name,
         'account_id' => $request->accountid,
         'total_amount' => $request->amount,
         'description' => $request->desc,
         'unit_no' => $request->unit_no,
         'payment_type' => $request->payment_type,
         'cvdate' => $request->date,
         'category' => $request->category,
         'last_updated_person' => session()->get('user_name')
        ]);
      
          $bank_name = $request->bank_name;
          $cheque_no = $request->cheque_no;
          $total_cr = $request->total_cr;
          $cheque_date = $request->cheque_date;
          
          for ($i=0; $i<count($bank_name); $i++) {
              
              $datasave = [
              'cv_id' => $lastid,
              'bank_name' => $bank_name[$i],
              'cheque_no' => $cheque_no[$i],
              'total_cr' => $total_cr[$i],
              'cheque_date' => $cheque_date[$i]
              ];
              
              DB::table('tbl_credit_vouchers_sub')->insert($datasave);
          }

          return $lastid;
          

    
    }

    public function index(Request $req){
        
                 
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Accounts')->where('user_id',$user_id)->first();   
        $accounts = DB::table('allinoneaccounts')->orderBy('customer_name','asc')->get();
        
        $search = $req['search'] ?? "";
        $sortby = $req['sortby'];

        
         if($search != ""){        
            
            if($req->sortby == 'project_name'){
            
               $data = DB::table('customer_receipts')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
               ->where('ProjectName','LIKE',"%$search%")
                ->orderBy('cvdate','desc')
                ->Paginate(10);
                
            }
            
            elseif($req->sortby == 'account_name'){
                
               $data = DB::table('customer_receipts')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
                ->where('account_name','LIKE',"%$search%")
                ->orderBy('cvdate','desc')
                ->Paginate(10);
            }

            elseif (!isset($req->sortby)){
                
                $data = DB::table('customer_receipts')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })

                ->orWhere('id','=',$search)
                ->orWhere('unit_no','LIKE',"%$search%")
                ->orWhere('cvdate','LIKE',"%$search%")
                ->orderBy('cvdate','desc')
                ->Paginate(10);
            }
            
         }
         
         else{
            
            $data = RvoucherModel::orderBy('id','desc')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })->Where('header_code','=',101)->Paginate(10);
         } 
         
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Customer Receipts')->where('user_id',$user_id)->first();
	
    	if($users_menu->role == 0){
                 if($users_menu->user_read == 1){
                       
    			        return view('Cvoucher.index',compact('data','search','sortby','users_menu','accounts'));
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
            
            return view('Cvoucher.index',compact('data','search','sortby','users_menu','accounts'));
             }
         
         
    }

    public function edit($id){

        $projectdata = Projects::all();
        $accountdata = ApplicationModel::all();
        $record = RvoucherModel::find($id);
        $credit_sub = DB::table('tbl_credit_vouchers_sub')->where('total_cr','>',0)->where('cv_id',$id)->get();
        
        $selected_accounts = DB::table('tbl_application')->where('project_id',$record->ProjectID)->get();
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Customer Receipts')->where('user_id',$user_id)->first();
	
    	if($users_menu->role == 0){
                 if($users_menu->user_edit == 1){
                       
    			        return view('Cvoucher.edit',compact('projectdata','accountdata','record','credit_sub','users_menu','selected_accounts'));
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
            
                return view('Cvoucher.edit',compact('projectdata','accountdata','record','credit_sub','users_menu','selected_accounts'));
                
                //return dd($selected_accounts);
             }


        
        
    }

    public function update($id, Request $request){

        $request->validate(
            [
                'projectid' => 'required',
                
                'accountid' => 'required',
                'headercode' => 'required',
                'unit_no' => 'required',
                
            ]);
            
        $Rvoucher = RvoucherModel::find($id);
        $Rvoucher->manual_no = $request->manual_no;
        $Rvoucher->ProjectName = $request->project_name;
        $Rvoucher->ProjectID = $request->projectid;
        $Rvoucher->header_code = $request->headercode;
        $Rvoucher->account_id = $request->accountid;
        $Rvoucher->account_name = $request->account_name;
        $Rvoucher->total_amount = $request->amount;
        $Rvoucher->description = $request->desc;          
        $Rvoucher->cvdate = $request->date;          
        
        $Rvoucher->payment_type = $request->payment_type;
        $Rvoucher->category = $request->category;
        $Rvoucher->unit_no = $request->unit_no;
        $Rvoucher->last_updated_person = session()->get('user_name');
        $Rvoucher->save();
        
        
          $bank_name = $request->bank_name;
          $cheque_no = $request->cheque_no;
          $total_cr = $request->total_cr;
          $cheque_date = $request->cheque_date;
          $sub_id= $request->id;

          
          for ($i=0; $i<count($bank_name); $i++) {

                                   if (isset($sub_id[$i])){
          
             $datasave =  [
                          
              'cheque_no' => $cheque_no[$i],
              'total_cr' => $total_cr[$i],
              'cheque_date' => $cheque_date[$i],
              'bank_name' => $bank_name[$i],
            ];
            
            DB::table('tbl_credit_vouchers_sub')->where('id',$sub_id[$i])->update($datasave); 
            
          
            }
            else{
               
               
            $datasave =  [
              'cheque_no' => $cheque_no[$i],
              'total_cr' => $total_cr[$i],
              'cheque_date' => $cheque_date[$i],
              'bank_name' => $bank_name[$i],
              'cv_id' => $id,
            ];
            
            DB::table('tbl_credit_vouchers_sub')->insert($datasave);   
               
               
            }
            
          }
          
       return redirect('/Cvoucher/index');


  }

    public function show($id){


    $projectdata = Projects::all();
    $accountdata = Accounts::all();
    $credit_sub = DB::table('tbl_credit_vouchers_sub')->where('total_cr','>',0)->where('cv_id',$id)->get();
    $record = RvoucherModel::find($id);
    $total = DB::table('cashbook')
                ->select(DB::raw('SUM(credit-debit) as SumOfTotal'))
                ->whereRaw('account_id = ? and header_code = ?',[$record->account_id,101])
                ->get();
                
    $father = DB::table('tbl_application')->where('id',$record->account_id)->get();
    
    $inword = $this->numberToWord($record->total_amount);
    
    
    return view('Cvoucher.show',compact('projectdata','accountdata','record','total','credit_sub','inword','father'));


}

    public function numberToWord($num = ''){
        $num    = ( string ) ( ( int ) $num );
        
        if( ( int ) ( $num ) && ctype_digit( $num ) )
        {
            $words  = array( );
             
            $num    = str_replace( array( ',' , ' ' ) , '' , trim( $num ) );
             
            $list1  = array('','one','two','three','four','five','six','seven',
                'eight','nine','ten','eleven','twelve','thirteen','fourteen',
                'fifteen','sixteen','seventeen','eighteen','nineteen');
             
            $list2  = array('','ten','twenty','thirty','forty','fifty','sixty',
                'seventy','eighty','ninety','hundred');
             
            $list3  = array('','thousand','million','billion','trillion',
                'quadrillion','quintillion','sextillion','septillion',
                'octillion','nonillion','decillion','undecillion',
                'duodecillion','tredecillion','quattuordecillion',
                'quindecillion','sexdecillion','septendecillion',
                'octodecillion','novemdecillion','vigintillion');
             
            $num_length = strlen( $num );
            $levels = ( int ) ( ( $num_length + 2 ) / 3 );
            $max_length = $levels * 3;
            $num    = substr( '00'.$num , -$max_length );
            $num_levels = str_split( $num , 3 );
             
            foreach( $num_levels as $num_part )
            {
                $levels--;
                $hundreds   = ( int ) ( $num_part / 100 );
                $hundreds   = ( $hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ( $hundreds == 1 ? '' : 's' ) . ' ' : '' );
                $tens       = ( int ) ( $num_part % 100 );
                $singles    = '';
                 
                if( $tens < 20 ) { $tens = ( $tens ? ' ' . $list1[$tens] . ' ' : '' ); } else { $tens = ( int ) ( $tens / 10 ); $tens = ' ' . $list2[$tens] . ' '; $singles = ( int ) ( $num_part % 10 ); $singles = ' ' . $list1[$singles] . ' '; } $words[] = $hundreds . $tens . $singles . ( ( $levels && ( int ) ( $num_part ) ) ? ' ' . $list3[$levels] . ' ' : '' ); } $commas = count( $words ); if( $commas > 1 )
            {
                $commas = $commas - 1;
            }
             
            $words  = implode( ', ' , $words );
             
            $words  = trim( str_replace( ' ,' , ',' , ucwords( $words ) )  , ', ' );
            if( $commas )
            {
                $words  = str_replace( ',' , ' and' , $words . ' only');
            }
             
            return $words;
        }
        else if( ! ( ( int ) $num ) )
        {
            return 'Zero';
        }
        return '';
    }

}
