<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Items extends Controller
{
    //
    public function lookup(Request $req){
        $search = $req['search'] ?? "";
        //echo $search;
         if($search != ""){        
           
            $items = DB::table('tbl_items')
             ->select(DB::raw('company_name,id,company_id,item_name,size,pur_rate,sal_rate,active_yn'))
             ->where('item_name','LIKE',"%$search%")->orWhere('id','=',"$search")
             ->orderByRaw('id DESC')
             ->Paginate(10);
             
             
         }
         else{
            
            $items = DB::table('tbl_items')
             ->select(DB::raw('company_name,id,company_id,item_name,size,pur_rate,sal_rate,active_yn'))
             ->orderByRaw('id DESC')
             ->Paginate(10);
         } 
         
         return view('items.lookup',compact('items'));
    }
    
    public function open(){
        $category = DB::table('tbl_category')->get();
        $type = DB::table('tbl_type')->get();
        $accounts = DB::table('tbl_account')->where('header_code',201)->get();
        return view('Items.add',compact('accounts','category','type'));
    }
    
    public function add(Request $request){
                    $request->validate(
                [
                    'item_name' => 'required',

                ]);
                
                $items = DB::table('tbl_items')->insert([

                    'item_name' => $request->item_name,
                    'size' => $request->size,
                    'category' => $request->category1,
                    'type' => $request->type1,
                    'active_yn' => $request->has('active') ? 'on' : 'off',
                   'updated_at' => now(),
                   'created_at' => now()
                ]);
                
                if($items){
                   return redirect('/');
                }
                else{
                    echo "<h3>Could not add the record</h3>";
                }
                


    }
    
    public function edit($id){
       
         $company = DB::table('accounts')->where('header_code',201)->get();
         $record = DB::table('tbl_items')->find($id);
        return view('items.edit',compact('company','record'));
        //dd($company);
    }
    
    public function update($id, Request $request){
        $account = DB::table('tbl_items')
              ->where('id', $id)
              ->update([
                    'company_name' => $request->company_name,
                    'company_id' => $request->company_id,
                    'item_name' => $request->item_name,
                    'size' => $request->size,
                    'pur_rate' => $request->pur_rate,
                    'sal_rate' => $request->sal_rate,
                    'last_updated_person' => Session()->get('user_name'),
                    'active_yn' => $request->has('active') ? 'on' : 'off',
                   'updated_at' => now()
                  ]);
                  
                if($account){
                   return redirect('/');
                }
                else{
                    echo "<h3>Could not update the record</h3>";
                }
    }
    

    
}