<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Projects;
use App\Models\Accounts;
use App\Models\PvoucherModel;
use Illuminate\Support\Facades\DB;

class Journal extends Controller
{

    public function fetchAccounts(Request $request){
        $id = $request->post('projectid');
       //$account['accounts']=Accounts::where('project_id',$id)->get();
        $account['accounts']= DB::table('allaccounts')->where('project_id',$id)->get();
        return response()->json($account);
   
       }
    
    public function getProjectName(){

        $projectdata = Projects::all();
        $accountdata = Accounts::all();
        
        return view('journal.add',compact('projectdata','accountdata'));
       
    }
    public function addNew(Request $request){

            $request->validate(
                [
                    'projectid' => 'required',
                    'date' => 'required',
                    'accountid' => 'required',
                    'headercode' => 'required',
                ]);
                
                $journal = DB::table('tbl_journal_subs')->insert([
                    'project_name' => $request->project_name,
                    'project_id' => $request->projectid,
                    'header_code' => $request->headercode,
                    'account_id' => $request->accountid,
                    'account_name' => $request->account_name,
                    'debit' => $request->debit,
                    'credit' => $request->credit,
                    'description' => $request->desc,
                    'jv_date' => $request->date,
                    'last_updated_person' => session()->get('user_name')
                    
                ]);
          

           return redirect('/journal/index');

        //  echo "<pre>";
        //  print_r($request->all());
        //  echo "</pre>";
    }

    public function index(Request $req){
        
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Journal Entry')->where('user_id',$user_id)->first();
        
        $search = $req['search'] ?? "";
        
         if($search != ""){        
             

                    $data = DB::table('tbl_journal_subs')->where('account_name','LIKE',"%$search%")->orWhere('id','=',$search)->Paginate(10);
         
         }
         else{
            
            $data = DB::table('tbl_journal_subs')->orderBy('updated_at','desc')->Paginate(10);
         } 
         
         if($users_menu->role == 0){
                 if($users_menu->user_read == 1){
                    return view('journal.index',compact('data','users_menu'));
                 }
         }else{
             return view('/restricted');
         }
    }

    public function edit($id){

        $projectdata = Projects::all();
        $accountdata = Accounts::all();
        $record = DB::table('tbl_journal_subs')->find($id);
        
        return view('journal.edit',compact('projectdata','accountdata','record'));
        
       

    }

    public function update($id, Request $request){

            $request->validate(
                [
                    'projectid' => 'required',
                    'date' => 'required',
                    'accountid' => 'required',
                    'headercode' => 'required',
                ]);
                
                $journal = DB::table('tbl_journal_subs')
                    ->where('id', $id)
                    ->update([
                    'project_name' => $request->project_name,
                    'project_id' => $request->projectid,
                    'header_code' => $request->headercode,
                    'account_id' => $request->accountid,
                    'account_name' => $request->account_name,
                    'debit' => $request->debit,
                    'credit' => $request->credit,
                    'description' => $request->desc,
                    'jv_date' => $request->date,
                    'last_updated_person' => session()->get('user_name')
                    
                ]);
          

           return redirect('/journal/index');



  }


  public function show($id){


    $projectdata = Projects::all();
    $accountdata = Accounts::all();
    $record = PvoucherModel::find($id);
    
    return view('journal.show',compact('projectdata','accountdata','record'));
   

}



}