<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Projects;
use App\Models\Accounts;
use App\Models\RvoucherModel;
use App\Models\AccountsModel;
use Illuminate\Support\Facades\DB;


class Project extends Controller
{

    public function InStock(Request $req){
        
        $search = $req['search'] ?? "";
        
         $projects = DB::table('tbl_projects')->get();
         
         
         if($search != ""){ 
             
                $record = DB::table('InStock')
                ->where('project_name',$search)
                ->orderBy('project_name')
                ->get();

            
         }else{
             
                     $record = DB::table('InStock')
        ->where('project_id','>',1)
        ->orderBy('project_name')
        ->get();
        
                //return $record;
         }
         
        return view('/reports/InStock',compact('record','projects'));
    }
    public function receivable(){
        
        $report = DB::table('cb_jv')
            
            ->select('project_id','header_code','account_name','project_name','account_id',DB::raw('SUM(COALESCE(debit,0)-COALESCE(credit,0)) as Total'))
            ->groupBy('project_id','header_code','account_name','project_name','account_id')
            ->whereIn('header_code',[101])
            ->orderby('account_name')
            ->get();
            
        $total = DB::table('cb_jv')
        ->whereIn('header_code',[101])
        ->sum(DB::raw('COALESCE(debit,0)-COALESCE(credit,0)'));
        

                return view('/reports/receivable',compact('report','total'));
    }
    
    public function payable(Request $req){
        
        
             $search = $req['search'] ?? "";
        
            $projects = DB::table('tbl_projects')->get();
            
                
                
                if($search != ""){  
                                        $report = DB::table('cb_jv')
                    
                    ->select('project_id','header_code','account_name','project_name','account_id',DB::raw('SUM(COALESCE(debit,0)-COALESCE(credit,0)) as Total'))
                    ->groupBy('project_id','header_code','account_name','project_name','account_id')
                    ->where('project_name',$search)
                    ->whereBetween('header_code', [302, 399])
                    ->get();
                    
                       $total = DB::table('cb_jv')
                            ->whereBetween('header_code', [302, 399])
                            ->where('project_name',$search)
                            ->sum(DB::raw('COALESCE(debit,0)-COALESCE(credit,0)')); 
                }    
                else{    
                $report = DB::table('cb_jv')
                    
                    ->select('project_id','header_code','account_name','project_name','account_id',DB::raw('SUM(COALESCE(debit,0)-COALESCE(credit,0)) as Total'))
                    ->groupBy('project_id','header_code','account_name','project_name','account_id')
                    ->whereBetween('header_code', [302, 399])
                    ->get();
                    
                       $total = DB::table('cb_jv')
                            ->whereBetween('header_code', [302, 399])
                            ->sum(DB::raw('COALESCE(debit,0)-COALESCE(credit,0)'));   
                }
                
                return view('/reports/payable',compact('report','total','projects'));
    }
    
    
    
    public function index(Request $req){
        
        $search = $req['search'] ?? "";
        
        
         if($search != ""){        
            
         $data = DB::table('tbl_projects')->orWhere('project_name','LIKE',"%$search%")
                ->orWhere('id','=',$search)
                ->Paginate(20);
         }
         else{
            
            $data = DB::table('tbl_projects')->Paginate(10);
         } 
         return view('Project.index',compact('data','sortby'));
        
    }
    public function edit($id){

        $projectdata = Projects::all();
        $accountdata = DB::table('tbl_header')->get();
        $record = DB::table('tbl_account')->where('id','=',$id)->first();
        
        
        return view('account.edit',compact('projectdata','accountdata','record'));
        
        // echo "<pre>";
        // print_r($record->toArray());

    }
    public function update($id, Request $request){


        //$Rvoucher = RvoucherModel::find($id);
        $request->validate(
            [
                'projectid' => 'required',
                'headercode' => 'required',
            ]);

      $Rvoucher = Accounts::find($id);
      $Rvoucher->project_name = $request->project_name;
      $Rvoucher->project_id = $request->projectid;
      $Rvoucher->header_code = $request->headercode;          
      $Rvoucher->account_type = $request->account_name;
      $Rvoucher->account_name = $request->account_title;

      $Rvoucher->save();
       return redirect('/account/index');


  }
    public function show($id){


    $projectdata = Projects::all();
    $accountdata = Accounts::all();
    $record = RvoucherModel::find($id);
    
    return view('Rvoucher.show',compact('projectdata','accountdata','record'));
   

}
    public function addNew(Request $req){

         $req->validate(
            [
                'project_name' => 'required'
        
            ]);
            
        DB::table('tbl_projects')->insert([
            'project_name' => $req->project_name
        ]);

        return redirect('/Project/index');

    }
    public function open(){
        
        return view('Project.add');
    }



}