<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Projects;
use App\Models\Accounts;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class Purchase extends Controller
{
    
    public function delete($id){
        
                
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Customer Receipts')->where('user_id',$user_id)->first();
	
    	if($users_menu->role == 0){
                 if($users_menu->user_delete == 1){
                       
        	DB::table('tbl_purchase_sub')->where('inv_id',$id)->delete();
        	DB::table('tbl_purchase')->where('id',$id)->delete();
            return redirect('/Purchase/index');
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
            
                    DB::table('tbl_purchase_sub')->where('inv_id',$id)->delete();
        	        DB::table('tbl_purchase')->where('id',$id)->delete();
                    return redirect('/Purchase/index');
             }
        
        
    }
    
    public function index(Request $req){
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Accounts')->where('user_id',$user_id)->first();   
        $accounts = DB::table('allinoneaccounts')->orderBy('customer_name','asc')->get();
        
        $search = $req['search'] ?? "";
        $sortby = $req['sortby'];

        
         if($search != ""){        
            
            if($req->sortby == 'project_name'){
            
               $data = DB::table('tbl_purchase')->whereIn('project_id', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
               ->where('project_name','LIKE',"%$search%")
                ->orderBy('inv_date','desc')
                ->Paginate(10);
                
            }
            
            elseif($req->sortby == 'account_name'){
                
               $data = DB::table('tbl_purchase')->whereIn('project_id', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
                ->where('account_name','LIKE',"%$search%")
                ->orderBy('inv_date','desc')
                ->Paginate(10);
            }

            elseif (!isset($req->sortby)){
                
                $data = DB::table('tbl_purchase')->whereIn('project_id', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })

                ->orWhere('id','=',$search)
                ->orWhere('account_name','LIKE',"%$search%")
                ->orderBy('date','desc')
                ->Paginate(10);
            }
            
         }
         else{
             $data = DB::table('tbl_purchase')
             ->whereIn('project_id', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
             ->Paginate(10);;
         }
         
         return view('Purchase.index',compact('data','search','sortby','accounts','users_menu'));
    }
    
    public function open(){
        
          $user_id = session()->get('user_id');
          $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Payment Vouchers')->where('user_id',$user_id)->first();

        
                $projects = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
            
        $accounts = DB::table('tbl_account')->get();
        $category = DB::table('tbl_category')->get();
        $type = DB::table('tbl_type')->get();
        
        $items = DB::table('tbl_items')->where('active_yn', '=', 'on')->get();
        return view('Purchase.add',compact('accounts','items','projects','category','type'));

    }
    
    public function add(Request $request){
          
          
    $request->validate(
            [
                'inv_date' => 'required',
                'account_id' => 'required',
                'header_code' => 'required',
                
            ]);



    
    $lastid = DB::table('tbl_purchase')->insertGetId([
         'header_code' => $request->header_code,
         'project_id' => $request->project_id,
         'project_name' => $request->project_name,
         'account_id' => $request->account_id,
         'account_name' => $request->account_name,
         'inv_date' => $request->inv_date,
         'total_amount' => $request->total_amount,
         'entered_by' => $request->entered_by,
         'manual_no' => $request->manual_no
        ]);
        

        
    $item_id = $request->item_id;
    $item_name = $request->item_name;
    $type = $request->type;
    $category = $request->category;
    $size = $request->size;
    $rate = $request->rate;
    $qty = $request->qty;
    $total = $request->total;
          
    for ($i=0; $i<count($item_name); $i++) {
      
      $datasave = [
      
      'inv_id' => $lastid,
      'item_id' => $item_id[$i],
      'item_name' => $item_name[$i],
      'type' => $type[$i],
      'category' => $category[$i],
      'size' => $size[$i],
      'rate' => $rate[$i],
      'qty' => $qty[$i],
      'total' => $total[$i]
      ];
      
      DB::table('tbl_purchase_sub')->insert($datasave);
      
    }
    
    
    return $lastid;
    
         
 


          

    
    }
    
    public function edit($id){
        
                
          $user_id = session()->get('user_id');
          $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Payment Vouchers')->where('user_id',$user_id)->first();

        
                $projects = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
        $accounts = DB::table('tbl_account')->get();
        $category = DB::table('tbl_category')->get();
        $type = DB::table('tbl_type')->get();
       $items = DB::table('tbl_items')->where('active_yn', '=', 'on')->get();
        $record = DB::table('tbl_purchase')->find($id);
        $record_sub = DB::table('tbl_purchase_sub')->where('qty','>',0)->where('inv_id',$id)->get();
        
        return view('Purchase.edit',compact('projects','accounts','category','type','items','record','record_sub'));
        
        //return $purchase_sub;
    }
    
    public function update($id,Request $request){
        
        
            $request->validate(
            [
                'inv_date' => 'required',
                'account_id' => 'required',
                'header_code' => 'required',
                'item_id' => 'required',
            ]);
            
        
            DB::table('tbl_purchase')->where('id',$id)
        ->update([
        
        'header_code' => $request->header_code,
        'project_id' => $request->project_id,
        'project_name' => $request->project_name,
        'account_id' => $request->account_id,
        'account_name' => $request->account_name,
        'inv_date' => $request->inv_date,
        'manual_no' => $request->manual_no,
        'entered_by' => $request->entered_by,
        'total_amount' => $request->total_amount
        ]);
        
        

        $inv_no = $request->invoice_no;
          $item_id = $request->item_id;
          $item_name = $request->item_name;
          $type = $request->type;
          $category = $request->category;
          $size = $request->size;
          $rate = $request->rate;
          $qty = $request->qty;
          $total = $request->total;
          $id= $request->id;
          
          for ($i=0; $i<count($item_name); $i++) {
              
              if (empty($id[$i])) {
                
                              $datasave = [
                          'inv_id' => $inv_no,
                          'item_id' => $item_id[$i],
                          'item_name' => $item_name[$i],
                          'type' => $type[$i],
                          'category' => $category[$i],
                          'size' => $size[$i],
                          'rate' => $rate[$i],
                          'qty' => $qty[$i],
                          'total' => $total[$i]
                          ];    
                   DB::table('tbl_purchase_sub')->insert($datasave);
                }
              else{
              
              $datasave = [
              
              'item_id' => $item_id[$i],
              'item_name' => $item_name[$i],
              'type' => $type[$i],
              'category' => $category[$i],
              'size' => $size[$i],
              'rate' => $rate[$i],
              'qty' => $qty[$i],
              'total' => $total[$i]
              ];
              
              
              DB::table('tbl_purchase_sub')->where('id',$id[$i])->update($datasave);
              }
          }    
    
        
       return $datasave;
       
       
       
    }
    
    public function show($id){
        
        $projects = DB::table('tbl_projects')->get();
        $accounts = DB::table('tbl_account')->get();
        $category = DB::table('tbl_category')->get();
        $type = DB::table('tbl_type')->get();
        $items = DB::table('tbl_items')->where('active_yn', '=', 'on')->get();
        $record = DB::table('tbl_purchase')->find($id);
        $record_sub = DB::table('tbl_purchase_sub')->where('qty','>',0)->where('inv_id',$id)->get();
        
        return view('Purchase.show',compact('projects','accounts','category','type','items','record','record_sub'));
        
        //return $purchase_sub;
    }
    
}
