<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Projects;
use App\Models\Accounts;
use App\Models\PvoucherModel;
use Illuminate\Support\Facades\DB;

class Pvoucher extends Controller
{
    
 public function limit(Request $request)
 
    {
        $accountid = $request->accountid;
        
$result1 = DB::table('cb_jv')
    ->where('account_id', $accountid)
    ->selectRaw('SUM(debit) - SUM(credit) as balance')
    ->first();


$result2 = DB::table('tbl_account')->where('id',$accountid)->first();

$balance = $result2->limit_amount - $result1->balance ?? 0; // Handle null case

 return response()->json([
        
        'balance' => $balance
    ]);

    }
    
    public function numberToWord($num = ''){
        $num    = ( string ) ( ( int ) $num );
        
        if( ( int ) ( $num ) && ctype_digit( $num ) )
        {
            $words  = array( );
             
            $num    = str_replace( array( ',' , ' ' ) , '' , trim( $num ) );
             
            $list1  = array('','one','two','three','four','five','six','seven',
                'eight','nine','ten','eleven','twelve','thirteen','fourteen',
                'fifteen','sixteen','seventeen','eighteen','nineteen');
             
            $list2  = array('','ten','twenty','thirty','forty','fifty','sixty',
                'seventy','eighty','ninety','hundred');
             
            $list3  = array('','thousand','million','billion','trillion',
                'quadrillion','quintillion','sextillion','septillion',
                'octillion','nonillion','decillion','undecillion',
                'duodecillion','tredecillion','quattuordecillion',
                'quindecillion','sexdecillion','septendecillion',
                'octodecillion','novemdecillion','vigintillion');
             
            $num_length = strlen( $num );
            $levels = ( int ) ( ( $num_length + 2 ) / 3 );
            $max_length = $levels * 3;
            $num    = substr( '00'.$num , -$max_length );
            $num_levels = str_split( $num , 3 );
             
            foreach( $num_levels as $num_part )
            {
                $levels--;
                $hundreds   = ( int ) ( $num_part / 100 );
                $hundreds   = ( $hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ( $hundreds == 1 ? '' : 's' ) . ' ' : '' );
                $tens       = ( int ) ( $num_part % 100 );
                $singles    = '';
                 
                if( $tens < 20 ) { $tens = ( $tens ? ' ' . $list1[$tens] . ' ' : '' ); } else { $tens = ( int ) ( $tens / 10 ); $tens = ' ' . $list2[$tens] . ' '; $singles = ( int ) ( $num_part % 10 ); $singles = ' ' . $list1[$singles] . ' '; } $words[] = $hundreds . $tens . $singles . ( ( $levels && ( int ) ( $num_part ) ) ? ' ' . $list3[$levels] . ' ' : '' ); } $commas = count( $words ); if( $commas > 1 )
            {
                $commas = $commas - 1;
            }
             
            $words  = implode( ', ' , $words );
             
            $words  = trim( str_replace( ' ,' , ',' , ucwords( $words ) )  , ', ' );
            if( $commas )
            {
                $words  = str_replace( ',' , ' and' , $words . ' only');
            }
             
            return $words;
        }
        else if( ! ( ( int ) $num ) )
        {
            return 'Zero';
        }
        return '';
    }

    
    public function delete($id){

        
        
        
         $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Payment Vouchers')->where('user_id',$user_id)->first();
	
    	if($users_menu->role == 0){
                 if($users_menu->user_delete == 1){
                       
    			               
        DB::table('tbl_debit_vouchers')->where('id',$id)->delete();
        return redirect('/Pvoucher/index');
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
                    
        DB::table('tbl_debit_vouchers')->where('id',$id)->delete();
        return redirect('/Pvoucher/index');
             }
        
        
        
    }

    public function fetchAccounts(Request $request){
        $id = $request->post('projectid');
       //$account['accounts']=Accounts::where('project_id',$id)->get();
        $account['accounts']= DB::table('allaccounts')->where('project_id',$id)->get();
        return response()->json($account);
   
       }
    
    public function getProjectName(){
        
          $user_id = session()->get('user_id');
          $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Payment Vouchers')->where('user_id',$user_id)->first();

        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
        $accountdata = Accounts::all();
        
        
      
	

    	if($users_menu->role == 0){
                 if($users_menu->user_add == 1){
                       
                    return view('Pvoucher.add',compact('projectdata','accountdata','users_menu'));    			               

                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
                    
                return view('Pvoucher.add',compact('projectdata','accountdata','users_menu'));

             }
        

        
        
       
    }
    
   public function addNew(Request $request){
        
            $request->validate(
                [
                    'projectid' => 'required',
                    'accountid' => 'required',
                    'headercode' => 'required',
                    'account_name' => 'required',
                ]);                
                
// Handle the document upload if it's provided
    if ($request->hasFile('document')) {
        // Validate the document file (you can change the rules as per your requirement)
        $request->validate([
            'document' => 'mimes:pdf,doc,docx,zip,jpeg,png,jpg|max:10240', // max size is 10MB
        ]);
        
        // Get the uploaded document
        $document = $request->file('document');
        
        // Create a unique document name
        $documentName = 'document_' . time() . '.' . $document->getClientOriginalExtension();
        

        // Save the document to storage/app/public/documents
        $documentPath = $document->storeAs('public/documents', $documentName);

        // Store the document path in the database
        $Dpath = 'storage/' . $documentPath; // Assuming you're using the public disk
    }


    
    
    
         $current_date = date('Y-m-d');
                              // Handle the image if it's provided
        if ($request->has('imageData')) {
            // Get the base64 encoded image string
            $imageData = $request->input('imageData');
            
            // Extract the base64 data and convert it to an image
            $imageData = str_replace('data:image/png;base64,', '', $imageData);
            $imageData = base64_decode($imageData);
            
            // Create a unique file name
            $imageName = 'voucher_' . time() . '.png';
    
            // Save the image to storage (you can store it in public/images or any other folder)
            $imagePath = public_path('images/' . $imageName);
            file_put_contents($imagePath, $imageData);
            
            // Store the image path in the database
            $Ipath  = 'images/' . $imageName;
        }
    
    
        $lastid = DB::table('tbl_debit_vouchers')->insertGetId([
         'header_code' => $request->headercode,
         'ProjectID' => $request->projectid,
         'ProjectName' => $request->project_name,
         'account_name' =>$request->account_name,
         'account_id' => $request->accountid,
         'payment_type' => $request->payment_type,
         'total_amount' => $request->amount,
         'description' => $request->desc,
         'dvdate' => $request->date,
         'photo_path' => $Ipath,
         'document_path' => isset($Dpath) ? $Dpath : null, // Store document path
         'last_updated_person' => session()->get('user_name')
         

        ]);

          $bank_name = $request->bank_name;
          $cheque_no = $request->cheque_no;
          $total_cr = $request->total_cr;
          $cheque_date = $request->cheque_date;
          
          for ($i=0; $i<count($bank_name); $i++) {
              
              $datasave = [
              'cv_id' => $lastid,
              'bank_name' => $bank_name[$i],
              'cheque_no' => $cheque_no[$i],
              'total_dr' => $total_cr[$i] ?? 0,
              'cheque_date' => $cheque_date[$i]
              ];
              
              DB::table('tbl_debit_vouchers_sub')->insert($datasave);
          }
          
                 return $lastid;
    }



    public function index(Request $req){
        
                 
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Lookup Payment Vouchers')->where('user_id',$user_id)->first();
        $accounts = DB::table('allinoneaccounts')->orderBy('customer_name','asc')->get();
        
        $search = $req['search'] ?? "";
        $sortby = $req['sortby'];
        
         if($search != ""){        
            
            
            if($req->sortby == 'project_name'){
            
               $data = PvoucherModel::whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
                        ->where('ProjectName','LIKE',"%$search%")
                        ->orderBy('dvdate','desc')
                        ->Paginate(10);
            }
            elseif($req->sortby == 'account_name'){
                
            $data = PvoucherModel::whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })              ->where('account_name','LIKE',"%$search%")
                        ->orderBy('dvdate','desc')
                        ->Paginate(10);
            }
            elseif (!isset($req->sortby)){
               $data =  PvoucherModel::whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
                ->Where('id','=',$search)
                 ->orderBy('dvdate','desc')
                ->Paginate(10);
            }
         
         }
         
         else{
            
            $data = PvoucherModel::orderBy('id','desc')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })->Paginate(10);
         } 
         
         
         

	
    	if($users_menu->role == 0){
                 if($users_menu->user_read == 1){
                       
                    return view('Pvoucher.index',compact('data','search','sortby','users_menu','accounts'));

                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
                    
         return view('Pvoucher.index',compact('data','search','sortby','users_menu','accounts'));

             }
         
    }

    public function edit($id){

        $projectdata = Projects::all();
        $accountdata = Accounts::all();
        $record = PvoucherModel::find($id);
        $payment_sub = DB::table('tbl_debit_vouchers_sub')->where('cv_id',$id)->get();
        $selected_accounts = Accounts::where('project_id',$record->ProjectID)->get();

        
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Payment Vouchers')->where('user_id',$user_id)->first();
	
    	if($users_menu->role == 0){
                 if($users_menu->user_edit == 1){
                       
        return view('Pvoucher.edit',compact('projectdata','accountdata','record','payment_sub','users_menu','selected_accounts'));

                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
                    
         return view('Pvoucher.edit',compact('projectdata','accountdata','record','payment_sub','users_menu','selected_accounts'));

             }
        
        

    }

    public function update($id, Request $request){

        $request->validate(
            [
                'projectid' => 'required',
                
                'accountid' => 'required',
                'headercode' => 'required',
                'bank_name' => 'required',
                'account_name' => 'required',
                
            ]);
        $Rvoucher = PvoucherModel::find($id);
        $Rvoucher->ProjectName = $request->project_name;
        $Rvoucher->ProjectID = $request->projectid;
        $Rvoucher->header_code = $request->headercode;
        $Rvoucher->account_id = $request->accountid;
        $Rvoucher->account_name = $request->account_name;
        $Rvoucher->payment_type = $request->payment_type;
        $Rvoucher->total_amount = $request->amount;
        $Rvoucher->description = $request->desc;          
        $Rvoucher->dvdate = $request->date;
        $Rvoucher->last_updated_person = session()->get('user_name');
        $Rvoucher->save();
        
        
          $bank_name = $request->bank_name;
          $cheque_no = $request->cheque_no;
          $total_cr = $request->total_cr;
          $cheque_date = $request->cheque_date;
          $sub_id= $request->id;
          
          
          for ($i=0; $i<count($bank_name); $i++) {
              
            if(isset($sub_id[$i])){
            
               $datasave =  [
                      'cheque_no' => $cheque_no[$i],
                      'total_dr' => $total_cr[$i] ?? 0,
                      'cheque_date' => $cheque_date[$i],
                      'bank_name' => $bank_name[$i],
                    ];
                    
              DB::table('tbl_debit_vouchers_sub')->where('id',$sub_id[$i])->update($datasave);
                
            }
            
            else{
                    
               $datasave =  [
                      'cheque_no' => $cheque_no[$i],
                      'total_dr' => $total_cr[$i],
                      'cheque_date' => $cheque_date[$i],
                      'bank_name' => $bank_name[$i],
                      'cv_id' => $id,
                    ];
                    
              DB::table('tbl_debit_vouchers_sub')->insert($datasave);
                
            }
                  
          }
          
        
         return redirect('/Pvoucher/index');


  }

    public function show($id){

    $debit_sub = DB::table('tbl_debit_vouchers_sub')->where('total_dr','>',0)->where('cv_id',$id)->get();
    $projectdata = Projects::all();
    $accountdata = Accounts::all();
    $record = PvoucherModel::find($id);
    $inword = $this->numberToWord($record->total_amount);
    
    return view('Pvoucher.show',compact('projectdata','accountdata','record','inword','debit_sub'));
   

}



}
