<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CashBook;
use App\Models\Projects;
use App\Models\ApplicationModel;
use App\Models\TrailBalanceDebit;
use App\Models\InstallmentModel;


use Illuminate\Support\Facades\DB;
use Illuminate\Support\Collection;
use Illuminate\Support\Carbon;


class Reports extends Controller
{
    

public function TrailBalance(Request $request)
    {
        $start_date = $request->get('start_date');
        $end_date   = $request->get('end_date');
        $project_id = $request->get('project_id');

        // parse dates so end includes whole day
        $start = $start_date ? Carbon::parse($start_date)->startOfDay() : null;
        $end   = $end_date   ? Carbon::parse($end_date)->endOfDay()   : null;

        // Lists of header codes
        $leftCodes = [
            301,302,303,304,305,306,307,308,309,310,311,312,
            313,314,315,316,317,318,319,500,501,503,504,505,506,703
        ];
        $rightCodes = [601,201,702,502,101];

        // load projects for dropdown
        $projects = DB::table('credit_debit_vouchers')
            ->select('ProjectID', 'ProjectName')
            ->distinct()
            ->orderBy('ProjectName')
            ->get();

        $selectedProject = null;
        if ($project_id) {
            $selectedProject = $projects->firstWhere('ProjectID', $project_id);
        }

        // ----- Debit side: group by header_code + account_name -----
        $debitQuery = DB::table('credit_debit_vouchers')
            ->select('header_code', 'account_name', DB::raw('SUM(debit - credit) as amount'))
            ->whereIn('header_code', $leftCodes)
            ->groupBy('header_code', 'account_name')
            ->orderBy('header_code');

        if ($project_id) {
            $debitQuery->where('ProjectID', $project_id);
        }
        if ($start) $debitQuery->where('date', '>=', $start);
        if ($end)   $debitQuery->where('date', '<=', $end);

        $debitRows = $debitQuery->get();

        // ----- Credit side: group by header_code + account_name -----
        $creditQuery = DB::table('credit_debit_vouchers')
            ->select('header_code', 'account_name', DB::raw('SUM(credit - debit) as amount'))
            ->whereIn('header_code', $rightCodes)
            ->groupBy('header_code', 'account_name')
            ->orderBy('header_code');

        if ($project_id) {
            $creditQuery->where('ProjectID', $project_id);
        }
        if ($start) $creditQuery->where('date', '>=', $start);
        if ($end)   $creditQuery->where('date', '<=', $end);

        $creditRows = $creditQuery->get();

        // ----- Load header_code -> account_type mapping from tbl_account -----
        $mapping = DB::table('tbl_account')
            ->select('header_code', 'account_type')
            ->pluck('account_type', 'header_code') // key = header_code, value = account_type
            ->toArray();

        // ----- Group debit rows by account_type -----
        $debitsGrouped = [];
        $debitsGroupTotals = [];
        $grandDebit = 0.0;

        foreach ($debitRows as $r) {
            $type = $mapping[$r->header_code] ?? ('Header '.$r->header_code);
            if (!isset($debitsGrouped[$type])) {
                $debitsGrouped[$type] = [];
                $debitsGroupTotals[$type] = 0;
            }
            $debitsGrouped[$type][] = $r;               // r has header_code, account_name, amount
            $debitsGroupTotals[$type] += (float) $r->amount;
            $grandDebit += (float) $r->amount;
        }

        // ----- Group credit rows by account_type -----
        $creditsGrouped = [];
        $creditsGroupTotals = [];
        $grandCredit = 0.0;

        foreach ($creditRows as $r) {
            $type = $mapping[$r->header_code] ?? ('Header '.$r->header_code);
            if (!isset($creditsGrouped[$type])) {
                $creditsGrouped[$type] = [];
                $creditsGroupTotals[$type] = 0;
            }
            $creditsGrouped[$type][] = $r;
            $creditsGroupTotals[$type] += (float) $r->amount;
            $grandCredit += (float) $r->amount;
        }

        $difference = $grandCredit - $grandDebit;

        return view('reports.DateWiseTrailbalance', [
            'debitsGrouped'      => $debitsGrouped,
            'debitsGroupTotals'  => $debitsGroupTotals,
            'creditsGrouped'     => $creditsGrouped,
            'creditsGroupTotals' => $creditsGroupTotals,
            'grandDebit'         => $grandDebit,
            'grandCredit'        => $grandCredit,
            'difference'         => $difference,
            'projects'           => $projects,
            'selectedProject'    => $selectedProject,
            'start_date'         => $start_date,
            'end_date'           => $end_date,
            'project_id'         => $project_id,
        ]);
    }






    public function UpdateUser(Request $request){
        
        if(isset($request->ids)){
            
        $affected = DB::table('tbl_debit_vouchers')
        ->whereIn('id', $request->ids)
        ->update(['checked' => 1]);  
        
            return response()->json(['success'=>true,'msg'=>'Updated Successfully','ids'=>$request->ids]);
             
        }
        
    }
    
    public function UpdateUserReceipt(Request $request){
        
        if(isset($request->ids)){
            
        $affected = DB::table('tbl_credit_vouchers')
        ->whereIn('id', $request->ids)
        ->update(['checked' => 1]);  
        
            return response()->json(['success'=>true,'msg'=>'Updated Successfully','ids'=>$request->ids]);
             
        }
        
    }    
    
    public function Inout(Request $req){
        

        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Authorize Payments')->where('user_id',$user_id)->first();
        $project_id = $req['projectid'] ?? 0; 
       
    	if($users_menu->role == 0){
    	    
                 if($users_menu->user_read == 1){

        	        $projectdata = DB::table('tbl_projects')->get();
                    $voucherdata = DB::table('tbl_debit_vouchers')->where('ProjectID','=',$project_id)
                    ->where('checked',0)
                    ->get();	                

                 }
                 else{
                  return view('/restricted');
                }
    	}else{
    	    
    	    	        $projectdata = DB::table('tbl_projects')->get();
            $voucherdata = DB::table('tbl_debit_vouchers')->where('ProjectID','=',$project_id)
            ->where('checked',0)
            ->get();
    	}
        
        return view('reports.inout',compact('voucherdata','projectdata','user_id','users_menu'));
        
    }
    
    public function ReceiptChecker(Request $req){
        

        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Authorize Payments')->where('user_id',$user_id)->first();
        $project_id = $req['projectid'] ?? 0; 
       
    	if($users_menu->role == 0){
    	    
                 if($users_menu->user_read == 1){

        	        $projectdata = DB::table('tbl_projects')->get();
                    $voucherdata = DB::table('tbl_credit_vouchers')->where('ProjectID','=',$project_id)
                    ->where('checked',0)
                    ->get();	                

                 }
                 else{
                  return view('/restricted');
                }
    	}else{
    	    
    	    	        $projectdata = DB::table('tbl_projects')->get();
            $voucherdata = DB::table('tbl_credit_vouchers')->where('ProjectID','=',$project_id)
            ->where('checked',0)
            ->get();
    	}
        
        return view('reports.ReceiptChecker',compact('voucherdata','projectdata','user_id','users_menu'));
        
        
        
    }
    
    public function Vacants(Request $req){
        
            $search = $req['search'] ?? "";
            $projects = DB::table('tbl_projects')->get();
            
            
             if($search != ""){  
                    $record = DB::table('tbl_application')->where('project_name',$search)->where('Vacant',1)->get(); 
                $Total = DB::table('tbl_application')->where('project_name',$search)->where('Vacant',1)->sum(DB::raw('COALESCE(total_cost,0)')); 
             }
             else{
                $record = DB::table('tbl_application')->where('Vacant',1)->get(); 
                $Total = DB::table('tbl_application')->where('Vacant',1)->sum(DB::raw('COALESCE(total_cost,0)')); 
             }
        
        
         return view('reports.Vacants',compact('record','Total','projects'));
    }
    
    public function InStock(){
        
        $record = DB::table('current_stock_positions')->get();
       
         return view('reports.InStock',compact('record'));
    }
    
    public function fetchCashBookCategoryData(Request $req){
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Cash Book')->where('user_id',$user_id)->first();
        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
        
        
        $newDateTime = Carbon::now();
        $start_date = $req['start_date'] ?? "";        
        $end_date = $req['end_date'] ?? "";   
        $project_id = $req['projectid'] ?? 0;  
        $company_info = DB::table('tbl_company')->first();
        $openingbal =0;
        


if ($start_date != "") {

$voucherdata = DB::table('tbl_debit_vouchers as dv')
    ->join('tbl_header as h', 'h.header_code', '=', 'dv.header_code')
    ->select('dv.header_code', 'h.header_name', DB::raw('SUM(dv.total_amount) as total_amount_sum'))
    ->where('dv.ProjectID', '=', $project_id)
    ->whereBetween('dv.dvdate', [$start_date, $end_date])
    ->groupBy('dv.header_code', 'h.header_name')
    ->orderBy('dv.header_code')
    ->get();


$voucherdata2 = DB::table('tbl_credit_vouchers as cv')
    ->join('tbl_header as h', 'h.header_code', '=', 'cv.header_code')
    ->select('cv.header_code', 'h.header_name', DB::raw('SUM(cv.total_amount) as total_amount_sum'))
    ->where('cv.ProjectID', '=', $project_id)
    ->where('cv.header_code', '=', 101)
    ->whereBetween('cv.cvdate', [$start_date, $end_date])
    ->groupBy('cv.header_code', 'h.header_name')
    ->orderBy('cv.header_code')
    ->get();

    return view('reports.cashbook_by_category', compact('voucherdata', 'start_date', 'end_date', 'openingbal', 'projectdata', 'newDateTime', 'company_info','voucherdata2'));

} else {
    $voucherdata = CashBook::where('ProjectID', '=', $project_id)
        ->orderBy('id', 'asc')
        ->whereDate('date', now()->format("Y-m-d"))
        ->get()
        ->groupBy('header_code'); // Group by header_code here too
        
    $voucherdata2 = DB::table('tbl_credit_vouchers as cv')
    ->join('tbl_header as h', 'h.header_code', '=', 'cv.header_code')
    ->select('cv.header_code', 'h.header_name', DB::raw('SUM(cv.total_amount) as total_amount_sum'))
    ->where('cv.ProjectID', '=', $project_id)
    ->where('cv.header_code', '=', 101)
    ->whereBetween('cv.cvdate', [$start_date, $end_date])
    ->groupBy('cv.header_code', 'h.header_name')
    ->orderBy('cv.header_code')
    ->get();

    return view('reports.cashbook_by_category', compact('voucherdata', 'openingbal', 'projectdata', 'newDateTime', 'company_info','voucherdata2'));
}

                     
    			        
                 

    
         
         
    }
    
    public function fetchCashBookData(Request $req){
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Cash Book')->where('user_id',$user_id)->first();
        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
        
        
        $newDateTime = Carbon::now();
        $start_date = $req['start_date'] ?? "";        
        $end_date = $req['end_date'] ?? "";   
        $project_id = $req['projectid'] ?? 0;  
        $company_info = DB::table('tbl_company')->first();
        
        


        $openingbal = CashBook::where('ProjectID','=',$project_id)->where('date','<',$start_date)->sum(\DB::raw('credit - debit'));
        


    	if($users_menu->role == 0){
    	    
                 if($users_menu->user_read == 1){
                    
    			                
                    if($start_date != ""){        
                        $voucherdata = CashBook::where('ProjectID','=',$project_id)->orderBy('date','asc')->whereBetween('date', [$start_date, $end_date])->get();
                        return view('reports.cashbook',compact('voucherdata','start_date','end_date','openingbal','projectdata','newDateTime','company_info'));
                    
                        
                     }
                     else{
                        $voucherdata = CashBook::where('ProjectID','=',$project_id)->orderBy('id','asc')->where('date','=',now()->format("Y-m-d"))->get();
                        return view('reports.cashbook',compact('voucherdata','openingbal','projectdata','newDateTime','company_info'));

                     } 
                     
    			        
                 }
             else{
                  return view('/restricted');
             }
            }
             
        if($users_menu->role == 1){
                 
                    if($start_date != ""){        
                        $voucherdata = CashBook::where('ProjectID','=',$project_id)->orderBy('date','asc')->whereBetween('date', [$start_date, $end_date])->get();
                        return view('reports.cashbook',compact('voucherdata','start_date','end_date','openingbal','projectdata','newDateTime','company_info'));
                     }
                     else{
                        $voucherdata = CashBook::where('ProjectID','=',$project_id)->orderBy('id','asc')->where('date','=',now()->format("Y-m-d"))->get();
                        return view('reports.cashbook',compact('voucherdata','openingbal','projectdata','newDateTime','company_info'));
                     } 
                     
             }
         
         
    }
    
    public function Recovery(Request $req){
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Cash Book')->where('user_id',$user_id)->first();
        
        
        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
        
        
        $newDateTime = Carbon::now();
        $start_date = $req['start_date'] ?? "";        
        $end_date = $req['end_date'] ?? "";   
        $project_id = $req['projectid'] ?? 0;  
        $company_info = DB::table('tbl_company')->first();
        
        


        $openingbal =0;
        


    	if($users_menu->role == 0){
    	    
                 if($users_menu->user_read == 1){
                    
    			                
                    if($start_date != ""){        
                        $voucherdata = CashBook::where('ProjectID','=',$project_id)->where('header_code',101)->orderBy('date','asc')->whereBetween('date', [$start_date, $end_date])->get();
                        return view('reports.recovery',compact('voucherdata','start_date','end_date','openingbal','projectdata','newDateTime','company_info'));
                    
                        
                     }
                     else{
                        $voucherdata = CashBook::where('ProjectID','=',$project_id)->where('header_code',101)->orderBy('id','asc')->where('date','=',now()->format("Y-m-d"))->get();
                        return view('reports.recovery',compact('voucherdata','openingbal','projectdata','newDateTime','company_info'));

                     } 
                     
    			        
                 }
             else{
                  return view('/restricted');
             }
            }
             
        if($users_menu->role == 1){
                 
                    if($start_date != ""){        
                        $voucherdata = CashBook::where('ProjectID','=',$project_id)->where('header_code',101)->orderBy('date','asc')->whereBetween('date', [$start_date, $end_date])->get();
                        return view('reports.recovery',compact('voucherdata','start_date','end_date','openingbal','projectdata','newDateTime','company_info'));
                     }
                     else{
                        $voucherdata = CashBook::where('ProjectID','=',$project_id)->where('header_code',101)->orderBy('id','asc')->where('date','=',now()->format("Y-m-d"))->get();
                        return view('reports.recovery',compact('voucherdata','openingbal','projectdata','newDateTime','company_info'));
                     } 
                     
             }
         
         
    }
    
    public function fetchLedgerView(Request $req){
        $start_date = $req['start_date'] ?? "";    
        $end_date = $req['end_date'] ?? "";   
        $projectid = $req['projectid'] ?? "";
        $projectdata = Projects::all();   
        

        return view('reports.ledgerview',compact('projectdata','newDateTime'));
    }
    
    public function fetchLedgerData(Request $req){

        $start_date = $req['start_date'] ?? "";    
        $end_date = $req['end_date'] ?? "";   
        $projectid = $req['projectid'] ?? "";
        $projectname = $req['project_name'];
        $accountname = $req['account_name'];
        $headercode = $req['headercode'];
        $accountid = $req['accountid'];
        $unit_no = $req['unit_no'];
        $company_info = DB::table('tbl_company')->first();
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Cash Book')->where('user_id',$user_id)->first();
        
        
        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
        
        

        $DOB = DB::table('tbl_application')->where('project_id', $projectid)->where('header_code', 101)->where('id', $accountid)->first();
        $cost= DB::table('tbl_application')->select('total_cost')->where('project_id', $projectid)->where('header_code', 101)->where('id', $accountid)->first();
        $brokerAmount= DB::table('tbl_application')->select('broker_amount')->where('project_id', $projectid)->where('header_code', 101)->where('id', $accountid)->first();
        $cust_id = DB::table('tbl_account')->where('id',$accountid)->first();
        $application = DB::table('tbl_application')->where('project_id', $projectid)->where('header_code', 101)->where('id', $cust_id->customer_id)->first();
        
        
$TotalCost = ($cost && isset($cost->total_cost)) ? $cost->total_cost : 0;
$DateBooking = ($DOB && isset($DOB->date_of_booking)) ? $DOB->date_of_booking : "";




        

        $cashbook_bal = DB::table('cashbook')->where('date','<',$start_date)->where('header_code','=',$headercode)->where('ProjectID','=',$projectid)->where('account_id','=',$accountid)->sum(\DB::raw('coalesce(debit,0)-coalesce(credit,0)'));
        $journal_bal  = DB::table('tbl_journal_subs')->where('jv_date','<',$start_date)->where('header_code','=',$headercode)->where('project_id','=',$projectid)->where('account_id','=',$accountid)->sum(\DB::raw('coalesce(debit,0)-coalesce(credit,0)'));                
        $invoice  = DB::table('tbl_purchase')->where('inv_date','<',$start_date)->where('project_id','=',$projectid)->where('account_id','=',$accountid)->sum(\DB::raw('coalesce(total_amount,0)'));                
        //return $cashbook_bal . ' ' . $journal_bal . ' '. $invoice .' Total:'. $cashbook_bal-$invoice;
        //$openingbal = CashBook::orderBy('date','asc')->where('date','<',$start_date)->where('header_code','=',$headercode)->where('ProjectID','=',$projectid)->where('account_id','=',$accountid)->sum(\DB::raw('credit - debit'));                
        $openingbal =  $cashbook_bal-($invoice+$journal_bal);
        
        
	        if($start_date != ""){        
        
            
            $voucherdata1 = DB::table('cashbook')
                    ->selectRaw('id,header_code,account_id,account_name,debit,credit,Description,date,ProjectID,ProjectName')
                    ->whereBetween('date', [$start_date, $end_date])
                    ->where('header_code','=',$headercode)
                    ->where('ProjectID','=',$projectid)
                    ->where('account_id','=',$accountid);
                    
            $data = DB::table('tbl_purchase')
                    ->selectRaw('id,header_code,account_id,account_name,0 as "debit",total_amount as "credit","Purchased Invoice" as Description,inv_date,project_id,project_name')
                    ->whereBetween('inv_date', [$start_date, $end_date])
                    ->where('header_code','=',$headercode)
                    ->where('project_id','=',$projectid)
                    ->where('account_id','=',$accountid);

                    
            $voucherdata = DB::table('tbl_journal_subs')
                    ->selectRaw('id,header_code,account_id,account_name,debit,credit,description,jv_date,project_id,project_name')
                    ->whereBetween('jv_date', [$start_date, $end_date])
                    ->where('header_code','=',$headercode)
                    ->where('project_id','=',$projectid)
                   ->where('account_id','=',$accountid)
                    ->unionAll($voucherdata1)
                   ->unionAll($data)
                    ->orderBy('jv_date','asc')
                    ->get();
                    
            //return $TotalCost;
            //return $voucherdata->toArray();
//            return view('reports.ledger',compact('application','DateBooking','TotalCost','accountid','headercode','projectdata','voucherdata','start_date','openingbal','start_date','end_date','projectname','accountname','unit_no','company_info'));
            return view('reports.ledger',compact('application','DateBooking','TotalCost','accountid','headercode','projectdata','voucherdata','start_date','openingbal','start_date','end_date','projectname','accountname','unit_no','company_info'));
            }
            
            
    }
    
    public function trailtest(Request $req){
        $testDebitSide = DB::table('cashbook')
                ->select('header_code','ProjectID','account_name', DB::raw('SUM(debit)-SUM(credit) as Debit'))
                ->groupBy('header_code','ProjectID','account_name')
                ->havingRaw('ProjectID = ?', [3])
                ->whereIn('header_code', [301,501,701])
                ->get();
        echo "<Pre>";
        print_r($testDebitSide->all());
    }

    public function fetchTrailBalanceData(Request $req){
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Cash Book')->where('user_id',$user_id)->first();
        
        
        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
         
                $company_info = DB::table('tbl_company')->first();
                $search = $req['projectid'] ?? 0;

                
                $students = TrailBalanceDebit::all()
                            ->where('ProjectID','=',$search)
                            ->whereIn('header_code', [301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,500,501,503,504,505,506,703])
                            ->where('SumOfDebit','!=',0)
                            ->groupBy('account_type');
                            
               
            $creditsidecust = DB::table('cashbook')
                ->join('tbl_application','cashbook.account_id','=','tbl_application.id')
                ->select('sort_by','cashbook.header_code','tbl_application.category','tbl_application.project_id', DB::raw('SUM(cashbook.credit-cashbook.debit) as SumOfCreditCust'))
                ->groupBy('sort_by','cashbook.header_code','tbl_application.category','tbl_application.project_id')
                ->where('cashbook.header_code','=',101)
                ->where('tbl_application.Cancelled','=',0)
                ->havingRaw('SUM(cashbook.credit-cashbook.debit) <> ?', [0])
                ->where('tbl_application.project_id','=',$search)
                ->orderBy('sort_by','asc')                
               ->get();


            //dd($creditsidecust);
            
            $header_code = DB::table('cashbook')
            ->select('header_code',DB::raw('SUM(credit-debit) as GroupTotal'))
            ->groupBy('header_code')
            ->whereIn('header_code', [601,201,702,502])
             ->where('ProjectID',$search)  
            ->havingRaw('SUM(credit-debit) <> ?', [0])
            ->get();

            $accounts = DB::table('cashbook')
            ->select('account_id','account_name','header_code',DB::raw('SUM(credit-debit)  as SumOfCredit'))
            ->groupBy('account_id','account_name','header_code')
            ->whereIn('header_code', [601,201,702,502])
             ->where('ProjectID',$search)         
            ->get();
            
   
            
            
            $types = DB::table('tbl_account')->select('header_code','account_type')
                    ->groupBy('header_code','account_type')
                    ->get();    
                    

    	if($users_menu->role == 0){
                 if($users_menu->user_read == 1){
                       
    			    return view('reports.trailbalance',compact('students','creditsidecust','projectdata','header_code','accounts','types','company_info'));
    			    
                 }
             else{
              return view('/restricted');
                   
             }
            }
             
             if($users_menu->role == 1){
                return view('reports.trailbalance',compact('students','creditsidecust','projectdata','header_code','accounts','types','company_info'));
             }
        
}
    
    public function fetchInstallmentData(Request $req){
        
             $company_info = DB::table('tbl_company')->first();
             $ldate = date('Y-m-d');
             $search = $req['projectid'] ?? 0;
             
             
                        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Cash Book')->where('user_id',$user_id)->first();
        
        
        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
            
            
             $customers =  InstallmentModel::all()       
                            ->where('project_id','=',$search)
                            ->where('Cancelled','=',0)
                            ->where('header_code','=',101)
                            ->groupBy('category');
                            
             $sumtotalcost=DB::table('tbl_application')
                            ->where('project_id','=',$search)
                            ->where('Cancelled','=',0)
                            ->sum('total_cost');

        
        $due = DB::table('tblSchdule')
        ->selectRaw('customer_id, sum(installment_amount) as total')
        ->whereBetween('installment_date', ['2000-03-01', Carbon::today()])
        ->groupBy('customer_id')
        ->get();

        $last = DB::table('last_transection')->get();    
        

	
    	if($users_menu->role == 0){
                 if($users_menu->user_read == 1){
                       
    			    return view('reports.installment',compact('customers','projectdata','sumtotalcost','due','last','company_info'));
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
                return view('reports.installment',compact('customers','projectdata','sumtotalcost','due','last','company_info'));
             }
        
             


    }
    
    public function floor_wise_return(Request $req){
        
             $company_info = DB::table('tbl_company')->first();
             $ldate = date('Y-m-d');
             $search = $req['projectid'] ?? 0;
             
             
                        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Cash Book')->where('user_id',$user_id)->first();
        
        
        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
            
            
        $customers = DB::table('vw_CustomerReturn')       
            ->where('header_code', 101)
            ->where('SumOfReturn', '>', 0)
            ->when($search, function ($query, $search) {
                return $query->where('project_id', $search);
            })
            ->orderBy('project_id')
            ->get();

                            

                            
            return view('reports.FloorWiseReturn',compact('customers','projectdata','company_info'));

    }
    
    public function floor_wise_recovery(Request $req){
        
             $company_info = DB::table('tbl_company')->first();
             $ldate = date('Y-m-d');
             $search = $req['projectid'] ?? 0;
             
             
                        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Cash Book')->where('user_id',$user_id)->first();
        
        
        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
            
            
             $customers =  InstallmentModel::all()       
                            ->where('project_id','=',$search)
                            ->where('Cancelled','=',0)
                            ->where('header_code','=',101)
                            ->groupBy('category');
                            
             $sumtotalcost=DB::table('tbl_application')
                            ->where('project_id','=',$search)
                            ->where('Cancelled','=',0)
                            ->sum('total_cost');

        
        $due = DB::table('tblSchdule')
        ->selectRaw('customer_id, sum(installment_amount) as total')
        ->whereBetween('installment_date', ['2000-03-01', Carbon::today()])
        ->groupBy('customer_id')
        ->get();

        $last = DB::table('last_transection')->get();    
        

	
    	if($users_menu->role == 0){
                 if($users_menu->user_read == 1){
                       
    			    return view('reports.FloorWiseRecovery',compact('customers','projectdata','sumtotalcost','due','last','company_info'));
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
                return view('reports.FloorWiseRecovery',compact('customers','projectdata','sumtotalcost','due','last','company_info'));
             }
        
             


    }
    
    public function ledgerview(Request $req){


        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Account ledger')->where('user_id',$user_id)->first();
        
        
        $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
            
        $newDateTime = Carbon::now()->subYear(20);
        
        
    	if($users_menu->role == 0){
    	    
                 if($users_menu->user_read == 1){
                        echo $users_menu->role;
    			        return view('reports.ledgerview',compact('projectdata','newDateTime'));
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
            return view('reports.ledgerview',compact('projectdata','newDateTime'));
             }
        
        
         

    }
    
    public function utility_charges(Request $req){
        
             $company_info = DB::table('tbl_company')->first();
             $ldate = date('Y-m-d');
             $search = $req['projectid'] ?? 0;
             $projectdata = Projects::all();
             
             $utility =  DB::table('utilit_charges')       
                            ->where('project_id','=',$search)
                            ->get();
        
             return view('reports.utility_charges',compact('company_info','projectdata','utility'));
        

        
    }
    

}
