<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Projects;
use App\Models\Accounts;
use App\Models\RvoucherModel;
use Illuminate\Support\Facades\DB;
use DataTables;

class Rvoucher extends Controller
{
    
    public function numberToWord($num = ''){
        $num    = ( string ) ( ( int ) $num );
        
        if( ( int ) ( $num ) && ctype_digit( $num ) )
        {
            $words  = array( );
             
            $num    = str_replace( array( ',' , ' ' ) , '' , trim( $num ) );
             
            $list1  = array('','one','two','three','four','five','six','seven',
                'eight','nine','ten','eleven','twelve','thirteen','fourteen',
                'fifteen','sixteen','seventeen','eighteen','nineteen');
             
            $list2  = array('','ten','twenty','thirty','forty','fifty','sixty',
                'seventy','eighty','ninety','hundred');
             
            $list3  = array('','thousand','million','billion','trillion',
                'quadrillion','quintillion','sextillion','septillion',
                'octillion','nonillion','decillion','undecillion',
                'duodecillion','tredecillion','quattuordecillion',
                'quindecillion','sexdecillion','septendecillion',
                'octodecillion','novemdecillion','vigintillion');
             
            $num_length = strlen( $num );
            $levels = ( int ) ( ( $num_length + 2 ) / 3 );
            $max_length = $levels * 3;
            $num    = substr( '00'.$num , -$max_length );
            $num_levels = str_split( $num , 3 );
             
            foreach( $num_levels as $num_part )
            {
                $levels--;
                $hundreds   = ( int ) ( $num_part / 100 );
                $hundreds   = ( $hundreds ? ' ' . $list1[$hundreds] . ' Hundred' . ( $hundreds == 1 ? '' : 's' ) . ' ' : '' );
                $tens       = ( int ) ( $num_part % 100 );
                $singles    = '';
                 
                if( $tens < 20 ) { $tens = ( $tens ? ' ' . $list1[$tens] . ' ' : '' ); } else { $tens = ( int ) ( $tens / 10 ); $tens = ' ' . $list2[$tens] . ' '; $singles = ( int ) ( $num_part % 10 ); $singles = ' ' . $list1[$singles] . ' '; } $words[] = $hundreds . $tens . $singles . ( ( $levels && ( int ) ( $num_part ) ) ? ' ' . $list3[$levels] . ' ' : '' ); } $commas = count( $words ); if( $commas > 1 )
            {
                $commas = $commas - 1;
            }
             
            $words  = implode( ', ' , $words );
             
            $words  = trim( str_replace( ' ,' , ',' , ucwords( $words ) )  , ', ' );
            if( $commas )
            {
                $words  = str_replace( ',' , ' and' , $words . ' only');
            }
             
            return $words;
        }
        else if( ! ( ( int ) $num ) )
        {
            return 'Zero';
        }
        return '';
    }
  
    public function fetchAccounts(Request $request){
        $id = $request->post('projectid');
        $account['accounts']=Accounts::where('project_id',$id)->get();
        return response()->json($account);
   
       }
    
    public function getProjectName(){

        
        $accountdata = Accounts::all();
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Receiving Vouchers')->where('user_id',$user_id)->first();
                $projectdata = DB::table('tbl_projects')
            ->join('tbl_users_sub', 'tbl_projects.id', '=', 'tbl_users_sub.project_id')
            ->select('tbl_projects.*')
            ->where('user_id',$user_id)
            ->where('user_read',1)
            ->get();
	
    	if($users_menu->role == 0){
                 if($users_menu->user_add == 1){
                       
    			        return view('Rvoucher.add',compact('projectdata','accountdata','users_menu'));
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
            return view('Rvoucher.add',compact('projectdata','accountdata','users_menu'));
             }
    }
    
    public function addNew(Request $request){

            $request->validate(
                [
                    'projectid' => 'required',
                    'accountid' => 'required',
                    'headercode' => 'required',
                    'account_name' => 'required',
                ]);
                
                $current_date = date('Y-m-d');
    
            $lastid = DB::table('tbl_credit_vouchers')->insertGetId([
         'header_code' => $request->headercode,
         'ProjectID' => $request->projectid,
         'ProjectName' => $request->project_name,
         'account_name' =>$request->account_name,
         'account_id' => $request->accountid,
         'payment_type' => $request->payment_type,
         'total_amount' => $request->amount,
         'description' => $request->desc,
         'cvdate' => $request->date,
         'last_updated_person' => session()->get('user_name')
        ]);
        
           

        //  echo "<pre>";
        //  print_r($request->all());
        //  echo "</pre>";
    
        return $lastid;
    }

    public function index(Request $req){
        
        $accounts = DB::table('allinoneaccounts')->orderBy('customer_name','asc')->get();
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Receiving Vouchers')->where('user_id',$user_id)->first();
        
        $search = $req['search'] ?? "";
        $sortby = $req['sortby'];

        
        
        
         if($search != ""){        
            
            if($req->sortby == 'receipt'){
            
               $data = DB::table('receiving_voucher')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
               ->where('id','=',"$search")
                ->orderBy('cvdate','desc')
                ->Paginate(10);
                
            }            

            if($req->sortby == 'project_name'){
            
               $data = DB::table('receiving_voucher')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
               ->where('ProjectName','LIKE',"%$search%")
                ->orderBy('cvdate','desc')
                ->Paginate(10);
                
            }
            
            elseif($req->sortby == 'account_name'){
                
               $data = DB::table('receiving_voucher')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
                ->where('account_name','LIKE',"%$search%")
                ->orderBy('cvdate','desc')
                ->Paginate(10);
            }
            
            elseif (!isset($req->sortby)){
            
                $data = DB::table('receiving_voucher')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })
                ->orWhere('id','=',$search)
                ->orWhere('cvdate','=',$search)
                ->orderBy('cvdate','desc')
                ->Paginate(10);
            }

            
         }
         
         else{
            
            $data =DB::table('receiving_voucher')->orderBy('id','desc')->whereIn('ProjectID', function($query) {
            $query->select('project_id')->from('tbl_users_sub')->where('user_read',1)->where('user_id',session()->get('user_id'));
        })->Paginate(10);
         } 
         
        
	
    	if($users_menu->role == 0){
                 if($users_menu->user_read == 1){
                       
    			    return view('Rvoucher.index',compact('data','search','sortby','users_menu','accounts'));
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
			return view('Rvoucher.index',compact('data','search','sortby','users_menu','accounts'));
             }



         
        
         
    }

    public function edit($id){

        $projectdata = Projects::all();
        $accountdata = Accounts::all();
        $record = RvoucherModel::find($id);
        
        $selected_accounts = Accounts::where('project_id',$record->ProjectID)->get();
        
        
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Receiving Vouchers')->where('user_id',$user_id)->first();
	
    	if($users_menu->role == 0){
                 if($users_menu->user_edit == 1){
    			    return view('Rvoucher.edit',compact('projectdata','accountdata','record','users_menu','selected_accounts'));
                 }
             else{
                  return view('/restricted');
             }
            }
             if($users_menu->role == 1){
			return view('Rvoucher.edit',compact('projectdata','accountdata','record','users_menu','selected_accounts'));
             }


             
         
        
        
    }
    
    public function delete($id){
        
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Receiving Vouchers')->where('user_id',$user_id)->first();
	
    	if($users_menu->role == 0){
                 if($users_menu->user_delete == 1){
    			        DB::table('tbl_credit_vouchers')->where('id',$id)->delete();
    return redirect('/Rvoucher/index');
                 }
             else{
                  return view('/restricted');
             }
            }
             if($users_menu->role == 1){
			    DB::table('tbl_credit_vouchers')->where('id',$id)->delete();
                return redirect('/Rvoucher/index');
             }




        
    }

    public function update($id, Request $request){

        $request->validate(
            [
                'projectid' => 'required',
                
                'accountid' => 'required',
                'headercode' => 'required',
                'account_name' => 'required',
            ]);
        $Rvoucher = RvoucherModel::find($id);
        $Rvoucher->manual_no = $request->manual_no;
        $Rvoucher->ProjectName = $request->project_name;
        $Rvoucher->ProjectID = $request->projectid;
        $Rvoucher->header_code = $request->headercode;
        $Rvoucher->account_id = $request->accountid;
        $Rvoucher->account_name = $request->account_name;
        $Rvoucher->total_amount = $request->amount;
        $Rvoucher->payment_type = $request->payment_type;
        $Rvoucher->description = $request->desc;          
        $Rvoucher->cvdate = $request->date;          
    
        $Rvoucher->last_updated_person = session()->get('user_name');
        $Rvoucher->save();
        
        
        
        
        return redirect('/Rvoucher/index');
        
        


  }

    public function show($id){


    $projectdata = Projects::all();
    $accountdata = Accounts::all();
    $record = RvoucherModel::find($id);
    $inword = $this->numberToWord($record->total_amount);  
    return view('Rvoucher.show',compact('projectdata','accountdata','record','inword'));
   

}



}
