<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Projects;
use App\Models\Accounts;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class Sale extends Controller
{
        public function fetchCustomers(Request $request){
        
        $id = $request->POST('projectid');        
        $account['accounts']=DB::table('tbl_account')->where('header_code','=',101)->where('project_id',$id)->get();
        return response()->json($account);
        
       }  
       
       
    public function delete($id){
        
                
        $user_id = session()->get('user_id');
        $users_menu = DB::table('tbl_users_sub')->where('menu_name','=','Customer Receipts')->where('user_id',$user_id)->first();
	
    	if($users_menu->role == 0){
                 if($users_menu->user_delete == 1){
                       
        	DB::table('tbl_sale_sub')->where('inv_id',$id)->delete();
        	DB::table('tbl_sale')->where('id',$id)->delete();
            return redirect('/Sale/index');
                 }
             else{
                  return view('/restricted');
             }
            }
             
             if($users_menu->role == 1){
            
                    DB::table('tbl_sale_sub')->where('inv_id',$id)->delete();
    	            DB::table('tbl_sale')->where('id',$id)->delete();
                    return redirect('/Sale/index');
             }
        
        
    }
    
    public function index(Request $req){
        
        
        $accounts = DB::table('allinoneaccounts')->orderBy('customer_name','asc')->get();
        
        $search = $req['search'] ?? "";
        $sortby = $req['sortby'];

        
         if($search != ""){        
            


            if($req->sortby == 'project_name'){
            
               $data = DB::table('tbl_sale')
               ->where('project_name','LIKE',"%$search%")
                ->orderBy('inv_date','desc')
                ->Paginate(10);
                
            }
            
            elseif($req->sortby == 'account_name'){
                
               $data = DB::table('tbl_sale')
                ->where('account_name','LIKE',"%$search%")
                ->orderBy('inv_date','desc')
                ->Paginate(10);
            }

            elseif (!isset($req->sortby)){
                
                $data = DB::table('tbl_sale')

                ->orWhere('id','=',$search)
                ->orWhere('account_name','LIKE',"%$search%")
                ->orderBy('inv_date','desc')
                ->Paginate(10);
            }
            
         }
         else{
             $data = DB::table('tbl_sale')->Paginate(10);;
         }
         
         return view('Sale.index',compact('data','search','sortby','accounts'));
    }
    
    public function open(){
        
        $projects = DB::table('tbl_projects')->get();
        $accounts = DB::table('tbl_account')->get();
        $category = DB::table('tbl_category')->get();
        $type = DB::table('tbl_type')->get();
        
        $items = DB::table('tbl_items')->where('active_yn', '=', 'on')->get();
        //
        
        return view('Sale.add',compact('accounts','items','projects','category','type'));

    }
    
    public function add(Request $request){
          
          
    $request->validate(
            [
                'inv_date' => 'required',
                'item_id' => 'required',
            ]);



    
    $lastid = DB::table('tbl_sale')->insertGetId([
         'header_code' => $request->header_code,
         'project_id' => $request->project_id,
         'project_name' => $request->project_name,
         'account_id' => $request->account_id,
         'account_name' => $request->account_name,
         'inv_date' => $request->inv_date,
         'entered_by' => $request->entered_by,
         'manual_no' => $request->manual_no
        ]);
        

        
    $item_id = $request->item_id;
    $item_name = $request->item_name;
    $type = $request->type;
    $qty = $request->qty;

          
    for ($i=0; $i<count($item_name); $i++) {
      
      $datasave = [
      'inv_id' => $lastid,
      'item_id' => $item_id[$i],
      'item_name' => $item_name[$i],
      'type' => $type[$i],
      'qty' => $qty[$i]
     
      ];
      
      DB::table('tbl_sale_sub')->insert($datasave);
    }
    
    
    return $lastid;
    
         
 


          

    
    }
    
    public function edit($id){
        
        $projects = DB::table('tbl_projects')->get();
        $accounts = DB::table('tbl_account')->get();
        $category = DB::table('tbl_category')->get();
        $type = DB::table('tbl_type')->get();
        $items = DB::table('tbl_items')->where('active_yn', '=', 'on')->get();
        $record = DB::table('tbl_sale')->find($id);
        $record_sub = DB::table('tbl_sale_sub')->where('qty','>',0)->where('inv_id',$id)->get();
        
        return view('Sale.edit',compact('projects','accounts','category','type','items','record','record_sub'));
        
        //return $purchase_sub;
    }
    
    public function update($id,Request $request){
        
        
            $request->validate(
            [
                'inv_date' => 'required',
                'item_id' => 'required',
            ]);
            
        
            DB::table('tbl_sale')->where('id',$id)
        ->update([
        'project_id' => $request->project_id,
        'project_name' => $request->project_name,
        'header_code' => $request->header_code,
        'account_id' => $request->account_id,
        'account_name' => $request->account_name,
        'inv_date' => $request->inv_date,
        'manual_no' => $request->manual_no,
        'entered_by' => $request->entered_by
        ]);
        
        

        $inv_no = $request->invoice_no;
          $item_id = $request->item_id;
          $item_name = $request->item_name;
          $type = $request->type;
          $qty = $request->qty;
          $id= $request->id;
          
          for ($i=0; $i<count($item_name); $i++) {
              
              if (empty($id[$i])) {
                
                              $datasave = [
                          'inv_id' => $inv_no,
                          'item_id' => $item_id[$i],
                          'item_name' => $item_name[$i],
                          'type' => $type[$i],
                          'qty' => $qty[$i]
                          ];    
                   DB::table('tbl_sale_sub')->insert($datasave);
                }
              else{
              
              $datasave = [
              
              'item_id' => $item_id[$i],
              'item_name' => $item_name[$i],
              'type' => $type[$i],
              'qty' => $qty[$i]
              ];
              
              
              DB::table('tbl_sale_sub')->where('id',$id[$i])->update($datasave);
              }
          }    
    
        
       return $datasave;
       
       
       
    }
}
