<?php
// Enable error reporting
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Database configuration
$DB_HOST = 'localhost';           // usually 'localhost'
$DB_USER = 'alameenb_alameenb';   // your DB username
$DB_PASS = '6ki6XE;YGO~0';       // your DB password
$DB_NAME = 'alameenb_db';         // your database name

// Connect to database
$mysqli = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);

// Check connection
if ($mysqli->connect_error) {
    die('Connection failed: ' . $mysqli->connect_error);
} else {
    echo "Database connected successfully!<br>";
}

// Get all table names
$tables = [];
$result = $mysqli->query("SHOW TABLES");
if (!$result) {
    die('Error fetching tables: ' . $mysqli->error);
}

// Fetch tables and debug
echo "Fetching Tables: <br>";
while ($row = $result->fetch_row()) {
    echo "Table found: " . $row[0] . "<br>"; // Displaying tables found
    $tables[] = $row[0];
}

// If no tables found, print an error
if (count($tables) == 0) {
    die("No tables found in the database.");
}

// Set header for download
header('Content-Type: application/sql');
header('Content-Disposition: attachment; filename="' . $DB_NAME . '_backup_' . date('Y-m-d_H-i-s') . '.sql"');

$output = "";

// Loop through tables and check data
foreach ($tables as $table) {
    // Fetch table creation query
    $createTableResult = $mysqli->query("SHOW CREATE TABLE `$table`");
    if (!$createTableResult) {
        die('Error fetching create table query: ' . $mysqli->error);
    }
    $createTableRow = $createTableResult->fetch_row();
    $output .= "\n\n" . $createTableRow[1] . ";\n\n";

    // Fetch table data
    $result = $mysqli->query("SELECT * FROM `$table`");
    if (!$result) {
        die('Error fetching data from table ' . $table . ': ' . $mysqli->error);
    }

    $num_fields = $result->field_count;
    echo "Processing table: $table, Rows: " . $result->num_rows . "<br>"; // Debugging number of rows

    // Insert data
    while ($row = $result->fetch_row()) {
        $output .= "INSERT INTO `$table` VALUES(";
        for ($j = 0; $j < $num_fields; $j++) {
            $row[$j] = $row[$j] !== null ? "'" . $mysqli->real_escape_string($row[$j]) . "'" : "NULL";
            $output .= $row[$j];
            if ($j < ($num_fields - 1)) $output .= ',';
        }
        $output .= ");\n";
    }
}

// Output the SQL file to download
echo "Export completed. File will download shortly...<br>";
echo "<pre>" . htmlspecialchars($output) . "</pre>"; // Show generated SQL content

echo $output; // Output the SQL file to download
exit;
?>
