@extends('header')
@section('title','Application Form')
@section('main')
<div class="container bg-light py-3 px-3 rounded-3">
<h2 style="font-family: Fantasy;">Application Form</h2></br>
   <form action="{{url('/Application/add')}}" method="post">
      @csrf
      <div class="row g-1  mb-3">
         <div class="col-1">
             <small>Project Id</small>
            <input type="text" class="form-control form-control-sm" value="{{ old('projectid') }}" name="projectid" id="projectid" placeholder="Project ID" >
         </div>
         <div class="col-3">
             <small>Project Name</small>
            <select class="form-control form-control-sm  m-bot15" id="project_name" name="project_name">
               <option value="{{ old('project_name') }}" selected>
                  @if(old('project_name')== null)
                  Select Your Project
                  @else
                  {{ old('project_name') }}
                  @endif
               </option>
               @foreach($projectdata as $data)
               <option data-id="{{ $data->id }}" value="{{ $data->project_name }}">{{ $data->project_name }}</option>
               @endforeach
            </select>
            <span class="text-danger">
               @error('projectid')
               <p>Please select your Project</p>
               @enderror
            </span>
         </div>
         <div class="col-4">
             <small>Category</small>
            <select class="form-select form-select-sm" name="category">
               <option value="{{ old('category')  }}" selected>{{ old('category') ?? '--Select Your Category'}} </option>
               <option value="Lower Ground">Lower Ground</option>
               <option value="Upper Ground">Upper Ground</option>
               <option value="Mezzanine">Mezzanine</option>
               <option value="1st Floor">1st Floor</option>
               <option value="2nd Floor">2nd Floor</option>
               <option value="3rd Floor">3rd Floor</option>
               <option value="4th Floor">4th Floor</option>
               <option value="5th Floor">5th Floor</option>
               <option value="Roof">Roof</option>
               <option value="Ground">Ground</option>
               <option value="Basement">Basement</option>
            </select>
            <span class="text-danger">
               @error('category')
               <p>Please select your category</p>
               @enderror
            </span>
         </div>
         <div class="col-4">
             <small>Unit Type</small>
            <select class="form-select form-select-sm" name="unit_type" aria-label="Default select example">
               <option value="{{ old('unit_type')  }}" selected>{{ old('unit_type') ?? '--Select Your UNIT Type'}} </option>
               <option value="SHOP">SHOP</option>
               <option value="FLAT">FLAT</option>
               <option value="OFFICE">OFFICE</option>
               <option value="HALL">HALL</option>
            </select>
            <span class="text-danger">
               @error('unit_type')
               <p>Please select your unit_type</p>
               @enderror
            </span>
         </div>
      </div>
      <div class="row  g-1  mb-3">
         <div class="col-4">
             <small>Unit No</small>
            <input type="text" class="form-control  form-control-sm" value="{{ old('unit_no') }}" name="unit_no" placeholder="Unit No" >
            <span class="text-danger">
               @error('unit_no')
               <p>Please select your unit_no</p>
               @enderror
            </span>
         </div>
         <div class="col-4">
             <small>Customer Name</small>
            <input type="text" class="form-control  form-control-sm" value="{{ old('customer_name') }}" name="customer_name" placeholder="Customer Name">
            <span class="text-danger">
               @error('customer_name')
               <p>Please select your customer_name</p>
               @enderror
            </span>
         </div>
         <div class="col-4">
             <small>Father Name</small>
            <input type="text" class="form-control  form-control-sm" value="{{ old('customer_father_name') }}" name="customer_father_name" placeholder="S/O - W/O - D/O">
         </div>
      </div>
      <div class="row g-1 mb-3">
         <div class="col-12">
             <small>Address</small>
            <input type="text" class="form-control  form-control-sm" value="{{ old('customer_address') }}" name="customer_address" placeholder="Address" >
         </div>

      </div>
      <div class="row g-1 mb-3">
         <div class="col-6">
             <small>Utility Charges</small>
            <input type="text" class="form-control  form-control-sm" value="{{ old('utility_charges') }}" name="utility_charges" placeholder="utility charges" >
         </div>
         <div class="col-6">
             <small>Mobile</small>
            <input type="text" class="form-control  form-control-sm" value="{{ old('customer_mobile') }} " name="customer_mobile" placeholder="Mobile No">
         </div>
      </div>
      <div class="row g-1 mb-3">
         <div class="col-3">
             <small>CNIC</small>
            <input type="text" class="form-control  form-control-sm" value="{{ old('cnid') }} " name="cnic" placeholder="CNIC" >
         </div>
         <div class="col-3">
             <small>Date Of Booking</small>
            <input onfocus="(this.type='date')" class="form-control  form-control-sm" name="date_of_booking"  placeholder="Date Of Booking">
                        <span class="text-danger">
               @error('date_of_booking')
               <p>Please select your Booking Date</p>
               @enderror
            </span>
         </div>
         <div class="col-3">
             <small>Booking Amount</small>
            <input type="text" class="form-control  form-control-sm" name="booking" value="{{ old('booking') }}" placeholder="Booking Amount">
         </div>
         <div class="col-3">
             <small>Sort By</small>
            <input type="text" class="form-control  form-control-sm" name="sort_by" value="{{ old('sort_by') }}" placeholder="Sort By">
         </div>                         
      </div>
      <div class="row g-1 mb-3">
         <div class="col-3">
            <small>Installment Starting Date</small> 
            <input onfocus="(this.type='date')" class="form-control  form-control-sm" name="installment_start"  placeholder="Installment Date" >
         </div>
         <div class="col-3">
             <small>Installment Amount</small>
            <input type="text" class="form-control  form-control-sm" name="installment" value="{{ old('installment') }}" placeholder="Instalment Amount">
         </div>
         <div class="col-3">
             <small>Total Cost</small>
            <input type="text" class="form-control  form-control-sm" name="total_cost" value="{{ old('total_cost') }}" placeholder="Total Cost">
         </div>
         <div class="col-3">
             <small>Installment Years</small>
            <input type="number" class="form-control  form-control-sm" name="years" value="{{ old('years') }}" placeholder="Installment Years">
            <span class="text-danger">
               @error('years')
               <p>Enter Your Installment Years</p>
               @enderror
            </span>
         </div>         
      </div>
      
        <div class="row g-1 mb-3">
         <div class="col-6">
            <small>Broker Name</small> 
            <input type="hidden" class="form-control  form-control-sm" name="broker_id" value="{{ old('broker_id') }}" id="broker_id">
            <select class="form-control form-control-sm  m-bot15" id="broker_name" name="broker_name">
               <option value="{{ old('broker_name') }}" selected>
                  @if(old('broker_name')== null)
                  Select Your Project
                  @else
                  {{ old('broker_name') }}
                  @endif
               </option>
               @foreach($brokerName as $data)
               <option data-id="{{ $data->id }}" value="{{ $data->account_name }}">{{ $data->account_name }}</option>
               @endforeach
            </select>
         </div>
         <div class="col-6">
            <small>Brokery Amount</small> 
            <input type="number" class="form-control  form-control-sm" name="broker_amount" >
         </div>

        </div>
      </br>
      <h4 style="font-family: Fantasy;">Nominees</h4>
      <div class="row g-1 mb-3">
         <div class="col-4">
            <input type="text" class="form-control  form-control-sm" name="nominee_name" value="{{ old('nominee_name') }}" placeholder="Nominees Name" >
         </div>
         <div class="col-4">
            <input type="text" class="form-control  form-control-sm" name="s_d_f" value="{{ old('s_d_f') }}" placeholder="S/O - W/O - D/O">
         </div>
         <div class="col-4">
            <input type="text" class="form-control  form-control-sm" name="nominee_cnic" value="{{ old('nominee_cnic') }}" placeholder="CNIC">
         </div>
      </div>
      <div class="row g-1 mb-3">
         <div class="col-4">
            <input type="text" class="form-control  form-control-sm" name="nominee_mobile" value="{{ old('nominee_mobile') }}" placeholder="Mobile No" >
         </div>
         <div class="col-4">
            <input type="text" class="form-control  form-control-sm" name="nominee_address" value="{{ old('nominee_address') }}"  placeholder="Address">
         </div>
         <div class="col-4">
            <input type="text" class="form-control  form-control-sm" name="relation" value="{{ old('relation') }}"  placeholder="relation">
         </div>
      </div>
      <div class="row g-5 mb-3">
         <div class="col-4"></div>
         <div class="col-auto form-check">
            <input class="form-check-input" type="checkbox" value="{{ old('cancelled') }}" name="cancelled" >
            <label class="form-check-label" for="flexCheckDefault">
            Cancelled
            </label>
         </div>
         <div class="col-auto form-check">
            <input class="form-check-input" type="checkbox" value="{{ old('vacant') }}" name="vacant" >
            <label class="form-check-label" for="flexCheckChecked">
            Vacant
            </label>
         </div>
         <div class="col-auto form-check">
            <input class="form-check-input" type="checkbox" value="{{ old('removed') }}" name="removed">
            <label class="form-check-label" for="flexCheckChecked">
            Remove
            </label>
         </div>
      </div>
      <div class="row">
         <div class="col-4"></div>
         <div class="d-grid col-2">
            <button class="btn btn-success" type="submit">Save/Close</button>
         </div>
         
         <div class="d-grid col-2">            
            <button class="btn btn-primary" onclick="relocate_home()" type="button">Cancel/Close</button>
         </div>
        
      </div>
   </form>
</div>
<script>
    function relocate_home()
{
     location.href = "/home";
} 
   $('#project_name').change(function(){
       
       var selected = $(this).find('option:selected');    
       var projectid = selected.data('id');
       $('#projectid').val( projectid );
       
   });
      $('#broker_name').change(function(){
       
       var selected = $(this).find('option:selected');    
       var broker_id = selected.data('id');
       $('#broker_id').val( broker_id );
       
   });
</script>
@endsection