@extends('header')
@section('title','Edit Application Form')
@section('main')



<div class="container mt-3">
   <form action="{{url('/Application/update')}}/{{$record->id}}" method="post">
      @csrf
      <input type="hidden" value="{{url()->previous()}}" name="last_url">

                    <h3>Edit Application Form</h3>
        
      <div class="row">
      <div class="col-12">
           <div class="row g-1  mb-3">
         <div class="col-1">
             <lable>Project Id</lable>
            <input type="text" class="form-control  rounded-0" value="{{$record->project_id}}" name="projectid" id="projectid" placeholder="Project ID" >
         </div>
         <div class="col-3">
             <lable>Project Name</lable>
            <select class="form-control rounded-0  m-bot15" id="project_name" name="project_name">
               <option value="{{ $record->project_name }}" selected>{{ $record->project_name }}</option>
               @foreach($projectdata as $data)
               <option data-id="{{ $data->id }}" value="{{ $data->project_name }}">{{ $data->project_name }}</option>
               @endforeach
            </select>
            <span class="text-danger">
               @error('projectid')
               <p>Please select your Project</p>
               @enderror
            </span>
         </div>
         <div class="col-4">
             <lable>Category</lable>
            <select class="form-select rounded-0" name="category">
               <option value="{{ $record->category }}" selected>{{ $record->category }}</option>
               <option value="Lower Ground">Lower Ground</option>
               <option value="Upper Ground">Upper Ground</option>
               <option value="Mezzanine">Mezzanine</option>
               <option value="1st Floor">1st Floor</option>
               <option value="2nd Floor">2nd Floor</option>
               <option value="3rd Floor">3rd Floor</option>
               <option value="4th Floor">4th Floor</option>
               <option value="5th Floor">5th Floor</option>
               <option value="Roof">Roof</option>
               <option value="Ground">Ground</option>
               <option value="Basement">Basement</option>
            </select>
            <span class="text-danger">
               @error('category')
               <p>Please select your category</p>
               @enderror
            </span>
         </div>
         <div class="col-4">
             <lable>Unit Type</lable>
            <select class="form-select rounded-0" name="unit_type" aria-label="Default select example">
               <option value="{{ $record->unit_type }}" selected>{{ $record->unit_type }} </option>
               <option value="SHOP">SHOP</option>
               <option value="FLAT">FLAT</option>
               <option value="OFFICE">OFFICE</option>
               <option value="HALL">HALL</option>
            </select>
            <span class="text-danger">
               @error('unit_type')
               <p>Please select your unit_type</p>
               @enderror
            </span>
         </div>
      </div>
      <div class="row g-1  mb-3">
         <div class="col-4">
             <lable>Unit No</lable>
            <input type="text" class="form-control  rounded-0" value="{{ $record->unit_no }}" name="unit_no" placeholder="Unit No" >
            <span class="text-danger">
               @error('unit_no')
               <p>Please select your unit_no</p>
               @enderror
            </span>
         </div>
         <div class="col-4">
             <lable>Customer Name</lable>
            <input type="text" class="form-control  rounded-0" value="{{ $record->customer_name }}" name="customer_name" placeholder="Customer Name">
            <span class="text-danger">
               @error('customer_name')
               <p>Please select your customer_name</p>
               @enderror
            </span>
         </div>
         <div class="col-4">
             <lable>Father</lable>
            <input type="text" class="form-control  rounded-0" value="{{ $record->customer_father_name }}" name="customer_father_name" placeholder="S/O - W/O - D/O">
         </div>
      </div>
      <div class="row g-1 mb-3">
         <div class="col-12">
             <lable>Address</lable>
            <input type="text" class="form-control  rounded-0" value="{{ $record->customer_address }}" name="customer_address" placeholder="Address" >
         </div>


      </div>
      <div class="row g-1 mb-3">
                  <div class="col-6">
             <lable>Utility Charges</lable>
            <input type="text" class="form-control  rounded-0" value="{{ $record->utility_charges}}" name="utility_charges" placeholder="utility charges" >
         </div>
         <div class="col-6">
             <lable>Mobile</lable>
            <input type="text" class="form-control  rounded-0" value="{{ $record->customer_mobile }}" name="customer_mobile" placeholder="Mobile No">
         </div>
      </div>
      <div class="row g-1 mb-3">
         <div class="col-3">
             <lable>CNIC</lable>
            <input type="text" class="form-control  rounded-0" value="{{ $record->CNIC }}" name="cnic" placeholder="CNIC" >
         </div>
         <div class="col-3">
             <lable>Date Of Booking</lable>
            <input type="date" class="form-control  rounded-0" name="date_of_booking"  value="@if (isset($record->date_of_booking)){{$record->date_of_booking}}@else {{ now()->format('Y-m-d') }} @endif"  placeholder="Date Of Booking">
                                    <span class="text-danger">
               @error('date_of_booking')
               <p>Please select your Booking Date</p>
               @enderror
            </span>
         </div>
         <div class="col-3">
             <lable>Booking Amount</lable>
            <input type="text" class="form-control  rounded-0" name="booking" value="{{ $record->booking }}" placeholder="Booking Amount">
         </div>
         <div class="col-3">
             <lable>Sort By</lable>
            <input type="text" class="form-control  rounded-0" name="sort_by" value="{{ $record->sort_by }}" placeholder="Sort By">
         </div>                  
      </div>
      <div class="row g-1 mb-3">
         <div class="col-3">
             <lable>Installment Starting Date</lable>
            <input type="date" class="form-control  rounded-0" name="installment_start" value="@if (isset($record->installment_start)){{$record->installment_start}}@else {{ now()->format('Y-m-d') }} @endif"
               placeholder="Installment Date" >
         </div>
         <div class="col-3">
             <lable>Installment Amount</lable>
            <input type="text" class="form-control  rounded-0" name="installment" value="{{ $record->installment }}" placeholder="Instalment Amount">
         </div>
         <div class="col-3">
             <lable>Total Cost</lable>
            <input type="text" class="form-control  rounded-0" name="total_cost" value="{{ $record->total_cost }}" placeholder="Total Cost">
         </div>
         <div class="col-3">
             <lable>Installment Years</lable>
            <input type="number" class="form-control  rounded-0" name="years" value="{{ $record->years }}" placeholder="Installment Years">
            <span class="text-danger">
               @error('years')
               <p>Enter Your Installment Years</p>
               @enderror
            </span>
         </div>            
         
      </div>
              <div class="row g-1 mb-3">
         <div class="col-6">
            <small>Broker Name</small> 
            <input type="hidden" class="form-control  form-control-sm" name="broker_id" id="broker_id" value="{{ $record->broker_id }}">
            <select class="form-control form-control-sm  m-bot15" id="broker_name" name="broker_name" value="{{ $record->broker_name }}">
               <option value="{{ $record->broker_name }}" selected> {{$record->broker_name}}          </option>
               @foreach($brokerName as $data)
               <option data-id="{{ $data->id }}" value="{{ $data->account_name }}">{{ $data->account_name }}</option>
               @endforeach
            </select>
         </div>
         <div class="col-6">
            <small>Brokery Amount</small> 
            <input type="number" class="form-control  form-control-sm" name="broker_amount" value="{{ $record->broker_amount }}">
         </div>

        </div>
      <br/>
      <h5 class="text-center mb-3">Nominees</h5>
      <div class="row g-1 mb-3">
         <div class="col-4">
            <input type="text" class="form-control  rounded-0" name="nominee_name" value="{{ $record->nominee_name }}" placeholder="Nominees Name" >
         </div>
         <div class="col-4">
            <input type="text" class="form-control  rounded-0" name="s_d_f" value="{{ $record->S_D_F }}" placeholder="S/O - W/O - D/O">
         </div>
         <div class="col-4">
            <input type="text" class="form-control  rounded-0" name="nominee_cnic" value="{{ $record->nominee_cnic }}" placeholder="CNIC">
         </div>

      </div>
      <div class="row g-1 mb-3">
         <div class="col-4">
            <input type="text" class="form-control  rounded-0" name="nominee_mobile" value="{{ $record->nominee_mobile }}" placeholder="Mobile No" >
         </div>
         <div class="col-4">
            <input type="text" class="form-control  rounded-0" name="nominee_address" value="{{ $record->nominee_address }}"  placeholder="Address">
         </div>
         <div class="col-4">
            <input type="text" class="form-control  rounded-0" name="relation" value="{{ $record->relation }}"  placeholder="relation">
         </div>
      </div>
      <div class="row g-5 mb-3">
         <div class="col-4"></div>
         <div class="col-auto form-check">
            <input class="form-check-input" type="checkbox"  name="cancelled"
            {{$record->Cancelled == "1" ? "checked" : ""}}
            <label class="form-check-label" for="flexCheckDefault">
            Cancelled
            </label>
         </div>
         <div class="col-auto form-check">
            <input class="form-check-input" type="checkbox" value="" name="vacant" 
            {{$record->Vacant == "1" ? "checked" : ""}} >
            <label class="form-check-label" for="flexCheckChecked">
            Vacant
            </label>
         </div>
         <div class="col-auto form-check">
            <input class="form-check-input" type="checkbox" value="" name="removed" 
            {{$record->Removed == "1" ? "checked" : ""}}
            >
            <label class="form-check-label" for="flexCheckChecked">
            Remove
            </label>
         </div>
      </div>
      <div class="row">
         <div class="col-4"></div>
         <div class="d-grid col-2">
            <button class="btn btn-success" type="submit">Save/Close</button>
         </div>
         <div class="d-grid col-2">
            
            <button class="btn btn-primary" onclick="relocate_home()" type="button">Cancel/Close</button>     
            
         </div>
      </div>
      </div>
      
     </div>
   </form>
</div>
<script>

$('tbody').on('click', '.deleteRow', function(){
    console.log ($(this).parent().parent().index());
});


        function relocate_home()
{
     location.href = "/home";
} 
   $('#project_name').change(function(){
   
       var selected = $(this).find('option:selected');    
       var projectid = selected.data('id');
       $('#projectid').val( projectid );
       
   });
   
         $('#broker_name').change(function(){
       
       var selected = $(this).find('option:selected');    
       var broker_id = selected.data('id');
       $('#broker_id').val( broker_id );
       
   });
</script>
@endsection
