@extends('header')
@section('title','Application Forms')
@section('main')


        <div  class="container shadow border-top rounded-top border-2 border-primary bg-light">
                <div class="row"> 
                     <div class="col-4 d-flex justify-content-left mt-3">
                            @if($users_menu->user_add == 1)
                                <a href="{{url('/Application/add')}}">
                                    <button type="submit" class="btn btn-sm btn-dark">Add New &nbsp; <i class="fa-solid fa-plus icon-white"></i></button>
                                </a>
                            @endif
                        
                    </div>
                    <div class="col-4  d-flex justify-content-center mt-2">                
                           <h1 style="font-family: 'Brush Script MT', cursive;">Application Form</h1>
                    </div>
                   
                    <div class="col-4 mt-3 d-flex justify-content-end">
                        <form class="row">
                            <div class="col-auto ">
                                
                                
                        <input list="project_name_options" id="search" type="search" name="search" placeholder="Project Name" autocomplete="off" class="form-control form-control-sm">
                        
                        <datalist id="project_name_options">
                                @foreach($projectdata as $data1)
                                <option data-id="{{ $data1->id }}" value="{{ $data1->project_name }}"> 
                            @endforeach
                        </datalist>
                            </div>

                            
                        </form>
                    </div>
                </div>

                        
                 <div class="table-responsive ">
                    
                        <table class="table table-sm table-hover mt-3">
            
                            <thead>
                                <tr >
                                <th scope="col">Project</th>
                                <th scope="col">ID#</th>
                                <th scope="col">Customer Name</th>
                                <th scope="col">Category</th>
                                <th scope="col">Unit Type</th>
                                <th scope="col">Unit No</th>
                                <th scope="col" class="text-center">Cancelled</th>
                                <th class="text-center" scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($data as $datas)
                                    <tr>
                                    <td>{{ $datas->project_name }}</td>                         
                                    <td>{{ $datas->id }}</td>
                                    <td>{{ $datas->customer_name }}</td>
                                    <td>{{ $datas->category }}</td>
                                    <td>{{ $datas->unit_type }}</td>
                                    <td>{{ $datas->unit_no }}</td>    
                                    <td class="text-center">
                                    <div class="form-check form-switch d-flex justify-content-center">
                                    @if($datas->Cancelled == "0")
                                        <input class="form-check-input" type="checkbox" checked role="switch">
                                    @else
                                    <input class="form-check-input" type="checkbox" role="switch">
                                    @endif
                                    </div>
                                </td>
                                    <td class="text-center">

                                        @if($users_menu->user_edit == 1)
                                         <a href="{{route('Application.edit', ['id' => $datas->id])}}"><i class="fa-solid fa-pen-to-square icon"></i></a>&nbsp;
                                         <a href="{{ route('ApplicationForm.delete', $datas->id) }}" class="deleteUser"><i class="fa-solid fa-trash-can icon icon-red text-danger"></i></a>&nbsp;
                                        @endif
                                        <a href="{{route('Application.abc', ['id' => $datas->id])}}"><i class="fa-solid fa-calendar-plus icon-blue text-warning"></i></a>
                                        
                                 
                                    </td>   
                                                            
                                    </tr>
                                @endforeach
                            </tbody>
            
                            </table>
                       </div>

               
                           
                  
                <div>
                {{ $data->onEachSide(0)->links('pagination::bootstrap-5') }}
                </div>
        
            </div>

@push('scripts')
<script>
    $(document).on('click','.deleteUser',function() {
        var url = $(this).attr('rel');
        if(confirm("Are you sure you want to delete this?")){
           window.location.href = url
        }
        else{
            return false;
        }
    });
</script>
@endpush
@endsection