@extends('header')
@section('title','Customer Receipt')
@section('main')


<div class="container-fluid ">
    <form action="{{url('/Cvoucher/update')}}/{{$record->id}}" method="post" class="form-inline">
    @csrf        
    <div class="row">
      <div class="col-md-6">
            <div class="card ">
                <div class="card-header ">
                 Customer Receipt (Edit)
                </div>
                <div class="card-body" id="card-sm">
                    <div class="row">
                      <div class="col-md-4"><p>Receipt No</p></div>
                      <div class="col-md-8"><input type="text" class="form-control  form-control-sm" value="{{$record->id}}" disabled readonly></div>
                    </div>
                    <div class="row">
                      <div class="col-md-4"><p>Date</p></div>
                      <div class="col-md-8">
                    <input type="date" value="@if (isset($record->cvdate)){{$record->cvdate}}@else {{ now()->format('Y-m-d') }} @endif" class="form-control form-control-sm" name="date" placeholder="Enter Your Date Here" id="date" >
                            <span class="text-danger">
                                @error('date')
                                {{$message}}
                                @enderror
                            </span>
    
                    </div>
                      </div>
                    <div class="row">
                      <div class="col-md-4"><p>Maunal No</p></div>
                      <div class="col-md-8"><input type="text"  class="form-control-sm form-control" name = "manual_no" placeholder="Manual No" value="{{ $record->manual_no }}"></div>
                    </div>      
                    <div class="row">
                      <div class="col-md-4"><p>Project ID</p></div>
                      <div class="col-md-8"><input type="text" id="projectid" name="projectid" value="{{ $record->ProjectID }}" class="form-control-sm form-control " placeholder="id">                    </div>
                    </div>         
                    <div class="row">
                      <div class="col-md-4"><p>Project Name</p></div>
                      <div class="col-md-8">
                          

                            
                            
                            
                        <input list="project_name_options" id="project_name" name="project_name" autocomplete="off" class="form-control form-control-sm" value=" {{ $record->ProjectName }}">
                        
                        <datalist id="project_name_options">
                                @foreach($projectdata as $data)
                                <option data-id="{{ $data->id }}" value="{{ $data->project_name }}"> 
                            @endforeach
                        </datalist>
                        
                        
                            <span class="text-danger">
                                @error('projectid')
                                <p>Please select your Project</p>
                                @enderror
                            </span>
                          
                      </div>
                      
                    </div>   
                    <div class="row">
                      <div class="col-md-4"><p>Header Code</p></div>
                      <div class="col-md-8"><input type="text" id="headercode" value=" {{ $record->header_code }}" name="headercode" class="form-control form-control-sm " placeholder="like 101"></div>
                    </div>    
                    <div class="row">
                      <div class="col-md-4"><p>Account ID</p></div>
                      <div class="col-md-8"><input type="text" id="accountid" value=" {{ $record->account_id }}" name="accountid" class="form-control form-control-sm " placeholder="like 123"></div>
                    </div>         
                    <div class="row">
                      <div class="col-md-4"><p>Account Name</p></div>
                      <div class="col-md-8">
                          
                          <input type="text"  id="account_name" name="account_name" value="{{ $record->account_name }}" class="form-control form-control-sm">
    
                      </div>
                    </div>          
                    <div class="row">
                        <div class="col-md-4"><p>Unit No</p></div>
                        <div class="col-md-8">
                        
                        <input list="unit_no_options" id="unit_no" name="unit_no" autocomplete="off" class="form-control form-control-sm" value="{{ $record->unit_no }}" >
                        <datalist id="unit_no_options">
                            @foreach($selected_accounts as $data)
                                <option data-account_name="{{$data->customer_name}}" data-category="{{$data->category}}" data-headercode="{{$data->header_code}}" data-accountid="{{$data->id}}" value="{{$data->unit_no}}">{{$data->unit_no}}</option>'
                            @endforeach
                        </datalist>
                        
                        @error('unit_no')
                                {{$message}}
                                @enderror    
                        </div>
                        </div>
                    <div class="row">
                      <div class="col-md-4"><p>Category (floor)</p></div>
                      <div class="col-md-8"><input type="text" id="category" value="{{ $record->category }}" name="category" class="form-control form-control-sm " placeholder="Category"></div>
                    </div>          
                     <div class="row d-none">
                      <div class="col-md-4"><p>Payment Type</p></div>
                      <div class="col-md-8"><input type="text" list="payment_type_options" id="payment_type" value="{{ $record->payment_type }}" name="payment_type" class="form-control form-control-sm " placeholder="Payment Type"></div>
                      <datalist id="payment_type_options">
                        <option>Cash</option>
                        <option>Cheque</option>
                        </datalist>
                    </div>                     
                    <div class="row">
                      <div class="col-md-4"><p>Total Amount</p></div>
                      <div class="col-md-8"><input type="text" class="form-control form-control-sm " value=" {{ $record->total_amount }}" name="amount" placeholder="Total Amount"></div>
                    </div>            
                    <div class="row mb-md-2">
                      <div class="col-md-4"><p>Description</p></div>
                      <div class="col-md-8">
                          <input type="text" name="desc" value="{{$record->description}}" class="form-control form-control-sm">
                          
                          </div>
                    </div>      
                    <div class="row">
                        <div class="col-md-4 offset-md-4 ">
                          <button type="submit" class="btn btn-primary btn-sm" type="button" style="width: 100%;">Save/Close</button>
                        </div>        
                        <div class="col-md-4" >
                          
                               <a class="btn btn-sm btn-warning" href="/home" style="width: 100%;">Cancel/Close</a>
                      
                        </div>                           
                    </div>
                </div>


                <div class="card-footer text-muted text-md-end">
                    <span>lastUpdatedPerson:- {{$record->last_updated_person . ' ' . $record->updated_at}}</span>
                </div>
            </div>
        </div>
      <div class="col-md-6">
        <table>
            <thead>
            <tr>
              <th scope="col">Payment Type</th>
              <th scope="col">Date</th>
              <th scope="col">Chqs & TC</th>
              <th scope="col">Total</th>
        
              <th scope="col"><a href ="javascritp:;" class="btn btn-success btn-sm addRow">+</a></th>
            </tr>
          </thead>
          <tbody>
              @foreach($credit_sub as $sub)
            <tr>
              <td class="d-none"><input type="number" name="id[]" value="{{$sub->id}}" class="form-control form-control-sm rounded-0"></td>
              <td><input type="text" id="bank_name" name="bank_name[]" value="{{$sub->bank_name}}" class="form-control form-control-sm rounded-0" ></td>
              <td><input type="date" id="cheque_date" name="cheque_date[]" value="{{$sub->cheque_date}}" class="form-control  form-control-sm rounded-0"></td>
              <td><input type="text" id="cheque_no" name="cheque_no[]" value="{{$sub->cheque_no}}" class="form-control form-control-sm rounded-0" ></td>
              <td><input type="text" id="total_cr" name="total_cr[]" value="{{$sub->total_cr}}" class="form-control form-control-sm rounded-0" ></td>
              <td><a href ="javascritp:;" class="btn btn-danger btn-sm deleteRow">-</a></td>
            </tr>
            @endforeach
          </tbody>
        </table>
                <span class="text-danger">
                    @error('bank_name')
                    <p>Enter Your Value</p>
                    @enderror
                </span>
      </div>
    </div>
  </div>
  
  
<script>
function date_validation(dt){
    
    
    const date = new Date();

let currentDay= String(date.getDate()).padStart(2, '0');

let currentMonth = String(date.getMonth()+1).padStart(2,"0");

let currentYear = date.getFullYear();

// we will display the date as DD-MM-YYYY 

let currentDate = `${currentYear}-${currentMonth}-${currentDay}`;

    
    if (dt <= currentDate){
        document.getElementById("dt").innerHTML = '';
    }
    else{
        $('#date').val( currentDate );
    }
}

    $("input,select").bind("keydown", function(event) {
    if (event.which === 13) {
        event.stopPropagation();
        event.preventDefault();
       $(':input:eq(' + ($(':input').index(this) + 1) +')').focus();
    }
});


$('thead').on('click', '.addRow', function(){
 var tr = '<tr>'+
      '<td class="d-none"><input type="text" id="id" name="id[]" class="form-control rounded-0" ></td>'+
      '<td><input type="text" id="bank_name" name="bank_name[]" class="form-control rounded-0" ></td>'+
      '<td><input type="date" id="cheque_date" name="cheque_date[]" value="{{ now()->format('Y-m-d') }}" class="form-control rounded-0"></td>'+
      '<td><input type="text" id="cheque_no" name="cheque_no[]" class="form-control rounded-0" ></td>'+
      '<td><input type="text" id="total_cr" name="total_cr[]" class="form-control rounded-0" ></td>'+
      '<td><a href ="javascritp:;" class="btn btn-danger deleteRow">-</a></td>'+
    '</tr>';
    
$('tbody').append(tr);

});

$('tbody').on('click', '.deleteRow', function(){
    $(this).parent().parent().remove();
});

$("#project_name").on('change', function () {
    
    $("#unit_no_options").empty();

    var value = $('#project_name').val();
    projectid = $('#project_name_options [value="' + value + '"]').data('id');
    $('#projectid').val( projectid );
    

            $.ajax({
                url: '{{ route("Cvoucher.customers") }}',
                type: 'POST',
                data: 'projectid='+projectid+'&_token={{csrf_token()}}',

    
                success:function(result){
                       
                       
                        $.each(result.accounts, function (key, value) {
                            $("#unit_no_options").append('<option data-account_name=" ' + value.customer_name + '" data-category=" ' + value.category + '" data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.unit_no + '">' +  value.unit_no  +  '</option>');
                        });                        


                }

            });    

})


$("#unit_no").on('change', function () {
    
    var value = $('#unit_no').val();
    accountid = $('#unit_no_options [value="' + value + '"]').data('accountid');
    headercode = $('#unit_no_options [value="' + value + '"]').data('headercode');
    category = $('#unit_no_options [value="' + value + '"]').data('category');
    account_name = $('#unit_no_options [value="' + value + '"]').data('account_name');
    
    $('#accountid').val( accountid );
    $('#headercode').val( headercode );
    $('#category').val( category );
    $('#account_name').val( account_name );
    
})
</script>

@endsection
