@extends('header')
@section('title','Edit Item')
@section('main')
  <div class="container-fluid ">
    <div class="row">
      <div class="col-md-5">
            <div class="card mt-2">
          <div class="card-header ">
            Edit Item
          </div>
        <form action="{{url('/items/update')}}/{{$record->id}}" method="post">
            @csrf
          <div class="card-body" id="card-sm">

                
                <div class="row mb-2 mb-md-0">
                  <div class="col-md-4"><p>Company ID</p></div>
                  <div class="col-md-8"><input name="company_id" value="{{$record->company_id}}" type="text" class="form-control form-control-sm" ></div>
                </div>
                <div class="row mb-2 mb-md-0">
                  <div class="col-md-4"><p>Company Name *</p></div>
                    <div class="col-md-8">
                        
                      <select class="form-control form-control-sm  m-bot15"  name="company_name" id="company_name">
                   
                         <option data-id="{{ $record->company_id }}" value="{{ $record->company_name }}">{{ $record->company_name }}</option> 
                     @if(old('company_name')== null)
                     Select Your company_name
                     @else
                     {{ old('company_name') }}
                     @endif
                     
                   @foreach($company as $data)
                   <option data-id="{{ $data->id }}" value="{{ $data->account_name }}">{{ $data->account_name }}</option>
                   @endforeach
                       

                    </select>

                        <span class="text-danger">@error('company_id')Enter your company or company id again @enderror</span>
                    </div>
                </div>      

                
                <div class="row mb-2 mb-md-0">
                  <div class="col-md-4"><p>Item Name</p></div>
                  <div class="col-md-8"><input type="text" value = "{{$record->item_name}}" name="item_name" class="form-control form-control-sm"></div>
                </div>                    
                <div class="row mb-2 mb-md-0">
                  <div class="col-md-4"><p>Size</p></div>
                  <div class="col-md-8"><input type="text" value = "{{$record->size}}" name="size" class="form-control form-control-sm"></div>
                </div>         
                <div class="row mb-2 mb-md-0">
                  <div class="col-md-4"><p>Purchase Price</p></div>
                  <div class="col-md-8"><input type="text" value = "{{$record->purchase_price}}" name="purchase_price" class="form-control form-control-sm"></div>
                </div>         
                <div class="row mb-2 mb-md-0">
                  <div class="col-md-4"><p>Retail Price</p></div>
                  <div class="col-md-8"><input type="text" value = "{{$record->retail_price}}" name="retail_price" class="form-control form-control-sm"></div>
                </div>         
                
                  <div class="row mb-2 mb-md-0">
                  <div class="col-md-4 col-6"><p>Active Y/N</p></div>
                  <div class="col-md-8 col-6">
                      <div class="form-check form-switch">
                        @if($record->active_yn == 'on')
                            <input class="form-check-input" type="checkbox" name="active" role="switch" id="flexSwitchCheckChecked" checked>
                        @else
                            <input class="form-check-input" type="checkbox" name="active" role="switch" id="flexSwitchCheckChecked">
                        @endif
                      </div>
                  </div>
                </div>  



                <div class="row " id="cc">
                    <div class="col-md-4 offset-md-4 col-6">
                      <button   type="submit" class="btn btn-primary btn-sm"  type="button" >Save/Close</button>
                    </div>        
                    <div class="col-md-4 col-6 text-secondary" >
                      
                      <a href="/" class="btn btn-sm btn-danger">Cancel/Close</a>
                      
                    
                    </div>                           
                </div>
                
        </div>
        </form>

          <div class="card-footer text-muted text-md-end">
             <span>last updated : {{ $record->last_updated_person . ' ' . $record->updated_at}}</span>
          </div>
        </div>
      </div>
    </div>
  </div>
  <script>
     $('#address').change(function(){
       
       
       var selected = $(this).find('option:selected');    
        var address_id = selected.data('id');
        $('#address_id').val( address_id );
        
       
   });
   </script>
@endsection