@extends('header')
@section('title','Lookup Items')
@section('main')



<div class="container">

         <div class="row" > 
                 <div class="col-4 d-flex justify-content-left pt-3">
                     @if($users_menu->user_add == 1)
                    <a href="{{url('/items/add')}}">
                    <button type="submit" class="btn btn-success btn-sm">Add New</button> 
                    </a>
                    @endif
                </div>
    
                <div class="col-4 d-flex justify-content-center">                
                        <h1 style="font-family: 'Brush Script MT', cursive;">Items</h1>
                </div>
               
                <div class="col-4 d-flex justify-content-end mt-3 ">
                    <form class="row g-1">
                        <div class="col-auto ">
                            <input class="form-control form-control-sm " name="search" type="search" placeholder="Search here!">
                        </div>
                        
                    </form>
                </div>
            </div>
        <div class="row">
            <div class="col-12">
                    <table class="table table-sm">

                <thead>
                    <tr>
                    <th scope="col">Company-ID#</th>
                    <th scope="col">Company-Name</th>
                    <th scope="col">Item-Code#</th>
                    <th scope="col">Item-Name</th>
                    <th scope="col">Size</th>
                    <th scope="col">Purchase-Price</th>
                    <th scope="col">Retail-Price</th>
                    <th scope="col" class="text-end">Active</th>
                    <th scope="col" class="text-end">Action</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($items as $datas)
                        <tr>
                        <td>{{ $datas->company_id }}</td>
                        <td>{{ $datas->company_name }}</td>
                        <td>{{ $datas->id }}</td>
                        <td>{{ $datas->item_name }}</td>
                        <td>{{ $datas->size }}</td>
                        <td>{{ $datas->purchase_price }}</td> 
                        <td>{{ $datas->retail_price }}</td> 
                        <td class="text-end">
                            <div class="form-check form-switch d-flex justify-content-end">
                            @if($datas->active_yn == "on")
                                <input class="form-check-input" type="checkbox" checked role="switch">
                            @else
                            <input class="form-check-input" type="checkbox" role="switch">
                            @endif
                            </div>
                        </td>
                         <td class="text-end" id="dd">  
                           <a href="{{route('items.edit', ['id' => $datas->id])}}">
                                <button class="btn btn-danger btn-sm">Delete</button>
                            </a>
                            <a href="{{route('items.edit', ['id' => $datas->id])}}">
                                <button class="btn btn-info btn-sm">Edit</button>
                            </a>
                             </td>  
                        </tr>
                    @endforeach
                </tbody>

                </table>
            </div>  
                
                {{ $items->links('pagination::bootstrap-5')}}
                

    </div>
</div>

        
@endsection



