@extends('header')
@section('title','Edit Payment Voucher')
@section('main')
<div class="container-fluid mt-3">    
        <form action="{{url('/Pvoucher/update')}}/{{$record->id}}" method="post">
        @csrf
    <div class="row">
        <div class="col-6">

            <div class="card text-left" >
                <div class="card-header">
                    Edit Record
                </div>
            <div class="card-body">
                <h5 class="card-title pb-2">Payment Voucher</h5>
                    <div class="row">
                      <div class="col-md-4"><p>Voucher #</p></div>
                      <div class="col-md-8">
                            <input type="number" value="{{$record->id}}" class="form-control" name="voucher_id">
                      </div>
                    </div>                
    
                    <div class="row">
                      <div class="col-md-4"><p>Project ID</p></div>
                      <div class="col-md-8">
                            <input type="date" id="date" value="@if (isset($record->dvdate)){{$record->dvdate}}@else {{ now()->format('Y-m-d') }} @endif" class="form-control" name="date" placeholder="Enter Your Date Here" >
                            <span class="text-danger">
                                @error('date')
                                {{$message}}
                                @enderror
                            </span>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4"><p>Project ID</p></div>
                      <div class="col-md-8">
                        <input type="text" id="projectid" name="projectid" value="{{ $record->ProjectID }}" class="form-control" placeholder="type id here">                    
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4"><p>Project Name</p></div>
                      <div class="col-md-8">
                                                  <input list="project_name_options" id="project_name" name="project_name" autocomplete="off" class="form-control"  value=" {{ $record->ProjectName }}">
                
                        <datalist id="project_name_options">
                                @foreach($projectdata as $data)
                                <option data-id="{{ $data->id }}" value="{{ $data->project_name }}"> 
                            @endforeach
                        </datalist>
                        

                    <span class="text-danger">
                        @error('projectid')
                        <p>Please select your Project</p>
                        @enderror
                    </span>

                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4"><p>Header Code</p></div>
                      <div class="col-md-8">
                        <input type="text" id="headercode" value=" {{ $record->header_code }}" name="headercode" class="form-control ">
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4"><p>Account ID</p></div>
                      <div class="col-md-8">
                        <input type="text" id="accountid" value=" {{ $record->account_id }}" name="accountid" class="form-control ">
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4"><p>Account Name</p></div>
                      <div class="col-md-8">

                          <input list="account_name_options" id="account_name" name="account_name" autocomplete="off" class="form-control" value=" {{ $record->account_name }}">
                        
                        <datalist id="account_name_options">
                              @foreach($selected_accounts as $data)
                            <option data-headercode="{{$data->header_code }}" data-accountid="{{$data->id}}" value="{{$data->account_name}}">{{$data->account_name}}</option>
                            @endforeach
                        </datalist>
                            <span class="text-danger">
                                @error('accountid')
                                <p>Please select your Account</p>
                                @enderror
                            </span>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-4"><p>Description</p></div>
                      <div class="col-md-8">
                          <input type="text" name="desc" class="form-control" value="{{$record->description}}">
                        
                      </div>
                    </div>
                    
                    
                    <div class="row">
                      <div class="col-md-4"><p>Payment Type</p></div>
                      <div class="col-md-8"><input type="text" list="payment_type_options" id="payment_type" value="{{$record->payment_type}}" name="payment_type" class="form-control" placeholder="Payment Type"></div>
                      <datalist id="payment_type_options">
                        <option>Cash</option>
                        <option>Cheque</option>
                        </datalist>
                    </div> 
                    
                    <div class="row">
                      <div class="col-md-4"><p>Total Amount</p></div>
                      <div class="col-md-8">
                        <input type="text" class="form-control form-control-sm" value=" {{ $record->total_amount }}" name="amount">
                      </div>
                    </div>


                        

        </div>
        <div class="card-footer">
        
            <button type="submit" class="btn btn-primary btn-sm">Save/Close</button>          
            <a href="{{url('/Pvoucher/index')}}">
            <button type="button" class="btn btn-info btn-sm">Cancel/Close</button>        
            </a>
            
        </div>
        </form>  
    </div>
                        
        </div>
        <div class="col-md-6">
        <table class="table table-striped table-borderless">
            <thead>
            <tr>
              <th scope="col">Payment Type</th>
              <th scope="col">Date</th>
              <th scope="col">Cheque No</th>
              <th scope="col">Total</th>
        
              <th scope="col"><a href ="javascritp:;" class="btn btn-success addRow">+</a></th>
            </tr>
          </thead>
          <tbody>
              @foreach($payment_sub as $sub)
            <tr>
              <td class="d-none"><input type="number" name="id[]" value="{{$sub->id}}" class="form-control rounded-0"></td>
              <td><input type="text" id="bank_name" name="bank_name[]" value="{{$sub->bank_name}}" class="form-control rounded-0" ></td>
              <td><input type="date" id="cheque_date" name="cheque_date[]" value="{{$sub->cheque_date}}" class="form-control rounded-0"></td>
              <td><input type="text" id="cheque_no" name="cheque_no[]" value="{{$sub->cheque_no}}" class="form-control rounded-0" ></td>
              <td><input type="text" id="total_cr" name="total_cr[]" value="{{$sub->total_dr}}" class="form-control rounded-0" ></td>
              <td><a href ="javascritp:;" class="btn btn-danger deleteRow">-</a></td>
            </tr>
            @endforeach
          </tbody>
        </table>
        
    <span class="text-danger">
                                @error('bank_name')
                                <p>Enter Your Value</p>
                                @enderror
                            </span>
                            
                           



<img src="{{URL::asset('public/' . $record->photo_path)}}" width="300" height="300">






      </div>
    </div>
</div>
<script>
function date_validation(dt){
    
    
    const date = new Date();

let currentDay= String(date.getDate()).padStart(2, '0');

let currentMonth = String(date.getMonth()+1).padStart(2,"0");

let currentYear = date.getFullYear();

// we will display the date as DD-MM-YYYY 

let currentDate = `${currentYear}-${currentMonth}-${currentDay}`;

    
    if (dt <= currentDate){
        document.getElementById("dt").innerHTML = '';
    }
    else{
        $('#date').val( currentDate );
    }
}
$(document).ready(function() {
    $('.project_name').select2();
    $('.account_name').select2();
});

    $("input,select").bind("keydown", function(event) {
    if (event.which === 13) {
        event.stopPropagation();
        event.preventDefault();
       $(':input:eq(' + ($(':input').index(this) + 1) +')').focus();
    }
});


$('thead').on('click', '.addRow', function(){
 var tr = '<tr>'+
      '<td><input type="text" id="id" name="id[]" class="form-control rounded-0" ></td>'+
      '<td><input type="text" id="bank_name" name="bank_name[]" class="form-control rounded-0" ></td>'+
      '<td><input type="date" id="cheque_date" name="cheque_date[]" value="{{ now()->format('Y-m-d') }}" class="form-control rounded-0"></td>'+
      '<td><input type="text" id="cheque_no" name="cheque_no[]" class="form-control rounded-0" ></td>'+
      '<td><input type="text" id="total_cr" name="total_cr[]" class="form-control rounded-0" ></td>'+
      '<td><a href ="javascritp:;" class="btn btn-danger deleteRow">-</a></td>'+
    '</tr>';
    
$('tbody').append(tr);

});

$('tbody').on('click', '.deleteRow', function(){
    $(this).parent().parent().remove();
});

$('#project_name').change(function(){

    
    $("#account_name_options").empty();
    var value = $('#project_name').val();
    projectid = $('#project_name_options [value="' + value + '"]').data('id');
    $('#projectid').val( projectid );


     //append into account dropdown start here
     var pid=jQuery(this).val();
            $.ajax({
                url: '{{ route("Pvoucher.accounts") }}',
                type: 'POST',
                data: 'projectid='+projectid+'&_token={{csrf_token()}}',

                success:function(result){
                    
                        $.each(result.accounts, function (key, value) {
                            $("#account_name_options").append('<option data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.customer_name + '">' + value.customer_name + '</option>');
                        });


                }
            });
        //end 
    
});


$('#account_name').change(function(){


    var value = $('#account_name').val();
    accountid = $('#account_name_options [value="' + value + '"]').data('accountid');
    headercode = $('#account_name_options [value="' + value + '"]').data('headercode');
    
    
    

    $('#headercode').val( headercode );
    $('#accountid').val( accountid );
    //alert(headercode + accountid);

});


</script>




@endsection
