<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">

    <title>Payment Voucher</title>
    <style>
 

        @page {
           size: A4;
           margin: 0;
        }
        @media print {
          html, body{
            padding:5px;
            font-size:12px;
            


          }
          /* ... the rest of the rules ... */
        }
         a{
              text-decoration: none;
         }

    </style>
</head>
<body>
    <center><button id="noprint" class="d-print-none" onclick="window.print()">Print this page</button></center>
    <div class="container-fluid">
        
        <div class="row">
                <div class="col-6">
                <h1 >{{ $record->ProjectName }}</h1>
                </div>
                <div class="col-6 pt-3 ">
                <p class="text-end"><small>Print time : {{ date('d-M-y H:i:s')}}</small></p>
                    
                </div>
                
            </div>
    
        <div class="row">
            
            <div class="col-6">
                
        
            
<h6><i>Payment Voucher</i></h6>
            <hr>
            <div class="row">
                    <div class="col-3 ">
                    <h7 >Receipt No# :</h7>
                    </div>
                    <div class="col-3">
                    <h7 >{{ $record->id }}</h7>
                    </div>   
            </div>
            <div class="row">
                    <div class="col-3 ">
                    <h7 >Payment Date  : </h7>
                    </div>    
                    <div class="col-3 ">
                    <h7 >{{ date('d-M-y', strtotime($record->dvdate)) }}</h7>
                    </div>
            </div>
            <div class="row">        
            
                <div class="col-3">
                <h7 >Account ID  : </h7>
                </div>     
                <div class="col-3">
                <h7 >{{ $record->header_code }}-{{ $record->account_id }}</h7>
                </div>
</div>
            <div class="row">
                <div class="col-3">
                <h7 >Account Name  : </h7>
                </div>      
                <div class="col-6">
                <h7 >{{ $record->account_name }}</h7>
                </div>
</div>
            <div class="row">
                <div class="col-3">
                <h7 >Payment Type</h7>
                </div>           
                <div class="col-3">
                <h7>{{ $record->payment_type }}</h7>
                </div>
</div>
            <div class="row">
                <div class="col-3">
                <h7 >Total Amount : </h7>
                </div>           
                <div class="col-3">
                <h7><b>{{ number_format($record->total_amount,0) }}</b></h7>
                </div>
</div>
            <div class="row">
                <div class="col-3">
                <h7 >In Words : </h7>
                </div>           
                <div class="col-6">
                <h7>{{ $inword }}</b></h7>
                </div>
            </div>


            </div>  

            
            
            <div class="col-6">
                                            <table class="table">
                              <thead>
                                <tr>
                                  <th scope="col"><b>Payment Type</b></th>
                                  <th scope="col"><b>Date</b></th>
                                  <th scope="col"><b>Chqs & TC</b></th>
                                  <th scope="col"><b>Total</b></th>
                                  
                                </tr>
                              </thead>
                            <tbody>
                                  @foreach($debit_sub as $subdata)
                                <tr>
                                  <td><b>{{$subdata->bank_name}}</b></td>
                                  <td><b>{{date('d-M-y', strtotime($subdata->cheque_date))}}</b></td>
                                  @if(empty($subdata->cheque_no))
                                  <td>-------------</td>
                                  @else
                                  <td><b>{{$subdata->cheque_no}}</b></td>
                                  @endif
                                  <td><b>{{number_format($subdata->total_dr,0)}}</b></td>
                                </tr>
                                @endforeach
                              </tbody>
                            </table>
            </div>
            
        </div>
        
        
                    <div class="row">                   
                <div class="col-12 text-center">
                    <h5 >Description </h5>
                </div>  
            </div>
            <div class="row">
                <div class="col-12 text-center">
                    <h7>{{ $record->description }}</b></h7>
                </div>
            </div> 
            
        <div class="row mt-5">
                <div class="col-5 offset-1">
                <h5 class="text-center">Received By </h5>
                <hr>
                </div>
                <div class="col-5">
                <h5 class="text-center">Permission </h5>
                <hr>
                </div>
            </div> 
        
    </div>
    
</body>
</html>