@extends('header')
@section('title','Users')
@section('main')


<div class="container">
      <div class="row "> 
                     <div class="col-4 d-flex justify-content-left mt-3">
                <a href="/Users/add">
                <button type="submit" class="btn btn-success btn-sm">Add New &nbsp; <i class="fa-solid fa-plus icon-white"></i></button> 
                </a>
            </div>

             <div class="col-4  d-flex justify-content-center mt-2">               
                    <h1 style="font-family: 'Brush Script MT', cursive;">Users</h1>
            </div>
           
           <div class="col-4 mt-3 d-flex justify-content-end">
                <form class="row g-1">
                    <div class="col-auto ">
                        <input class="form-control form-control-sm " name="search" type="search" placeholder="Search here!">
                    </div>
                    <div class="col-auto">
                    <a href="{{url('/Users/index')}}">
                        
                    </a>
                    </div>
                    
                </form>
            </div>
        </div>
        <div class="row">
                    <table class="table table-sm table-hover mt-3">

                <thead>
                    <tr>
                    <th scope="col">#</th>
                    <th scope="col">Name</th>
                    <th scope="col">Email</th>
                    <th scope="col">Role</th>
                    
                    <th class="text-center" scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($users as $datas)
                        <tr>
                        <td>{{ $datas->id }}</td> 
                        <td>{{ $datas->name }}</td>
                        <td>{{ $datas->email }}</td>
                        <td>
                            @if($datas->role == 1) Admin  @else User @endif</td>
                        <td class="text-center">

                            <a href="{{route('Users.edit', ['id' => $datas->id])}}">
                               <i class="fa-solid fa-pen-to-square icon"></i>
                            </a>
                            <a href="{{route('Users.delete', ['id' => $datas->id])}}" class="deleteUser"><i class="fa-solid fa-trash-can icon icon-red"></i></a>

                        </td>   
                                                
                        </tr>
                    @endforeach
                </tbody>

                </table>
                </div>
</div>

<script>
$(document).on('click','.deleteUser',function() {
        var url = $(this).attr('rel');
        if(confirm("Are you sure you want to delete this?")){
           window.location.href = url
        }
        else{
            return false;
        }
    });
    </script>
@endsection