@extends('header')
@section('title','Account')
@section('main')

<div class="container d-flex justify-content-center mt-3">    
    <div class="card text-left" style="width: 50rem;">
        <div class="card-header">
            Add New Record
        </div>
        <form action="{{url('/account/add')}}" method="post">
                @csrf
        
        <div class="card-body">
            <h5 class="card-title pb-2">Accounts</h5>
            <!-- Voucher ID -->
            <div class="row g-1 mb-4">
                

            </div>
            <!-- Date - Project -->
            <div class="row g-1 ">
            <div class="col-3">
                    <input type="text" class="form-control  rounded-0" placeholder="Account ID#" disabled readonly>
                </div>
                <div class="col-3">
                <input type="text" id="projectid" name="projectid" value="{{ old('projectid') }}" class="form-control rounded-0" placeholder="Project ID">                    
                </div>
                <div class="col-6">
                        
                        <select class="form-control form-control m-bot15 rounded-0" id="project_name" name="project_name">
                        <option value="{{ old('project_name') }}" selected>
                        @if(old('project_name')== null)
                        Select Your Project
                        @else
                        {{ old('project_name') }}
                        @endif
                        </option>
                        
                        @foreach($projectdata as $data)
                            <option data-id="{{ $data->id }}" value="{{ $data->project_name }}">{{ $data->project_name }}</option> 
                        @endforeach
                        </select>
                        <span class="text-danger">
                            @error('projectid')
                            <p>Please select your Project</p>
                            @enderror
                        </span>
                </div> 

            </div>     
            <!-- Account Name and ID        -->
            <div class="row g-1 ">

                <div class="col-3">
                    <input type="text" id="headercode" value="{{ old('headercode') }}" name="headercode" class="form-control rounded-0" placeholder="Header Code">
                </div>

                <div class="col-3">
                <select class="form-control rounded-0" id="account_name" name="account_name" >
                                <option value="{{ old('account_name') }}" selected>
                            @if(old('account_name')== null)
                            Select Your Account
                            @else
                            {{ old('account_name') }}
                            @endif
                            </option>
                            @foreach($accountdata as $data)
                            <option data-headercode="{{ $data->header_code }}" value="{{ $data->header_name }}">{{ $data->header_name }}</option> 
                             @endforeach
                        </select>

                </div> 
                <div class="col-6 mb-3">
                <input type="text"  class="rounded-0 form-control" name="account_title" placeholder="Account Title: Tea,Rent,Salary....">
                </div> 

            </div>

            <div class="row">
                <div class="col-">
                    <lable>Limit Amount</lable>
                </div>
                <div class="col-">
                    <input type="text"  class="rounded-0 form-control" name="limit_amount">
                </div>
            </div>

        <div class="card-footer">
        <button type="submit" class="btn btn-primary ">Save/Close</button>  
                <a href="{{route('account.index')}}" class="btn btn-warning">Cancel/Close</a>
        </div>
        </form>  
    </div>
</div>

<script>

$('#account_name').change(function(){

    var selected = $(this).find('option:selected');
    var headercode = selected.data('headercode');
    $('#headercode').val( headercode );

    

});

$('#project_name').change(function(){

    
    var selected = $(this).find('option:selected');
    var projectid = selected.data('id');
    $('#projectid').val( projectid );
});

</script>
@endsection

