@extends('header')
@section('title','COA')
@section('main')



<div class="container-md shadow mt-md-3 px-3 py-3 border-top rounded-top border-2 border-primary bg-light" >
                <div class="row "> 
                     <div class="col-4 d-flex justify-content-left mt-3">
                         @if($users_menu->user_add == 1)
                              <a href="{{url('/account/add')}}">
                                  
                <button type="submit" class="btn btn-success btn-sm">Add New &nbsp; <i class="fa-solid fa-plus icon-white"></i></button> 
                </a>
                         @endif   
            </div>                  

             <div class="col-4  d-flex justify-content-center mt-2">               
                    <h1 style="font-family: 'Brush Script MT', cursive;">Chart of accounts</h1>
            </div>
           
           <div class="col-4 mt-3 d-flex justify-content-end">
                <form class="row g-1">
                    <div class="col-auto ">
                        <input class="form-control form-control-sm " name="search" type="search" placeholder="Search here!">
                    </div>
                    <div class="col-auto">
                    <a href="{{url('/account/index')}}">
                        
                    </a>
                    </div>
                    
                
            </div>
        </div>
                <div class="row">
                    <table class="table table-sm table-hover mt-3">

                <thead>
                    <tr>
                    <th scope="col">Project Name 
                    @if($sortby == "project_name")
                    <input class="form-check-input" type="radio" name="sortby" value="project_name" checked>
                    @else
                    <input class="form-check-input" type="radio" name="sortby" value="project_name" >
                    @endif
                    </th>
                    <th scope="col">Header Code</th>
                    <th scope="col">Account ID</th>
                    <th scope="col">Account Name
                    
                                        @if($sortby == "account_name")
                    <input class="form-check-input" type="radio" name="sortby" value="account_name" checked>
                    @else
                    <input class="form-check-input" type="radio" name="sortby" value="account_name">
                    @endif
                    </th>
                    <th scope="col">Account Type</th>
                    <th scope="col">Created At</th>
                    <th scope="col">Updated At</th>
                     <th class="text-center" scope="col">Action</th>
                    </tr>
                </thead>
                </form>
                <tbody>
                @foreach($data as $datas)
                        <tr>
                        <td>{{ $datas->project_name }}</td> 
                        <td>{{ $datas->header_code }}</td>
                        <td>{{ $datas->id }}</td>
                        <td>{{ $datas->account_name }}</td>
                        <td>{{ $datas->account_type }}</td>
                        <td>{{ date('d-M-y', strtotime($datas->created_at))  }}</td>
                        <td>{{ date('d-M-y', strtotime($datas->updated_at))  }}</td>
                          
                        <td class="text-center">
                             @if($users_menu->user_edit == 1)
                            <a href="{{route('account.edit', ['id' => $datas->id])}}">
                               <i class="fa-solid fa-pen-to-square icon"></i>
                            </a>
                            @else
                            ----
                            @endif
                            
                        </td>   
                                                
                        </tr>
                    @endforeach
                </tbody>

                </table>
                </div>
                <div class="row">
                {{ $data->onEachSide(0)->appends($_GET)->links('pagination::bootstrap-5') }}
                </div>

    </div>


@endsection

