@extends('header')
@section('title','Cheques Debit & Credit')
@section('main')

<div class="container d-flex justify-content-center mt-3">    
    <div class="card text-left" style="width: 50rem;">
        <div class="card-header">
            Add New Record
        </div>
        
            <form action="{{url('/cheques/add')}}" method="post">
                @csrf
                <div class="card-body">
            <h5 class="card-title pb-2">Cheques Debit & Credit</h5>
            <!-- Voucher ID -->
            <div class="row g-1 mb-3">
                <div class="col-6">
                    <input type="text" class="form-control  rounded-0" placeholder="Cheques ID#" disabled readonly>
                </div>
                <div class="col-6">
                <input type="date" value="{{ now()->format('Y-m-d') }}" class="form-control rounded-0" name="date">
                        <span class="text-danger">
                            @error('date')
                            {{$message}}
                            @enderror
                        </span>
                </div> 
            </div>
            <!-- Date - Project -->
            <div class="row g-1 mb-3">

                <div class="col-6">
                <input type="text" id="projectid" name="project_id" value="{{ old('projectid') }}" class="form-control rounded-0" placeholder="Project ID">                    
                </div>
                <div class="col-6">
                        
                        <select class="form-control form-control m-bot15 rounded-0" id="project_name" name="project_name">
                        <option value="{{ old('project_name') }}" selected>
                        @if(old('project_name')== null)
                        Select Your Project
                        @else
                        {{ old('project_name') }}
                        @endif
                        </option>
                        
                        @foreach($projectdata as $data)
                            <option data-id="{{ $data->id }}" value="{{ $data->project_name }}">{{ $data->project_name }}</option> 
                        @endforeach
                        </select>
                        <span class="text-danger">
                            @error('project_id')
                            <p>Please select your Project</p>
                            @enderror
                        </span>
                </div> 

            </div>     
            <!-- Account Name and ID        -->
            <center>To Accounts</center>
            <div class="row g-1 mb-3">

                <div class="col-3">
                    <input type="text" id="headercode" value="{{ old('header_code') }}" name="header_code" class="form-control rounded-0" placeholder="Header Code">
                </div>
                <div class="col-3">
                    <input type="text" id="accountid" value="{{ old('account_id') }}"name="account_id" class="form-control rounded-0" placeholder="Account ID">
                </div>
                <div class="col-6">
                <select class="form-control rounded-0" id="account_name" name="account_name" >
                                <option value="{{ old('account_name') }}" selected>
                            @if(old('account_name')== null)
                            Select Your Account
                            @else
                            {{ old('account_name') }}
                            @endif
                            </option>
                        </select>
                        <span class="text-danger">
                            @error('account_id')
                            <p>Please select your Account</p>
                            @enderror
                        </span>
                </div>


            </div>
            <center>From Accounts</center>
            <div class="row g-1 mb-3">
                
                <div class="col-3">
                    <input type="text" id="source_headercode" value="{{ old('source_header_code') }}" name="source_header_code" class="form-control rounded-0" placeholder="H-Code">
                </div>
                <div class="col-3">
                    <input type="text" id="source_accountid" value="{{ old('account_id') }}"name="source_account_id" class="form-control rounded-0" placeholder="Account ID">
                </div>
                
                <div class="col-6">
                <select class="form-control rounded-0" id="source_account_name" name="source_account_name" >
                                <option value="{{ old('source_account_name') }}" selected>
                            @if(old('source_account_name')== null)
                            Select Your Account
                            @else
                            {{ old('source_account_name') }}
                            @endif
                            </option>
                        </select>
                        <span class="text-danger">
                            @error('source_account_id')
                            <p>Please select your Account</p>
                            @enderror
                        </span>
                </div>


            </div>

<hr>
<div class="text-center">
    <input type="text" class="form-control text-center" value="{{ old('description') }}" name="description" placeholder="Description">
    </div>
<hr>
<table class="table table-striped table-borderless">
  <thead>
    <tr>
      <th scope="col">Date</th>
      <th scope="col">Bank Name</th>
      <th scope="col">Cheque No</th>
      <th scope="col">Dr</th>
      <th scope="col">Cr</th>
      <th scope="col"><a href ="javascritp:;" class="btn btn-success addRow">+</a></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><input type="date" id="cheque_date" value="{{ old('cheque_date') }}"name="cheque_date[]" class="form-control rounded-0"></td>
      <td><input type="text" id="bank_name" value="{{ old('bank_name') }}"name="bank_name[]" class="form-control rounded-0" ></td>
      <td><input type="text" id="cheque_no" value="{{ old('cheque_no') }}"name="cheque_no[]" class="form-control rounded-0" ></td>
      <td><input type="text" id="dr" value="{{ old('dr') }}"name="dr[]" class="form-control rounded-0" ></td>
      <td><input type="text" id="cr" value="{{ old('cr') }}"name="cr[]" class="form-control rounded-0" ></td>
      <td><a href ="javascritp:;" class="btn btn-danger deleteRow">-</a></td>
    </tr>
  </tbody>
</table>

        <div class="card-footer">
            <button type="submit" class="btn btn-primary ">Save/Close</button>  
            <a href="{{route('Rvoucher.index')}}" class="btn btn-warning">Cancel/Close</a>
        </div>
        
    </div>
            </form>
        </div>
        
<script>

$('thead').on('click', '.addRow', function(){
 var tr = '<tr>'+
      '<td><input type="date" id="cheque_date" value="{{ old('cheque_date') }}"name="cheque_date[]" class="form-control rounded-0"></td>'+
      '<td><input type="text" id="bank_name" value="{{ old('bank_name') }}"name="bank_name[]" class="form-control rounded-0" placeholder="like MCB ..."></td>'+
      '<td><input type="text" id="cheque_no" value="{{ old('cheque_no') }}"name="cheque_no[]" class="form-control rounded-0" placeholder="23423422 ..."></td>'+
      '<td><input type="text" id="dr" value="{{ old('dr') }}"name="dr[]" class="form-control rounded-0" placeholder="50,000 ..."></td>'+
      '<td><input type="text" id="cr" value="{{ old('cr') }}"name="cr[]" class="form-control rounded-0" placeholder="50,000 ..."></td>'+
     '<td><a href ="javascritp:;" class="btn btn-danger deleteRow">-</a></td>'+
    '</tr>';
$('tbody').append(tr);

});

$('tbody').on('click', '.deleteRow', function(){
    $(this).parent().parent().remove();
});


$('#project_name').change(function(){

    
     var selected = $(this).find('option:selected');    
     var projectid = selected.data('id');
     $('#projectid').val( projectid );
    

     //append into account dropdown start here
     var pid=jQuery(this).val();
            $.ajax({
                url: '{{ route("Pvoucher.accounts") }}',
                type: 'POST',
                data: 'projectid='+projectid+'&_token={{csrf_token()}}',

                success:function(result){
                    $('#account_name').html('<option value="">Select Your Account</option>');
                                            $.each(result.accounts, function (key, value) {
                            $("#account_name").append('<option data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.customer_name + '">' + value.customer_name + '</option>');
                        });
                    $('#source_account_name').html('<option value="">Select Your Account</option>');
                                            $.each(result.accounts, function (key, value) {
                            $("#source_account_name").append('<option data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.customer_name + '">' + value.customer_name + '</option>');
                        });


                }
            });
        //end 
    
});


$('#account_name').change(function(){
    var selected = $(this).find('option:selected');
    var headercode = selected.data('headercode');
    var selected = $(this).find('option:selected');
    var accountid = selected.data('accountid');

    $('#headercode').val( headercode );
    $('#accountid').val( accountid );
    //alert(headercode + accountid);

});

$('#source_account_name').change(function(){
    var selected = $(this).find('option:selected');
    var source_headercode = selected.data('headercode');
    var selected = $(this).find('option:selected');
    var source_accountid = selected.data('accountid');

    $('#source_headercode').val( source_headercode );
    $('#source_accountid').val( source_accountid );
    //alert(headercode + accountid);

});

</script>

@endsection

