@extends('header')
@section('title','Due Cheques')
@section('main')

<div class="container-md shadow mt-md-3 border-top rounded-top border-2 border-primary bg-light">
        <div class="row "> 
            <div class="col-4 d-flex justify-content-left mt-3" >
                 @if($users_menu->user_add == 1)
                <a href="{{url('/cheques/add')}}">
                <button type="submit" class="btn btn-success btn-sm">Add New</button> 
                </a>
                @endif
            </div>

             <div class="col-4  d-flex justify-content-center mt-2">             
                    <h1 style="font-family: 'Brush Script MT', cursive;">Due Cheques</h1>
            </div>
           
            
        <div class="col-4 mt-3 d-flex justify-content-end">
                <form class="row g-1">
                    <div class="col-auto ">
                        <input class="form-control form-control-sm " name="search" type="search" placeholder="Search here!">
                    </div>
                    <div class="col-auto">
                    <a href="{{url('/cheques/index')}}">
                        
                    </a>
                    </div>
                </form>
            </div>
        </div>

        <table class="table table-sm table-hover mt-3">

                <thead>
                    <tr>
                    <th scope="col" style="width:5%;"> 
                        <a href="{{ url('/cheques/index?sortby=id&order=' . ($sortby == 'id' && $order == 'asc' ? 'desc' : 'asc')) }}">
                            ID
                        </a>
                    </th>
                    <th scope="col">Project</th>
                    <th scope="col">Account</th>
                    <th scope="col">Bank</th>
                     <th scope="col" style="width:15%;">
                        <a href="{{ url('/cheques/index?sortby=cheque_date&order=' . ($sortby == 'cheque_date' && $order == 'asc' ? 'desc' : 'asc')) }}">
                            Cheque Date
                        </a>
                    </th>
                    <th scope="col">Cheque No</th>
                    <th scope="col">Payables</th>
                    <th scope="col">Receivables</th>
                    <th class="text-center" scope="col" style="width:20%;">Status</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($data as $datas)
                        <tr>
                        <td>{{ $datas->d }}</td>
                        <td>{{ $datas->project_name }}</td>
                        <td>{{ $datas->account_name }}</td>
                        <td>{{ $datas->bank_name }}</td>
                        <td>{{ date('d-M-y', strtotime($datas->cheque_date)) }}</td>
                        <td>{{ $datas->cheque_no }}</td>
                        <td>{{ number_format($datas->dr,0) }}</td>    
                        <td>{{ number_format($datas->cr,0) }}</td>    
                        
                        <td class="text-center">
                            @if($users_menu->user_edit == 1)
                            <a href="{{route('cheques.clr', ['id' => $datas->d])}}" class="btn btn-sm btn-info">Clear</a>
                            @endif
                            @if($users_menu->user_delete == 1)
                            <a href="{{route('cheques.delete', ['id' => $datas->d])}}" class="btn btn-sm btn-danger deleteUser">Delete</a>
                            @endif
                            <a href="{{route('cheques.show', ['id' => $datas->cheque_id])}}" class="btn btn-sm btn-warning">Print</a>
                            
                        </td>    

                                                
                        </tr>
                    @endforeach
                </tbody>

                </table>
               
                   
          
                <div class="row">
{{ $data->onEachSide(0)->links('pagination::bootstrap-5') }}
    </div>

    </div>

<script>

$(document).on('click','.deleteUser',function() {
        var url = $(this).attr('rel');
        if(confirm("Are you sure you want to delete this?")){
           window.location.href = url
        }
        else{
            return false;
        }
    })

</script>
@endsection

