<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <title>@yield('title')</title>


    <!-- Bootstrap CSS CDN -->

	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/css/bootstrap.min.css" rel="stylesheet" >
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    
    <style>
body{
    font-family: Century Gothic,CenturyGothic,AppleGothic,sans-serif;
    background-color:#ffffff;
}
    /* Style 7
   ----------------------------- */
.seven h1 {
text-align: center;
    font-size:30px; font-weight:300; color:#222; letter-spacing:1px;
    text-transform: uppercase;

    display: grid;
    grid-template-columns: 1fr max-content 1fr;
    grid-template-rows: 27px 0;
    grid-gap: 20px;
    align-items: center;
}

.seven h1:after,.seven h1:before {
    content: " ";
    display: block;
    border-bottom: 1px solid #c50000;
    border-top: 1px solid #c50000;
    height: 5px;
  background-color:#f8f8f8;
}


.activeLink{
    background-color: #000000;
    color:#ffffff;
    
    .icon{
        color:#FE9900;
        font-size:16px;
        padding:5px;
    }
    
.icon-red{
        color:#E4080A;
        font-size:16px;
    }

.icon-blue{
        color:#5DE2E7;
        font-size:16px;
    }   
    
.icon-white{
        color:#ffffff;
        font-size:16px;
        font-weight:bold;
    }  
    
.flex-parent {
  display: flex;
  width: 300px;
  height: 10px;
  align-items: center;
}

.flex-child-edge {
  flex-grow: 2;
  height: 1px;
  background-color: #000;
  border: 1px #000 solid;
}

.flex-child-text {
  flex-basis: auto;
  flex-grow: 0;
  margin: 0px 5px 0px 5px;
  text-align: center;
}

.form-control:read-only {
    background-color:#ffffff;
}

.shadow {
    box-shadow: 0 0.5rem 1rem rgba(0,0,0,1.15)!important;
}

.navbar a{
    font-family: Verdana !important;
}

.nav-link:hover {
    color:#cdcdcd !important;

}

.spinner-border{
height:20px;
width:20px;
}
    

    </style>
@stack('styles')
</head>
<body>
    



@if(session()->get('role') == 1)

    <nav class="navbar navbar-expand-lg navbar-dark mb-md-4" style="background-color: #2B2A65; font-family: Century Gothic,CenturyGothic,AppleGothic,sans-serif; ">
@else
<nav class="navbar navbar-expand-lg navbar-dark mb-md-4" style="background-color: #202324; font-family: Century Gothic,CenturyGothic,AppleGothic,sans-serif; ">
@endif
  <div class="container-fluid">
    <a class="navbar-brand" href="/">Al-Ameen</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse " id="navbarSupportedContent">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">



      <li class="nav-item">
          @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Application Form' && $menu->user_id == session()->get('user_id'))
                    <a class="nav-link active" href="/Application/index">Application</a>
                 @endif
         @endforeach
        </li>
        <li class="nav-item">
            @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Receiving Vouchers' && $menu->user_id == session()->get('user_id'))
                    <a class="nav-link active" href="/Rvoucher/index">Receiving</a>
            @endif
            @endforeach
        </li>
        <li class="nav-item">
          
                      @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Payment Vouchers' && $menu->user_id == session()->get('user_id'))
                    <a class="nav-link active" href="/Pvoucher/index">Payments</a>
            @endif
            @endforeach
        </li>
        <li class="nav-item">
          
                      @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Customer Receipts' && $menu->user_id == session()->get('user_id'))
                    <a class="nav-link active" href="/Cvoucher/index">Customer Receipt</a>
            @endif
            @endforeach
        </li>          
        <li class="nav-item">
         
                      @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Accounts' && $menu->user_id == session()->get('user_id'))
                    <a class="nav-link active" href="/account/index">Accounts</a>
            @endif
            @endforeach
        </li>     
        <li class="nav-item">

            @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Journal Entry' && $menu->user_id == session()->get('user_id'))
                    <a class="nav-link active" href="/journal/index">Journal</a>
            @endif
            @endforeach
                    

        </li>           
        <li class="nav-item">
          <a class="nav-link active" href="https://docs.google.com/spreadsheets/d/1HeM1TXoe2LuHXqmHl6A30uJbU45CtMav8HUiMbaMH6s/edit?gid=0#gid=0">Excel</a>
        </li>                 
               
        

        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle active" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            Reports
          </a>
          <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
     

                                <li>
                                    
                                    
        
                    <a class="dropdown-item" href="/reports/trial-balance">Date Wise Trail Balance </a>

                                    </li>
                                    
                                    
                                <li>
                                    
                                    
             @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Trail Balance' && $menu->user_id == session()->get('user_id'))
                    <a class="dropdown-item" href="/report/trailbalance"> Trail Balance </a>
            @endif
            @endforeach
                                    </li>

                                <li>
                                    
                                    
             @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Recovery Report' && $menu->user_id == session()->get('user_id'))
                    <a class="dropdown-item" href="/report/floor_wise_recovery"> Recovery Report </a>
            @endif
            @endforeach
                                    </li>
          

            
                    <li>
                                              @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Cash Book' && $menu->user_id == session()->get('user_id'))
                    <a class="dropdown-item" href="/report/cashbook">Cash Book</a>
            @endif
            @endforeach
                        </li>
                        
                                                                                                                              @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Cash Book Category' && $menu->user_id == session()->get('user_id'))
                                                  <li>
                                              
                  
                    <a class="dropdown-item" href="/report/cashbook_category">Cash Book Category</a>
            
                        </li>  
            @endif
            @endforeach
            
                         

                <li>
                    
                    
                          
                                                                                                      @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Account Ledger' && $menu->user_id == session()->get('user_id'))
                                  <a class="dropdown-item" href="/report/ledger">Accounts Ledger</a>
            @endif
            @endforeach
                    
                    </li>

                <li>
                    
                    
      
            @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Monthly Installment' && $menu->user_id == session()->get('user_id'))
                                  <a class="dropdown-item" href="/report/installment">Monthly Installment</a>
            @endif
            @endforeach
                    
                    
                    </li>
             @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Recovery' && $menu->user_id == session()->get('user_id'))
                                  <li><a class="dropdown-item" href="/report/recovery">Recovery</a></li>
            @endif
            @endforeach
            
                         @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Receivables' && $menu->user_id == session()->get('user_id'))
                                   <li><a class="dropdown-item" href="/report/receivable">Receivables</a></li>
            @endif
            @endforeach
            
                                 
                         @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Payables' && $menu->user_id == session()->get('user_id'))
                                   <li><a class="dropdown-item" href="/report/payable">Payables</a></li>
            @endif
            @endforeach
            
       
                                @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Vacant List' && $menu->user_id == session()->get('user_id'))
                                   <li><a class="dropdown-item" href="/report/Vacants">Vacant List</a></li>
            @endif
            @endforeach
            
            
          </ul>
        </li>        
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle active" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            Others
          </a>
          <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
              
                                                  @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Lookup Receiving Voucher' && $menu->user_id == session()->get('user_id'))
                    <li><a class="dropdown-item" href="/Rvoucher/index">Lookup Receiving Voucher</a></li>
            @endif
            @endforeach
            
                                                  @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Lookup Customer Receipts' && $menu->user_id == session()->get('user_id'))
                                
            <li><a class="dropdown-item" href="/Cvoucher/index">Lookup Customer Receipts</a></li>
            @endif
            @endforeach         
            
                                                  @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Lookup Payment Vouchers' && $menu->user_id == session()->get('user_id'))
                                
            <li><a class="dropdown-item" href="/Pvoucher/index">Lookup Payment Vouchers</a></li>
            @endif
            @endforeach           
            
                                                  @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Lookup Projects' && $menu->user_id == session()->get('user_id'))
                                
            
            <li><a class="dropdown-item" href="/Project/index">Lookup Projects</a></li>
            @endif
            @endforeach               


                                                  @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Cheques' && $menu->user_id == session()->get('user_id'))
                                
            
            <li><a class="dropdown-item" href="/cheques/index">Cheques</a></li>
            @endif
            @endforeach  

                                                  @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Users' && $menu->user_id == session()->get('user_id'))
                                
            
                      <li><a class="dropdown-item" href="/Users/index">Users</a></li>
            @endif
            @endforeach  
            

                                                  @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Authorize Payments' && $menu->user_id == session()->get('user_id'))
                                
            
                                  <li><a class="dropdown-item" href="/report/inout">Authorize Payments</a></li>
            @endif
            @endforeach  

                                                  @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Authorize Receipt' && $menu->user_id == session()->get('user_id'))
                                
            
                                  <li><a class="dropdown-item" href="/report/ReceiptChecker">Authorize Receipt</a></li>
            @endif
            
            
            
            @endforeach  
                                          <li><a class="dropdown-item" href="{{ route('floor_wise_return') }}">Customer Return Report</a></li>
                                          <li><a class="dropdown-item" href="{{ route('download.database') }}">Backup</a></li>

          </ul>
        </li>        
        
        
        <li class="nav-item dropdown">
            
          <a class="nav-link dropdown-toggle active" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            Stock
          </a>
          <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
              
                                    @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Add Items' && $menu->user_id == session()->get('user_id'))
                    <li><a class="dropdown-item" href="/Items/add">Add Items</a></li>
            @endif
            @endforeach
            
                                     @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Create Purchase' && $menu->user_id == session()->get('user_id'))
                    <li><a class="dropdown-item" href="/Purchase/add">Create Purchase</a></li>
            @endif
            @endforeach
 
                                      @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Lookup Purchase' && $menu->user_id == session()->get('user_id'))
                    <li><a class="dropdown-item" href="/Purchase/index">Lookup Purchase</a></li>
            @endif
            @endforeach
            

                                      @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Stock Out' && $menu->user_id == session()->get('user_id'))
                   <li><a class="dropdown-item" href="/Sale/add">Stock Out</a></li>
            @endif
            @endforeach           
            

                                      @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Add Items' && $menu->user_id == session()->get('user_id'))
                    <li><a class="dropdown-item" href="/Sale/index">Lookup Stock Out</a></li>   
            @endif
            @endforeach 
            
                                      @foreach($mainMenu as $menu)
                  @if($menu->menu_name == 'Add Items' && $menu->user_id == session()->get('user_id'))
                    <li><a class="dropdown-item" href="/report/InStock">Current Stock Position</a></li>
            @endif
            @endforeach 

            
                        
          </ul>
        </li>       


      </ul>
      <form class="d-flex lead text-light">
@if(session()->get('role') == 1)
<a href="https://alameenbuilders.pk/cheques/index">
<button type="button"  class="btn btn-primary btn-sm position-relative mt-1">
  Cheques
  <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">{{session()->get('unclearedCount')}}</span>
</button>
</a>&nbsp;&nbsp;
@endif
          <h5 class="pt-2">Hi! {{session()->get('user_name')}} <a href="/logout" style=" color: #ffffff; font-size:15px; text-decoration: none;">&nbsp; <i class="fa-solid fa-right-from-bracket"></i></a></h5> 
          
      </form>
    </div>
  </div>
</nav>




    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" ></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js" integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    
    
<div class="content">
@yield('main')    
</div>

@stack('scripts')

</body>


</html>
