@extends('header')
@section('title','Journal Entry')
@section('main')


<div class="container d-flex justify-content-center mt-3">    
    <div class="card text-left" style="width: 50rem;">
        <div class="card-header">
            Add New Record
        </div>
        <form action="{{url('/journal/add')}}" method="post">
                @csrf
        
        <div class="card-body">
            <h5 class="card-title pb-2">Journal Entry</h5>
                <div class="row g-1">
                    <div class="col-6">
                        <div class="input-group mb-3">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">JV Date:</span>
                          </div>
                                <input type="date" value="{{ now()->format('Y-m-d') }}" class="form-control" name="date" placeholder="Enter Your Date Here">
                                <span class="text-danger">@error('date'){{$message}}@enderror</span>
                        </div>

                    </div>
                    <div class="col-1">
                        <input type="text" id="projectid" name="projectid" value="{{ old('projectid') }}" class="form-control" placeholder="id">   
                    </div>
                    <div class="col-5">
                        <div class="input-group mb-3">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">Project Name:</span>
                          </div>
                            <select class="form-control" id="project_name" name="project_name">
                            <option value="{{ old('project_name') }}" selected>
                                    {{ old('project_name') }}
                            </option>
    
                            @foreach($projectdata as $data)
                                <option data-id="{{ $data->id }}" value="{{ $data->project_name }}">{{ $data->project_name }}</option> 
                            @endforeach
                            </select>
                            
                            <span class="text-danger">
                                @error('projectid')
                                <p>Please select your Project</p>
                                @enderror
                            </span>
                        </div>
                        
                        
                    </div>
                </div>
                <div class="row g-1">
                    <div class="col-1">
                        <input type="text" id="headercode" value="{{ old('headercode') }}" name="headercode" class="form-control " placeholder="header code">
                    </div>
                    <div class="col-1">
                        <input type="text" id="accountid" value="{{ old('accountid') }}"name="accountid" class="form-control " placeholder="account id">
                    </div>
                    <div class="col-4">
                        <div class="input-group mb-3">
                              <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1">Account:</span>
                              </div>
                                                      <select class="form-control " id="account_name" name="account_name" >
                                    <option value="{{ old('account_name') }}" selected>
                                @if(old('account_name')== null)
                                Select Your Account
                                @else
                                {{ old('account_name') }}
                                @endif
                                </option>
                            </select>
                            <span class="text-danger">
                                @error('accountid')
                                <p>Please select your Account</p>
                                @enderror
                            </span>
                        </div>
                    </div>   
                    <div class="col-6">
                        <div class="input-group mb-3">
                              <div class="input-group-prepend">
                                <span class="input-group-text" id="basic-addon1">Description:</span>
                              </div>
                               <textarea class="form-control text-left" name="desc" rows="1"> {{ old('desc') }} </textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-6">
                        <div class="input-group mb-3">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">Debit:</span>
                          </div>
                          <input type="text" class="form-control" value="{{ old('debit') }}" name="debit" placeholder="Debit">
                        </div>
                        
                    </div>
                    <div class="col-6">
                        <div class="input-group mb-3">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">Credit:</span>
                          </div>
                          <input type="text" class="form-control" value="{{ old('credit') }}" name="credit" placeholder="credit">
                        </div>
                        
                    </div>
                </div>
        </div>
        <div class="card-footer">
        <button type="submit" class="btn btn-primary">Save/Close</button>  
                <a href="{{route('journal.index')}}" class="btn btn-warning">Cancel/Close</a>
        </div>
        </form>  
    </div>
</div>
<script>


$('#project_name').change(function(){

    
     var selected = $(this).find('option:selected');    
     var projectid = selected.data('id');
     $('#projectid').val( projectid );


     //append into account dropdown start here
     var pid=jQuery(this).val();
            $.ajax({
                url: '{{ route("Pvoucher.accounts") }}',
                type: 'POST',
                data: 'projectid='+projectid+'&_token={{csrf_token()}}',

                success:function(result){
                    $('#account_name').html('<option value="">Select Your Account</option>');
                        $.each(result.accounts, function (key, value) {
                            $("#account_name").append('<option data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.customer_name + '">' + value.customer_name + '</option>');
                        });


                }
            });
        //end 
    
});


$('#account_name').change(function(){
    var selected = $(this).find('option:selected');
    var headercode = selected.data('headercode');
    var selected = $(this).find('option:selected');
    var accountid = selected.data('accountid');

    $('#headercode').val( headercode );
    $('#accountid').val( accountid );
    //alert(headercode + accountid)

});


</script>
@endsection
