@extends('header')
@section('title','Edit Journal Entry')
@section('main')
<div class="container d-flex justify-content-center mt-3">    
    <div class="card text-left" style="width: 50rem;">
        <div class="card-header">
            Edit Record
        </div>
        
        <form action="{{url('/journal/update')}}/{{$record->id}}" method="post">

                @csrf
        
        <div class="card-body">
            <h5 class="card-title pb-2">Journal Entry</h5>
                <div class="row g-1">
                    <div class="col-6">
                        <div class="input-group mb-3">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">Date:</span>
                          </div>
                              <input type="date" value="@if (isset($record->jv_date)){{$record->jv_date}}@else {{ now()->format('Y-m-d') }} @endif" class="form-control" name="date" placeholder="Enter Your Date Here">
                                <span class="text-danger">
                                    @error('date')
                                    {{$message}}
                                    @enderror
                                </span>
                        </div>

                    </div>
                    <div class="col-1">
                        <input type="text" id="projectid" name="projectid" value="{{ $record->project_id }}" class="form-control" placeholder="type id here">                    
                    </div>
                    <div class="col-5">
                        <div class="input-group mb-3">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">Project:</span>
                          </div>
                          <select class="form-control m-bot15" id="project_name" name="project_name">
                        <option value=" {{ $record->project_name }}" selected>{{ $record->project_name }}</option>

                        @foreach($projectdata as $data)
                            <option data-id="{{ $data->id }}" value="{{ $data->project_name }}">{{ $data->project_name }}</option> 
                        @endforeach
                        </select>
                        <span class="text-danger">
                            @error('projectid')
                            <p>Please select your Project</p>
                            @enderror
                        </span>
                        </div>
                        
                    </div>
                </div>
            
                <div class="row g-1 pt-2">
                    <div class="col-1">
                    <input type="text" id="headercode" value=" {{ $record->header_code }}" name="headercode" class="form-control ">
                    </div>
                    <div class="col-1">
                    <input type="text" id="accountid" value=" {{ $record->account_id }}" name="accountid" class="form-control ">
                    </div>
                    <div class="col-4">
                        <div class="input-group mb-3">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">Account:</span>
                          </div>
                           <select class="form-control " id="account_name" name="account_name" >
                        <option value=" {{ $record->account_name }}" selected> {{ $record->account_name }}</option>
                        @foreach($accountdata as $data)
                        <option data-accountid="{{ $data->account_id }}" data-headercode="{{ $data->header_code }}" value="{{ $data->account_name }}">{{ $data->account_name }}</option> 
                        @endforeach
                        </select>
                        <span class="text-danger">
                            @error('accountid')
                            <p>Please select your Account</p>
                            @enderror
                        </span>
                         </div>
                       
                    </div>
                    <div class="col-6">
                    <div class="input-group mb-3">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">Description:</span>
                          </div>
                        <textarea class="form-control" name="desc" id="exampleFormControlTextarea1" rows="1">{{ $record->description }}</textarea>
                    </div>
                    
                    </div>
                    
                </div>
                <div class="row g-1 pt-2">
                    <div class="col-6">
                        <div class="input-group mb-3">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">Debit:</span>
                          </div>
                          <input type="text" class="form-control form-control-sm" value=" {{ $record->debit }}" name="debit">
                        </div>
                     </div>
                     <div class="col-6">
                        <div class="input-group mb-3">
                          <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">Credit:</span>
                          </div>
                          <input type="text" class="form-control form-control-sm" value=" {{ $record->credit }}" name="credit">
                         </div>
                     </div>
                    

                    
                </div>                
            
        </div>
        <div class="card-footer">
        
            <button type="submit" class="btn btn-primary btn-sm">Save/Close</button>          
            <a href="{{url('/journal/index')}}">
            <button type="button" class="btn btn-info btn-sm">Cancel/Close</button>        
            </a>
            
        </div>
        </form>  
    </div>
</div>


<script>


$('#project_name').change(function(){

    
     var selected = $(this).find('option:selected');    
     var projectid = selected.data('id');
     $('#projectid').val( projectid );


     //append into account dropdown start here
     var pid=jQuery(this).val();
            $.ajax({
                url: '{{ route("Pvoucher.accounts") }}',
                type: 'POST',
                data: 'projectid='+projectid+'&_token={{csrf_token()}}',

                success:function(result){
                    $('#account_name').html('<option value="">Select Your Account</option>');
                        $.each(result.accounts, function (key, value) {
                            $("#account_name").append('<option data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.customer_name + '">' + value.customer_name + '</option>');
                        });


                }
            });
        //end 
    
});


$('#account_name').change(function(){
    var selected = $(this).find('option:selected');
    var headercode = selected.data('headercode');
    var selected = $(this).find('option:selected');
    var accountid = selected.data('accountid');

    $('#headercode').val( headercode );
    $('#accountid').val( accountid );
    //alert(headercode + accountid)

});


</script>




@endsection
