@extends('header')
@section('title','Journal Entry')
@section('main')

        <div class="container-md shadow mt-md-3 border-top rounded-top border-2 border-primary bg-light">
                <div class="row "> 

                <div class="col-4 d-flex justify-content-left mt-3">
                                @if($users_menu->user_add == 1)
                <a href="{{url('/journal/add')}}">
                <button class="btn btn-success btn-sm">Add New &nbsp; <i class="fa-solid fa-plus icon-white"></i></button> 
                </a>
                @endif
            </div>

                    <div class="col-4  d-flex justify-content-center mt-2">             
                    <h1 style="font-family: 'Brush Script MT', cursive;">Journal Entry</h1>
            </div>
           
            <div class="col-4 mt-3 d-flex justify-content-end">
                <form class="row g-1">
                    <div class="col-auto ">
                        <input class="form-control form-control-sm " name="search" type="search" placeholder="Search here!">
                    </div>
                    <div class="col-auto">
                    <a href="{{url('/journal/index')}}">
                        
                    </a>
                    </div>
                    
                </form>
            </div>
        </div>
        
        <table class="table table-sm table-hover mt-3">

                <thead>
                    <tr>
                    <th scope="col">#</th>
                    <th scope="col">Date</th>
                    <th scope="col">Project</th>
                    <th scope="col">Account</th>
                    <th scope="col">Description</th>
                    <th scope="col" class="text-end">Debit</th>
                    <th scope="col" class="text-end">Credit</th>
                    
                    <th class="text-center" scope="col">Action</th>
                    
                    </tr>
                </thead>
                <tbody>
                @foreach($data as $datas)
                        <tr>
                        <td>{{ $datas->id }}</td> 
                        
                        <td>{{ date('d-M-y', strtotime($datas->jv_date)) }}</td>
                        <td>{{ $datas->project_name }}</td>
                        <td>{{ $datas->header_code . "-" . $datas->account_name }}</td>
                        <td>{{ Str::of($datas->description)->limit(25) }}</td>
                        <td class="text-end">{{ number_format($datas->debit,0) }}</td>    
                        <td class="text-end">{{ number_format($datas->credit,0) }}</td>    
                        <td class="text-center">
                             @if($users_menu->user_edit == 1)
                            <a href="{{route('journal.edit', ['id' => $datas->id])}}">
                                <i class="fa-solid fa-pen-to-square icon"></i>
                            </a>
                            @else
                            ----
                            @endif
                        </td>   
                                                
                        </tr>
                    @endforeach
                </tbody>

                </table>

          
                <div class="row">
                {{ $data->onEachSide(0)->links('pagination::bootstrap-5') }}
                  </div>

    </div>

@endsection
