@extends('header')
@section('title','Home Page')
@section('main')


@push('styles')
<link href='https://fonts.googleapis.com/css?family=Poppins' rel='stylesheet'>
    <style>
        .box {
            border: 1px solid #ddd;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            transition: transform 0.3s;
            font-family: 'Poppins';
            padding: 10px;
            box-shadow: 3px 5px #888888;
        }
        .box:hover {
            transform: scale(1.05);
        }
    </style>
@endpush

@if ($role == 1)


    <div class="container mt-5">
        <div class="row">
            <div class="col-md-4 mb-4 ">
                <div class="box bg-primary text-white">
                   <h2><i class="fa-solid fa-receipt"></i></h2>
        <h4><b>Receivables</b></h4>
        <h5><b>{{number_format($receivables,0)}}</b></h5>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="box bg-success text-white">
                    <h2><i class="fa-solid fa-file-invoice-dollar"></i></h2>
        <h4><b>Payables</b></h4>
        <h5><b>{{number_format($payable,0)}}</b></h5>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="box bg-danger text-white">
                   <h2><i class="fa-solid fa-hourglass"></i></h2>
        <h4><b>Vacants</b></h4>
        <h5><b>{{number_format($vacant,0)}}</b></h5>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="box bg-warning text-white">
                    <h2><i class="fa-solid fa-coins"></i></h2>
        <h4><b>Capital</b></h4>
        <h5><b>{{number_format($capital,0)}}</b></h5>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="box bg-info text-white">
                    <h2><i class="fa-solid fa-sack-dollar"></i></h2>
        <h4><b>Cash In Hand</b></h4>
        <h5><b>{{number_format($cash_in_hand,0)}}</b></h5>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="box bg-dark text-white">
                    <h2><i class="fa-solid fa-sack-dollar"></i></h2>
        <h4><b>Expense</b></h4>
        <h5><b>{{number_format($expense,0)}}</b></h5>
                </div>
            </div>
            
        </div>
    </div>

</br>


<div class="container shadow pt-4 border-top rounded-top border-2 border-primary">
    <div class="row">
        <div class="col-">
            <div class="seven">
                <h1>Daily Cash Flow</h1>
                </div>
            <table class="table table-sm table-striped" style="font-family: 'Comic Sans MS', cursive;">
                
                <tr>
                    <th style="width:10%;">Date</th>
                    <th style="width:15%;">Project Name</th>
                    <th style="width:15%;">Account Name</th>
                    <th>Description</th>
                    <th class="text-end">Debit</th>
                    <th class="text-end">Credit</th>
                </tr>

                @foreach($output as $data)
                <tr>
                    <td> {{ date('d-M-y', strtotime($data->date)) }}</td>
                    <td> {{ $data->ProjectName }}</td>
                    <td> {{ $data->account_name }}</td>
                    <td> {{ Str::of($data->description)->limit(60) }}</td>
                    <td class="text-end"> {{ number_format($data->debit,0) }}</td>
                    <td class="text-end"> {{ number_format($data->credit,0) }}</td>
                </tr>        
                @endforeach
            </table>
        </div>
    </div>
</div>
            
@endif
@endsection