<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Trial Balance</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .group-header { background: #f1f7ff; font-weight: 700; }
        .account-row td:first-child { padding-left: 1.25rem; }

        /* Page setup for printing */
        @page {
            size: A4;
            margin: 0;
        }

        @media print {
            body, html {
                padding: 0px;
                font-size: 13px;
                line-height: 1.0;
            }

            /* Hide filters and buttons */
            .d-print-none { display: none !important; }

            /* Force side-by-side columns on print */
            .row.print-row {
                display: flex !important;
                flex-wrap: nowrap !important;
            }
            .row.print-row > .col-md-6 {
                flex: 0 0 50% !important;
                max-width: 50% !important;
            }
        }
    </style>
</head>
<body>
<div class="container-fluid my-3">

    <!-- Print Button -->
    <button onclick="window.print()" class="btn btn-primary d-print-none mb-3">
        🖨 Print
    </button>

    <!-- Filter Form -->
    <form method="GET" action="{{ route('reports.trailbalance') }}" class="row g-3 mb-4 d-print-none">
        <div class="col-md-3">
            <label class="form-label">Start Date</label>
            <input type="date" name="start_date" value="{{ request('start_date') }}" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">End Date</label>
            <input type="date" name="end_date" value="{{ request('end_date') }}" class="form-control">
        </div>
        <div class="col-md-4">
            <label class="form-label">Project</label>
            <select name="project_id" class="form-select">
                <option value="">-- All Projects --</option>
                @foreach($projects as $p)
                    <option value="{{ $p->ProjectID }}" {{ request('project_id') == $p->ProjectID ? 'selected' : '' }}>
                        {{ $p->ProjectName }}
                    </option>
                @endforeach
            </select>
        </div>
        <div class="col-md-2 d-grid">
            <button class="btn btn-primary">Filter</button>
        </div>
    </form>

    <!-- Page Header -->
    <h4 class="mb-3">Trial Balance
        @if($start_date && $end_date)
            <small class="text-muted">({{ $start_date }} to {{ $end_date }})</small>
        @endif
        @if($selectedProject)
            <br><small class="text-muted">Project: {{ $selectedProject->ProjectName }}</small>
        @endif
    </h4>

    <!-- Debit & Credit Tables Side by Side -->
    <div class="row print-row">
        <!-- Debit Column -->
        <div class="col-md-6">
            <h5>Debit</h5>
            <table class="table table-sm table-bordered">
                <thead class="table-light">
                    <tr>
                        <th>Account Type</th>
                        <th>Account Name</th>
                        <th class="text-end">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($debitsGrouped as $type => $accounts)
                        <tr class="group-header"><td colspan="2">{{ $type }}</td></tr>
                        @foreach($accounts as $acc)
                            <tr class="account-row">
                                <td colspan="2">{{ $acc->account_name }}</td>
                                <td class="text-end">{{ number_format($acc->amount, 2) }}</td>
                            </tr>
                        @endforeach
                        <tr class="group-header">
                            <td colspan="2" class="text-end">Total Of {{ $type }}</td>
                            <td class="text-end">{{ number_format($debitsGroupTotals[$type] ?? 0, 2) }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="3" class="text-center text-muted">No debit rows</td></tr>
                    @endforelse
                </tbody>
                <tfoot>
                    <tr class="table-secondary fw-bold">
                        <td colspan="2">Grand Total Debit</td>
                        <td class="text-end">{{ number_format($grandDebit, 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>

        <!-- Credit Column -->
        <div class="col-md-6">
            <h5>Credit</h5>
            <table class="table table-sm table-bordered">
                <thead class="table-light">
                    <tr>
                        <th>Account Type</th>
                        <th>Account Name</th>
                        <th class="text-end">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($creditsGrouped as $type => $accounts)
                        <tr class="group-header"><td colspan="2">{{ $type }}</td></tr>
                        @foreach($accounts as $acc)
                            <tr class="account-row">
                                <td colspan="2">{{ $acc->account_name }}</td>
                                <td class="text-end">{{ number_format($acc->amount, 2) }}</td>
                            </tr>
                        @endforeach
                        <tr class="group-header">
                            <td colspan="2" class="text-end">Total Of {{ $type }}</td>
                            <td class="text-end">{{ number_format($creditsGroupTotals[$type] ?? 0, 2) }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="3" class="text-center text-muted">No credit rows</td></tr>
                    @endforelse
                </tbody>
                <tfoot>
                    <tr class="table-secondary fw-bold">
                        <td colspan="2">Grand Total Credit</td>
                        <td class="text-end">{{ number_format($grandCredit, 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Difference -->
    <div class="mt-3">
        <h5>
            Difference (Credit - Debit):
            <span class="{{ $difference < 0 ? 'text-danger' : 'text-success' }}">
                {{ number_format($difference, 2) }}
            </span>
        </h5>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
