<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous" />
    <title>Floor Wise Recovery</title>
    <style>
        @media print {
            @page {
                size: landscape A4;
                margin: 0;
            }
            html, body {
                padding: 10px;
                line-height: 15px;
                font-size: 11px;
            }
            a {
                text-decoration: none;
            }
        }
        #alignr { text-align: right; }
        #alignc { text-align: center; }
        #date_print { width: 150px !important; }
        body { font-size: 13px; }
    </style>
</head>
<body>

<div class="container">

    <h1>Floor Wise Return Report</h1>

    <h3>Company: {{ $company_info->company_name ?? 'N/A' }}</h3>

    <h4>Customers Return</h4>

    <form method="GET" id="projectForm">
        <select 
            class="form-control d-print-none" 
            id="project_name" 
            name="projectid" 
            onchange="this.form.submit()"
        >
            <option value="">Select Your Project</option>
            @foreach($projectdata as $data)
                <option 
                    value="{{ $data->id }}" 
                    {{ (request('projectid') == $data->id) ? 'selected' : '' }}
                >
                    {{ $data->project_name }}
                </option>
            @endforeach
        </select>
    </form>

    @if($customers->isEmpty())
        <p>No customer returns found for the selected project.</p>
    @else
        <table class="table table-bordered table-striped mt-3">
            <thead class="thead-dark">
                <tr>
                    <th style="width:10%;">Acc-Code</th>
                    <th>Unit No</th>
                    <th style="width:25%;">Customer Name</th>
                    <th>Total Received</th>
                    <th>Total Return</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($customers as $customer)
                    <tr>
                        <td>{{ $customer->header_code . '-' .$customer->account_id }}</td>
                        <td>{{ $customer->unit_no }}</td>
                        <td>{{ $customer->customer_name }}</td>
                        <td>{{ number_format($customer->SumOfReceiving, 2) }}</td>
                        <td>{{ number_format($customer->SumOfReturn, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif

</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" crossorigin="anonymous"></script>

<script>
    function myFunction() {
        document.getElementById("pname").innerHTML = $("#project_name").val();
        window.print();
    }
</script>

</body>
</html>
