@extends('header')
@section('title','Receipt Side')
@section('main')

    
<div class="container">
<form method="get" class="pt-3">
    <div class="row">
        <div class="col-">
            <div class="seven">
                <h1>Receipt Side</h1>
                </div>
            
        </div>        
    </div>
    <div class="row">
        <div class="col-11">
            <input type="hidden" name="projectid" id="projectid" class="form-control "   value=@if(isset($_GET['projectid'])){{ $_GET['projectid']}}@endif>
            <select class="form-control form-control-sm d-print-none" id="project_name" name="project_name" >
                             <option>Select Your Project</option>
                         @foreach($projectdata as $data)
                         <option data-id="{{ $data->id }}" @if(isset($_GET['projectid'])){{$data->id ==  $_GET['projectid']  ? 'selected' : '' }}@endif
                         value="{{ $data->project_name }}">{{ $data->project_name }}</option>
                         @endforeach
            </select>
        </div>
        <div class="col-1">
            <button type="submit" class="btn btn-info btn-sm d-print-none">Try Now</button>
        </div>
    </div>
</form>
<div class="row">
    <div class="col-">
        <form id="UpdateForm">
    @csrf
<table class="table table-sm mt-3 table-striped table-bordered">

<thead>
    <tr>
    <th scope="col" style="width:10%;">Date</th>
    <th scope="col" style="width:20%;">Account Name</th>
    <th scope="col" style="width:40%;">Description</th>
    <th scope="col">Folio</th>
    <th scope="col"  class="text-end" style="width:10%;">Amount</th>
    <th scope="col"  class="text-center" style="width:10%;">Action</th>
    
    </tr>
</thead>
<tbody>



@foreach($voucherdata as $datas)
        
        <tr class="{{ $datas->id }}">

        <td>{{ date('d-M-y', strtotime($datas->cvdate)) }}</td>                 
        <td>{{ $datas->account_name }}</td>
        <td >
            <span class="d-print-none">{{ $datas->description }}</span>
            <span class="d-none d-print-block">{{ Str::of($datas->description)->limit(25) }}</span>
        </td>
        <td>{{$datas->id}}</td> 
        <td class="text-end">{{ number_format($datas->total_amount,0) }}</td> 

        <td  class="text-center"><input class="form-check-input" name="ids[]" type="checkbox" value="{{ $datas->id }}"></td> 

                                
        </tr>
    @endforeach

    
</tbody>
</div>    
</table>
<input type="submit" value="Update">
</form>
    </div>
</div>

</div>





@push('scripts')
<script>
         $('#project_name').change(function(){
         
           var selected = $(this).find('option:selected');    
            var projectid = selected.data('id');
            $('#projectid').val( projectid );
            
         });
</script>  
<script>
	$(document).ready(function(){
	$("#UpdateForm").submit(function(e){
	e.preventDefault();
	var formData = $(this).serialize();

	$.ajax({
		url:"{{ route('UpdateUserReceipt') }}",
		type:"POST",
		data:formData,
		success:function(data){
			
			if(data.success == true){
            	var ids = data.ids;
            	for(let i = 0; i<ids.length; i++)
                {
                	$('.'+ids[i]).remove();
                }
            }   
			
		}
	});	
	});
	});
</script>
@endpush
@endsection