<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Trial Balance Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { font-size: 14px; }
        .report-title { font-size: 20px; font-weight: bold; margin-bottom: 20px; text-align: center; }
        .table th, .table td { vertical-align: middle; }
        .table tfoot td { font-weight: bold; }
    </style>
</head>
<body class="p-4">

    <div class="report-title">
        Trial Balance Report
        @if($startDate && $endDate)
            <div class="text-muted" style="font-size: 14px;">
                Period: {{ $startDate }} to {{ $endDate }}
            </div>
        @endif
    </div>

    <!-- Filters -->
    <form method="GET" action="{{ route('reports.jvBalance') }}" class="row g-3 mb-4">
        <div class="col-md-3">
            <label class="form-label">Start Date</label>
            <input type="date" name="start_date" value="{{ $startDate }}" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">End Date</label>
            <input type="date" name="end_date" value="{{ $endDate }}" class="form-control">
        </div>
        <div class="col-md-3">
            <label class="form-label">Project</label>
            <select name="project_id" class="form-select">
                <option value="">All Projects</option>
                @foreach($projects as $p)
                    <option value="{{ $p->project_id }}" {{ $projectId == $p->project_id ? 'selected' : '' }}>
                        {{ $p->project_name }} ({{ $p->project_id }})
                    </option>
                @endforeach
            </select>
        </div>
        <div class="col-md-2 align-self-end">
            <button class="btn btn-primary w-100">Filter</button>
        </div>
    </form>

    <!-- Table -->
    <table class="table table-bordered text-center">
        <thead class="table-dark">
            <tr>
                <th>Header Code</th>
                <th>Account Name</th>
                <th>Project</th>
                <th class="text-end">Debit (Dr)</th>
                <th class="text-end">Credit (Cr)</th>
            </tr>
        </thead>
        <tbody>
            @forelse($records as $row)
                <tr>
                    <td>{{ $row->header_code }}</td>
                    <td class="text-start">{{ $row->account_name }}</td>
                    <td>{{ $row->project_name }}</td>
                    <td class="text-end">{{ number_format($row->total_debit, 2) }}</td>
                    <td class="text-end">{{ number_format($row->total_credit, 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="text-center text-muted">No records found</td>
                </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr>
                <td colspan="3" class="text-end">Grand Total:</td>
                <td class="text-end">{{ number_format($grandDebit, 2) }}</td>
                <td class="text-end">{{ number_format($grandCredit, 2) }}</td>
            </tr>
        </tfoot>
    </table>

</body>
</html>
