<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="UTF-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">
      <title>Account Ledger</title>
      <style>

    @page {
       size: A4;
       margin: 0;
        }
        
        @media print {
            
          html, body{
              margin: 0;
            padding:15px;
            font-size:13px;
            font-family: Arial, Helvetica, sans-serif;
            
          }

          /* ... the rest of the rules ... */
        }
        
            .table{
             line-height:1.0 !important;
             
         }
         



      </style>
   </head>
   <body>
       
       

     
      <div class="container-fluid">
           <center><button type="button" class="btn btn-primary btn-sm d-print-none" onclick="window.print();">Print</button></center>
         <div class="row g-1 mt-3">
            <div class="col-6" >
                
                <h3>{{$company_info->company_name}}</h3>    
                <h5>{{$company_info->address}}</h5>    
                <h5>{{$company_info->mobile}}</h5>    
      
                
            </div>
            <div class="col-6 text-end">
                <h2>{{$projectname}}</h2>
                 <small><?php echo "Printed:- " . date("d-M-y h:i:sa");?></small></br>
                 <h5>ACCOUNT LEDGER</h5>
                

            </div>
            


               </div>
               <hr>
        <div class="row">
            <div class="col-6">
                <h5>{{$headercode .'-' . $accountid}}</h5>
                                <h5>{{$accountname}}</h5>
                <h5>{{$unit_no}}</h5>       
            </div>
            <div class="col-6 text-end">
                <h6>Start Date:- {{date('d-M-Y', strtotime($start_date))}}</h6>
                <h6>End&nbsp;&nbsp; Date:- {{date('d-M-Y', strtotime($end_date))}}</h6>
                 <h6 >Opening Balance {{ number_format($openingbal,0)}}</h6>
            </div>
        </div>
         <?php 
            $running_dr = 0;
            $running_cr = 0;
            $total = 0;
            $cost=0;
            ?>
                
                
              @if ($headercode == 101)
                <?php 
                $cost = is_object($TotalCost) ? $TotalCost->total_cost : 0;
                ?>


              
              @endif
             <div class="table-responsive">
    <table class="table table-sm table-hover table-bordered">
        <thead style="font-family: 'Comic Sans MS', cursive; font-size:16px;">
            <tr>
                <th scope="col" style="width:10%;">Date</th>
                <th scope="col" style="width:50%;">Description</th>
                <th scope="col">Folio</th>
                <th scope="col" class="text-end">Debit</th>
                <th scope="col" class="text-end">Credit</th>
                <th scope="col" class="text-end">Balance</th>
            </tr>
        </thead>
        <tbody>
            {{-- Opening Balance --}}
            <tr>
                <td></td>
                <td>Opening Balance</td>
                <td></td>
                <td class="text-end">{{ number_format($openingbal, 0) }}</td>
                <td></td>
                <td class="text-end">{{ number_format($openingbal, 0) }}</td>
            </tr>

            {{-- Total Cost (only if HeaderCode = 101) --}}
            @php
                $cost = ($headercode == 101 && $TotalCost > 0) ? $TotalCost : 0;
            @endphp

            @if ($cost > 0)
                <tr>
                    <td>{{ $DateBooking ? date('d-M-y', strtotime($DateBooking)) : '' }}</td>
                    <td>Total Cost</td>
                    <td></td>
                    <td class="text-end">{{ number_format($cost, 0) }}</td>
                    <td></td>
                    <td class="text-end">{{ number_format($openingbal + $cost, 0) }}</td>
                </tr>
            @endif

            {{-- Voucher Entries --}}
            @php
                $running_dr = 0;
                $running_cr = 0;
            @endphp

            @foreach($voucherdata as $datas)
                @php
                    $running_dr += $datas->debit;
                    $running_cr += $datas->credit;
                    $balance = ($openingbal + $cost + $running_dr) - $running_cr;
                @endphp
                <tr>
                    <td>{{ date('d-M-y', strtotime($datas->jv_date)) }}</td>
                    <td>{{ $datas->description }}</td>
                    <td>{{ $datas->id }}</td>
                    <td class="text-end">{{ number_format($datas->debit, 0) }}</td>
                    <td class="text-end">{{ number_format($datas->credit, 0) }}</td>
                    <td class="text-end">{{ number_format($balance, 0) }}</td>
                </tr>
            @endforeach

            {{-- Grand Totals --}}
            <tr>
                <td></td>
                <td><b>Grand Total</b></td>
                <td></td>
                <td class="text-end"><b>{{ number_format($running_dr + $openingbal + $cost, 0) }}</b></td>
                <td class="text-end"><b>{{ number_format($running_cr, 0) }}</b></td>
                <td class="text-end"><b>{{ number_format(($openingbal + $cost + $running_dr) - $running_cr, 0) }}</b></td>
            </tr>
        </tbody>
    </table>
</div>



            <!-- jQuery CDN - Slim version (=without AJAX) -->
        <script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
        <!-- Popper.JS -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
        <!-- Bootstrap JS -->
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm" crossorigin="anonymous"></script>

      <script>
         $('#project_name').change(function(){
         
           var selected = $(this).find('option:selected');    
            var projectid = selected.data('id');
            $('#projectid').val( projectid );
         
         });
         
      </script>
   </body>
</html>