<!DOCTYPE html>
<html lang="en">
<head>
    
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">
    <title>Customer Recovery</title>

    <style>


        
    @page {
       size: A4;
       margin: 0;
        }
        
        @media print {
            
          html, body{
            padding:15px;
            font-size:12px;
            line-height:1.0;
          }
          /* ... the rest of the rules ... */
        }
         
        #date_print{ 
        
            width:150px; !important;
        }
        .btn{ 
        
            width:120px; !important;
        }

    </style>
</head>
<body>
     
    <form method="get" class="pt-3">
        <input type="hidden" name="projectid" id="projectid" class="form-control "   value=@if(isset($_GET['projectid'])){{ $_GET['projectid']}}@endif>
    <table>
        <tr>
        <td class="d-print-none"><span>Project Name:</span></td>  
        <td>
             <select class="form-control form-control-sm d-print-none" id="project_name" name="project_name" >
                 <option>Select Your Project</option>
             @foreach($projectdata as $data)
             <option data-id="{{ $data->id }}" @if(isset($_GET['projectid'])){{$data->id ==  $_GET['projectid']  ? 'selected' : '' }}@endif
             value="{{ $data->project_name }}">{{ $data->project_name }}</option>
             @endforeach
             </select>
             
        </td>
        <td><span class="d-print-none">Start Date:</span></td>
        <td><input type="date" class="form-control form-control-sm d-print-none" id="date_print" value="{{ $start_date ?? $newDateTime->format('Y-m-d') }}" name="start_date"></td>
        <td><span class="d-print-none">End Date:</span></td>
        <td><input type="date" class="form-control form-control-sm d-print-none" id="date_print" value="{{ $end_date ?? now()->format('Y-m-d') }}" name="end_date"></td>
        <td><button type="submit" class="btn btn-info btn-sm d-print-none">Try Now</button></td>
        <td><a href="/home" class="btn btn-danger btn-sm d-print-none">Back Home</a></td>
        <td><button class="btn btn-sm btn-warning d-print-none"  onclick="myFunction()" >Print this page</button></td>
        </tr>
    </table>
    </form>
<hr class="d-print-none">
<div class="container-fluid">
<div class="row">
    
        <div class="col-4">
            <div class="row"><h2>Customer Recovery</h2></div>
            <div class="row d-none d-print-block"><span>
                @if(isset($start_date))Start Date : {{date('d-M-Y', strtotime($start_date))}}@endif</span></div>
            <div class="row d-none d-print-block mt-2"><span> @if(isset($end_date))End Date : {{date('d-M-Y', strtotime($end_date))}}@endif</span></div>
        </div>

    <div class="col-8 text-end mt-2">
        <div class="row d-none d-print-block"><h2 id="pname"></h2></div>
        <div class="row d-none d-print-block"><h6 class="text-end">Opening Balance</h6></div>
        <div class="row d-none d-print-block"> <h6 class="text-end">{{ number_format($openingbal,0)}}</h6></div>
        
    </div>

</div>



<?php 
$running_dr = 0;
$running_cr = 0;
$total = 0;
?>
<table class="table table-sm table-hover mt-3 ">

<thead>
    <tr>
    <th scope="col">Date</th>
    <th scope="col">Account Name</th>
    <th scope="col">Description</th>
    <th scope="col"  class="text-end">Received</th>
    
    </tr>
</thead>
<tbody>



@foreach($voucherdata as $datas)
        <tr>
        <td>{{ date('d-M-y', strtotime($datas->date)) }}</td>                 
        <td>{{ $datas->account_name }}</td>
        <td >
            <span class="d-print-none">{{ $datas->Description }}</span>
            <span class="d-none d-print-block">{{ Str::of($datas->Description)->limit(25) }}</span>
        </td>


        <td  class="text-end">{{ number_format($datas->credit,0) }}</td> 

<?php 
            $running_cr += $datas['credit'] ;

       ?>
                                
        </tr>
    @endforeach
        <tr>
 
            <td></td>
            <td></td>
            <td></td>

            <td  class="text-end"><b>{{ number_format($running_cr,0) }}</td> 
            

            
        </tr>

</tbody>
</div>    
</table>

      <!-- jQuery CDN - Slim version (=without AJAX) -->
      <script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
      <!-- Popper.JS -->
      <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
      <!-- Bootstrap JS -->
      <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm" crossorigin="anonymous"></script>
      <script>
         $('#project_name').change(function(){
         
           var selected = $(this).find('option:selected');    
            var projectid = selected.data('id');
            $('#projectid').val( projectid );
            
         });
             
        function myFunction() {
            
         document.getElementById("pname").innerHTML = $("#project_name").val();
         window.print();
         
         }
         
      </script>
</body>

</html>