<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Rvoucher;
use App\Http\Controllers\Pvoucher;
use App\Http\Controllers\Cvoucher;
use App\Http\Controllers\Application;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Reports;
use App\Http\Controllers\Account;
use App\Http\Controllers\Cheques;
use App\Http\Controllers\Journal;
use App\Http\Controllers\Project;
use App\Http\Controllers\Users;
use App\Http\Controllers\Purchase;
use App\Http\Controllers\Sale;
use App\Http\Controllers\Backup;
use App\Http\Controllers\Items;
use App\Http\Controllers\BackupController;
use Illuminate\Http\Request;


    
Route::middleware(['guard'])->group(function(){


Route::get('/reports/trial-balance', [Reports::class, 'Trailbalance'])->name('reports.trailbalance');
        
    
    Route::get('/download-database', [App\Http\Controllers\BackupController::class, 'download'])->name('download.database');

    Route::post('/upload-voucher-image', [Pvoucher::class, 'uploadVoucherImage']);
        
    Route::get('/our_backup_database', [Backup::class,'our_backup_database'])->name('our_backup_database');

    Route::get('/Items/add',[Items::class,'open'])->name('Items.open');
    Route::post('/Items/add',[Items::class,'add'])->name('Items.add');


        
    Route::get('/Purchase/add',[Purchase::class,'open'])->name('Purchase.open');
    Route::post('/Purchase/add',[Purchase::class,'add'])->name('Purchase.add');
    Route::get('/Purchase/index',[Purchase::class,'index'])->name('Purchase.index');    
    Route::get('/Purchase/edit/{id}',[Purchase::class,'edit'])->name('Purchase.edit');   
    Route::post('/Purchase/update/{id}',[Purchase::class,'update'])->name('Purchase.update');
    Route::get('/Purchase/delete/{id}',[Purchase::class,'delete'])->name('Purchase.delete');
    Route::get('/Purchase/show/{id}',[Purchase::class,'show'])->name('Purchase.show');
        
    
    


    Route::get('/Sale/add',[Sale::class,'open'])->name('Sale.open');
    Route::post('/Sale/add',[Sale::class,'add'])->name('Sale.add');
    Route::get('/Sale/index',[Sale::class,'index'])->name('Sale.index');    
    Route::get('/Sale/edit/{id}',[Sale::class,'edit'])->name('Sale.edit');   
    Route::post('/Sale/update/{id}',[Sale::class,'update'])->name('Sale.update');
    Route::get('/Sale/delete/{id}',[Sale::class,'delete'])->name('Sale.delete');
    Route::post('/Sale/customers',[Sale::class,'fetchCustomers'])->name('Sale.fetchCustomers');
        
    
    Route::get('/Users/add',[Users::class,'open']);
    Route::post('/Users/add',[Users::class,'addNew']);
    Route::get('/Users/index',[Users::class,'index'])->name('Users.index');
    Route::get('/Users/delete/{id}',[Users::class,'delete'])->name('Users.delete');
    Route::get('/Users/edit/{id}',[Users::class,'edit'])->name('Users.edit');    
    Route::post('/Users/update/{id}',[Users::class,'update']);
    
    
    Route::get('/Project/index',[Project::class,'index'])->name('Project.index');
    Route::get('/Project/add',[Project::class,'open'])->name('Project.open');
    Route::post('/Project/add',[Project::class,'addNew'])->name('Project.add');
    
    
    Route::get('/Rvoucher/add',[Rvoucher::class,'getProjectName']);
    Route::post('/Rvoucher/add',[Rvoucher::class,'addNew'])->name('Rvoucher.add');
    Route::get('/Rvoucher/index',[Rvoucher::class,'index'])->name('Rvoucher.index');
    Route::get('/Rvoucher/edit/{id}',[Rvoucher::class,'edit'])->name('Rvoucher.edit');
    Route::post('/Rvoucher/update/{id}',[Rvoucher::class,'update']);
    Route::get('/Rvoucher/show/{id}',[Rvoucher::class,'show'])->name('Rvoucher.show');
    Route::get('/Rvoucher/delete/{id}',[Rvoucher::class,'delete'])->name('Rvoucher.delete');
    
    Route::get('/Rvoucher/index',[Rvoucher::class,'index'])->name('Rvoucher.index');
    Route::post('/Rvoucher/accounts',[Rvoucher::class,'fetchAccounts'])->name('Rvoucher.accounts');
    
    
    
    Route::get('/Pvoucher/add',[Pvoucher::class,'getProjectName']);
    Route::post('/Pvoucher/add',[Pvoucher::class,'addNew'])->name('Pvoucher.add');
    Route::get('/Pvoucher/index',[Pvoucher::class,'index']);
    Route::get('/Pvoucher/edit/{id}',[Pvoucher::class,'edit'])->name('Pvoucher.edit');
    Route::post('/Pvoucher/update/{id}',[Pvoucher::class,'update']);
    Route::get('/Pvoucher/show/{id}',[Pvoucher::class,'show'])->name('Pvoucher.show');
    Route::get('/Pvoucher/delete/{id}',[Pvoucher::class,'delete'])->name('Pvoucher.delete');
    Route::get('/Pvoucher/index',[Pvoucher::class,'index'])->name('Pvoucher.index');
    Route::post('/Pvoucher/accounts',[Pvoucher::class,'fetchAccounts'])->name('Pvoucher.accounts');
    Route::get('/Pvoucher-limit', [Pvoucher::class, 'limit'])->name('Pvoucher.limit');


    
    
    Route::get('/Cvoucher/add',[Cvoucher::class,'getProjectName']);
    Route::post('/Cvoucher/add',[Cvoucher::class,'addNew'])->name('CReceipt.add');
    Route::get('/Cvoucher/index',[Cvoucher::class,'index']);
    Route::get('/Cvoucher/edit/{id}',[Cvoucher::class,'edit'])->name('Cvoucher.edit');
    Route::post('/Cvoucher/update/{id}',[Cvoucher::class,'update']);
    Route::get('/Cvoucher/show/{id}',[Cvoucher::class,'show'])->name('Cvoucher.show');
    Route::get('/Cvoucher/delete/{id}',[Cvoucher::class,'delete'])->name('Cvoucher.delete');
    Route::get('/Cvoucher/index',[Cvoucher::class,'index'])->name('Cvoucher.index');
    Route::post('/Cvoucher/accounts',[Cvoucher::class,'fetchAccounts'])->name('Cvoucher.accounts');
    Route::post('/Cvoucher/customers',[Cvoucher::class,'fetchCustomers'])->name('Cvoucher.customers');
    Route::post('/Cvoucher/fetchVendors',[Cvoucher::class,'fetchVendors'])->name('Cvoucher.fetchVendors');
    Route::post('/Cvoucher/ledger',[Cvoucher::class,'fetchCustLedger'])->name('Customer.Ledger');
    
    
    Route::get('/Application/add',[Application::class,'getProjectName']);
    Route::post('/Application/add',[Application::class,'addNew']);
    Route::get('/Application/index',[Application::class,'index']);
    Route::get('/Application/edit/{id}',[Application::class,'edit'])->name('Application.edit');
    Route::post('/Application/update/{id}',[Application::class,'update']);
    Route::get('/Application/show/{id}',[Application::class,'show'])->name('Application.show');
    Route::get('/Application/index',[Application::class,'index'])->name('Application.index');
    Route::post('/Application/accounts',[Application::class,'fetchAccounts'])->name('Application.accounts');
    Route::get('/Application/abc/{id}',[Application::class,'abc'])->name('Application.abc');
    Route::post('/Application/abc/{id}',[Application::class,'abcUpdate'])->name('Application.abc');
    Route::get('/schedule/delete/{id}', [Application::class, 'abcDelete'])->name('schedule.delete');
    Route::get('/Application/delete/{id}',[Application::class,'appDelete'])->name('ApplicationForm.delete');

    Route::get('/',[Application::class,'home']);
    Route::get('/home',[Application::class,'home']);
    
    
    Route::get('/report/cashbook',[Reports::class,'fetchCashBookData']);
    Route::get('/report/cashbook_category',[Reports::class,'fetchCashBookCategoryData']);
    Route::get('/report/recovery',[Reports::class,'recovery']);
    Route::get('/report/trailbalance',[Reports::class,'fetchTrailBalanceData']);
    Route::get('/report/installment',[Reports::class,'fetchInstallmentData']);
    Route::get('/report/floor_wise_recovery',[Reports::class,'floor_wise_recovery']);
    Route::get('/report/floor_wise_return', [Reports::class, 'floor_wise_return'])->name('floor_wise_return');
    Route::get('/report/ledger',[Reports::class,'ledgerview']);
    Route::post('/report/ledger',[Reports::class,'fetchLedgerData']);
    Route::get('/report/InStock', [Project::class,'InStock']);
    Route::get('/report/receivable', [Project::class,'receivable']);
    Route::get('/report/payable', [Project::class,'payable']);
    Route::get('/report/Vacants', [Reports::class,'Vacants']);
    Route::get('/report/inout', [Reports::class,'Inout']);
    Route::get('/report/ReceiptChecker', [Reports::class,'ReceiptChecker']);
    Route::post('/update-user',[Reports::class,'UpdateUser'])->name('UpdateUser');
    Route::post('/update-user-receipt',[Reports::class,'UpdateUserReceipt'])->name('UpdateUserReceipt');
    
    


    
    Route::get('/account/add',[Account::class,'getProjectName']);
    Route::post('/account/add',[Account::class,'addNew']);
    Route::get('/account/edit/{id}',[Account::class,'edit'])->name('account.edit');
    Route::post('/account/update/{id}',[Account::class,'update']);
    Route::get('/account/show/{id}',[Account::class,'show'])->name('account.show');
    Route::get('/account/index',[Account::class,'index'])->name('account.index');
    Route::post('/account/accounts',[Account::class,'fetchAccounts'])->name('account.accounts');
    
           

    
    Route::get('/cheques/add',[Cheques::class,'index']);
    Route::post('/cheques/add',[Cheques::class,'addNew']);
    Route::get('/cheques/index',[Cheques::class,'lookup']);
    Route::get('/cheques/clr/{id}',[Cheques::class,'clr'])->name('cheques.clr');
    Route::get('/cheques/delete/{id}',[Cheques::class,'delete'])->name('cheques.delete');
    Route::get('/cheques/show/{id}',[Cheques::class,'show'])->name('cheques.show');
    
    
    Route::get('/journal/add',[Journal::class,'getProjectName']);
    Route::post('/journal/add',[Journal::class,'addNew']);
    Route::get('/journal/index',[Journal::class,'index']);
    Route::get('/journal/edit/{id}',[Journal::class,'edit'])->name('journal.edit');
    Route::post('/journal/update/{id}',[Journal::class,'update']);
    Route::get('/journal/show/{id}',[Journal::class,'show'])->name('journal.show');
    Route::get('/journal/index',[Journal::class,'index'])->name('journal.index');
    Route::post('/journal/accounts',[Journal::class,'fetchAccounts'])->name('journal.accounts');
    

});


Route::get('/logout', function(){
    
        session()->forget('user_name');
        session()->forget('role');
         return redirect('/login');
});

Route::middleware(['blockIP'])->group(function () {
    Route::post('/login',[Account::class,'login']);
    Route::get('/login', function(Request $req){
        return view('/login');
    });
    
});

Route::get('/test',function(){
    return view('/test');
});

