<?php
require_once 'vendor/autoload.php';

session_start();

// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'abdul_samad1');
define('DB_USER', 'root');
define('DB_PASS', '');

// Google OAuth configuration
$client = new Google_Client();
$client->setClientId('642173405281-h9ra9frecl6m2b8hp6kmcj4fg5t1sfbb.apps.googleusercontent.com');
$client->setClientSecret('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');
$client->setRedirectUri('https://samad.alameenbuilders.pk/login.php');

$client->addScope('email');
$client->addScope('profile');
$client->setAccessType('offline');
$client->setPrompt('consent');

$google_oauth = new Google_Service_Oauth2($client);

// Database connection function - MOVED TO TOP
function getDBConnection() {
    try {
        $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch(PDOException $e) {
        // Return null instead of dying, so the app can continue without database
        error_log("Database connection failed: " . $e->getMessage());
        return null;
    }
}

// ==================== PAYMENT CRUD FUNCTIONS ====================

// Function to add payment
function addZakatPayment($user_email, $payment_data) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return false;
    }
    
    try {
        $stmt = $pdo->prepare("INSERT INTO zakat_payments 
                              (user_email, calculation_id, payment_amount, payment_date, payment_method, description) 
                              VALUES (?, ?, ?, ?, ?, ?)");
        
        $success = $stmt->execute([
            $user_email,
            $payment_data['calculation_id'],
            $payment_data['payment_amount'],
            $payment_data['payment_date'],
            $payment_data['payment_method'],
            $payment_data['description']
        ]);
        
        return $success ? $pdo->lastInsertId() : false;
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return false;
    }
}

// Function to get payments by user
function getUserZakatPayments($user_email) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return [];
    }
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM zakat_payments WHERE user_email = ? ORDER BY payment_date DESC, created_at DESC");
        $stmt->execute([$user_email]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return [];
    }
}

// Function to get payment by ID
function getPaymentById($payment_id, $user_email) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return null;
    }
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM zakat_payments WHERE id = ? AND user_email = ?");
        $stmt->execute([$payment_id, $user_email]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return null;
    }
}

// Function to update payment
function updateZakatPayment($payment_id, $user_email, $payment_data) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return false;
    }
    
    try {
        $stmt = $pdo->prepare("UPDATE zakat_payments 
                              SET calculation_id = ?, payment_amount = ?, payment_date = ?, 
                                  payment_method = ?, description = ?
                              WHERE id = ? AND user_email = ?");
        
        $success = $stmt->execute([
            $payment_data['calculation_id'],
            $payment_data['payment_amount'],
            $payment_data['payment_date'],
            $payment_data['payment_method'],
            $payment_data['description'],
            $payment_id,
            $user_email
        ]);
        
        return $success && $stmt->rowCount() > 0;
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return false;
    }
}

// Function to delete payment
function deleteZakatPayment($payment_id, $user_email) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return false;
    }
    
    try {
        $stmt = $pdo->prepare("DELETE FROM zakat_payments WHERE id = ? AND user_email = ?");
        $stmt->execute([$payment_id, $user_email]);
        return $stmt->rowCount() > 0;
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return false;
    }
}

// Function to get user's Zakat summary with payments
function getUserZakatSummary($user_email) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return null;
    }
    
    try {
        // Total Zakat calculated
        $stmt1 = $pdo->prepare("SELECT COALESCE(SUM(total_zakat), 0) as total_zakat FROM zakat_calculations WHERE user_email = ?");
        $stmt1->execute([$user_email]);
        $total_zakat = $stmt1->fetch(PDO::FETCH_ASSOC)['total_zakat'];
        
        // Total payments made
        $stmt2 = $pdo->prepare("SELECT COALESCE(SUM(payment_amount), 0) as total_paid FROM zakat_payments WHERE user_email = ?");
        $stmt2->execute([$user_email]);
        $total_paid = $stmt2->fetch(PDO::FETCH_ASSOC)['total_paid'];
        
        // Remaining Zakat
        $remaining_zakat = $total_zakat - $total_paid;
        
        return [
            'total_zakat' => $total_zakat,
            'total_paid' => $total_paid,
            'remaining_zakat' => $remaining_zakat
        ];
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return null;
    }
}

// Function to get single calculation by ID
function getZakatCalculationById($calculation_id, $user_email) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return null;
    }
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM zakat_calculations WHERE id = ? AND user_email = ?");
        $stmt->execute([$calculation_id, $user_email]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return null;
    }
}

// Function to update Zakat calculation
function updateZakatCalculation($calculation_id, $user_email, $calculation_data) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return false;
    }
    
    try {
        $stmt = $pdo->prepare("UPDATE zakat_calculations 
                              SET gold_grams = ?, silver_grams = ?, cash_amount = ?, 
                                  investments = ?, other_assets = ?, liabilities = ?, 
                                  total_zakat = ?
                              WHERE id = ? AND user_email = ?");
        
        $success = $stmt->execute([
            $calculation_data['gold_grams'],
            $calculation_data['silver_grams'],
            $calculation_data['cash_amount'],
            $calculation_data['investments'],
            $calculation_data['other_assets'],
            $calculation_data['liabilities'],
            $calculation_data['total_zakat'],
            $calculation_id,
            $user_email
        ]);
        
        return $success && $stmt->rowCount() > 0;
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return false;
    }
}

// Function to delete Zakat calculation
function deleteZakatCalculation($calculation_id, $user_email) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return false;
    }
    
    try {
        $stmt = $pdo->prepare("DELETE FROM zakat_calculations WHERE id = ? AND user_email = ?");
        $stmt->execute([$calculation_id, $user_email]);
        return $stmt->rowCount() > 0;
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return false;
    }
}

function getUserInfo($client, $google_oauth) {
    if (isset($_SESSION['access_token']) && $_SESSION['access_token']) {
        $client->setAccessToken($_SESSION['access_token']);
        
        try {
            $user_info = $google_oauth->userinfo->get();
            $_SESSION['user_name'] = $user_info->name;
            $_SESSION['user_email'] = $user_info->email;
            $_SESSION['user_picture'] = $user_info->picture;
            
            // Track account creation date
            if (!isset($_SESSION['account_created'])) {
                $_SESSION['account_created'] = date('Y-m-d H:i:s');
            }
            
            return $user_info;
        } catch (Exception $e) {
            // Token might be expired
            unset($_SESSION['access_token']);
            unset($_SESSION['user_name']);
            unset($_SESSION['user_email']);
            unset($_SESSION['user_picture']);
            unset($_SESSION['account_created']);
            return null;
        }
    }
    return null;
}

// Function to save Zakat calculation
function saveZakatCalculation($user_email, $user_name, $calculation_data) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return false;
    }
    
    try {
        $stmt = $pdo->prepare("INSERT INTO zakat_calculations 
                              (user_email, user_name, gold_grams, silver_grams, cash_amount, 
                               investments, other_assets, liabilities, total_zakat) 
                              VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        
        $stmt->execute([
            $user_email,
            $user_name,
            $calculation_data['gold_grams'],
            $calculation_data['silver_grams'],
            $calculation_data['cash_amount'],
            $calculation_data['investments'],
            $calculation_data['other_assets'],
            $calculation_data['liabilities'],
            $calculation_data['total_zakat']
        ]);
        
        return $pdo->lastInsertId();
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return false;
    }
}

// Function to get user's Zakat history
function getUserZakatHistory($user_email) {
    $pdo = getDBConnection();
    if (!$pdo) {
        return [];
    }
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM zakat_calculations 
                              WHERE user_email = ? 
                              ORDER BY calculation_date DESC");
        $stmt->execute([$user_email]);
        
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch(PDOException $e) {
        error_log("Database error: " . $e->getMessage());
        return [];
    }
}
?>