<?php
require_once 'config.php';

// Check if user is logged in
$user_info = getUserInfo($client, $google_oauth);
if (!$user_info) {
    header('Location: login.php');
    exit();
}

$calculation_id = $_GET['id'] ?? null;
$success = false;
$error = '';

if ($calculation_id) {
    // Delete the calculation
    $success = deleteZakatCalculation($calculation_id, $_SESSION['user_email']);
    if (!$success) {
        $error = "Failed to delete calculation or calculation not found.";
    }
} else {
    $error = "No calculation ID provided.";
}

// Redirect back to history after deletion
if ($success) {
    header('Location: zakat-history.php?deleted=1');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Calculation - Mominist</title>
    <style>
        body {
            padding-top: 80px;
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin: 0;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .message-card {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
            text-align: center;
            max-width: 500px;
            width: 90%;
        }

        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            text-decoration: none;
            display: inline-block;
            margin: 10px;
            transition: all 0.3s;
        }

        .btn-primary {
            background: #4285f4;
            color: white;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>
    <!-- Include Navbar -->
    <?php include 'navbar.php'; ?>

    <div class="message-card">
        <?php if ($error): ?>
            <div class="alert-error">
                <h2>❌ Deletion Failed</h2>
                <p><?php echo $error; ?></p>
            </div>
            <a href="zakat-history.php" class="btn btn-primary">Back to History</a>
        <?php else: ?>
            <div style="color: #28a745;">
                <h2>✅ Calculation Deleted</h2>
                <p>Your Zakat calculation has been successfully deleted.</p>
            </div>
            <a href="zakat-history.php" class="btn btn-primary">Back to History</a>
        <?php endif; ?>
    </div>
</body>
</html>