<?php
require_once 'config.php';
// Get user info to update navbar
getUserInfo($client, $google_oauth);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mominist - Home</title>
    <style>
        body {
            padding-top: 80px;
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin: 0;
            min-height: 100vh;
        }

        .hero-section {
            text-align: center;
            padding: 100px 20px;
            color: white;
        }

        .hero-section h1 {
            font-size: 3em;
            margin-bottom: 20px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }

        .hero-section p {
            font-size: 1.2em;
            margin-bottom: 30px;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .cta-buttons {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .cta-btn {
            background: #4285f4;
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            transition: all 0.3s ease;
        }

        .cta-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }

        .cta-btn.secondary {
            background: transparent;
            border: 2px solid white;
        }

        .features {
            background: white;
            padding: 80px 20px;
            text-align: center;
        }

        .features h2 {
            color: #333;
            margin-bottom: 50px;
        }

        .feature-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            max-width: 1200px;
            margin: 0 auto;
        }

        .feature-card {
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
        }

        .feature-card:hover {
            transform: translateY(-5px);
        }
    </style>
</head>
<body>
    <!-- Include Navbar -->
    <?php include 'navbar.php'; ?>

    <!-- Hero Section -->
    <section class="hero-section">
        <h1>Welcome to Mominist</h1>
        <p>Your platform for amazing services and features. Join us today and experience the difference.</p>
        
        <div class="cta-buttons">
            <?php if (isset($_SESSION['user_name'])): ?>
                <a href="dashboard.php" class="cta-btn">Go to Dashboard</a>
            <?php else: ?>
                <a href="login.php" class="cta-btn">Get Started</a>
            <?php endif; ?>
            <a href="#features" class="cta-btn secondary">Learn More</a>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features" id="features">
        <h2>Our Features</h2>
        <div class="feature-grid">
            <div class="feature-card">
                <h3>Secure Login</h3>
                <p>Safe and secure Gmail authentication</p>
            </div>
            <div class="feature-card">
                <h3>User Dashboard</h3>
                <p>Personalized user experience</p>
            </div>
            <div class="feature-card">
                <h3>Easy Management</h3>
                <p>Simple and intuitive interface</p>
            </div>
        </div>
    </section>
</body>
</html>