<?php
// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
$isLoggedIn = isset($_SESSION['access_token']) && !empty($_SESSION['access_token']);
$userName = isset($_SESSION['user_name']) ? $_SESSION['user_name'] : '';
?>

<nav class="navbar">
    <div class="nav-container">
        <!-- Left side - Brand Name -->
        <div class="nav-brand">
            <a href="index.php" class="brand-link">Mominist</a>
        </div>

        <!-- Right side - Menu Items -->
        <div class="nav-menu">
<ul class="nav-links">
    <li><a href="index.php">Home</a></li>
    <li><a href="about.php">About</a></li>
    <li><a href="services.php">Services</a></li>
    <li><a href="contact.php">Contact</a></li>
    <li><a href="zakat-calculator.php">Zakat Calculator</a></li>
    <?php if ($isLoggedIn && !empty($userName)): ?>
        <li><a href="zakat-history.php">Zakat History</a></li>
        <li><a href="payments.php">💳 Payments</a></li>
        <li class="user-welcome">
            <span class="welcome-text">Welcome, <?php echo htmlspecialchars($userName); ?></span>
        </li>
        <li><a href="dashboard.php" class="dashboard-btn">Dashboard</a></li>
        <li><a href="logout.php" class="logout-btn">Logout</a></li>
    <?php else: ?>
        <li><a href="login.php" class="login-btn">Gmail Login</a></li>
    <?php endif; ?>
</ul>
        </div>

        <!-- Mobile menu button -->
        <div class="mobile-menu-btn">
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
</nav>

<style>
/* Navbar Styles */
.navbar {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 0 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    z-index: 1000;
}

.nav-container {
    display: flex;
    justify-content: space-between;
    align-items: center;
    max-width: 1200px;
    margin: 0 auto;
    padding: 15px 0;
}

/* Brand Name Styles */
.nav-brand .brand-link {
    color: white;
    font-size: 28px;
    font-weight: bold;
    text-decoration: none;
    font-family: 'Arial', sans-serif;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
}

/* Navigation Menu Styles */
.nav-links {
    display: flex;
    list-style: none;
    margin: 0;
    padding: 0;
    align-items: center;
    gap: 20px;
}

.nav-links li {
    margin: 0;
}

.nav-links a {
    color: white;
    text-decoration: none;
    padding: 8px 16px;
    border-radius: 5px;
    transition: all 0.3s ease;
    font-weight: 500;
}

.nav-links a:hover {
    background: rgba(255,255,255,0.2);
    transform: translateY(-2px);
}

/* Special Button Styles */
.login-btn {
    background: #4285f4;
    border: 2px solid #4285f4;
}

.login-btn:hover {
    background: #357ae8;
    border-color: #357ae8;
}

.logout-btn {
    background: #dc3545;
    border: 2px solid #dc3545;
}

.logout-btn:hover {
    background: #c82333;
    border-color: #c82333;
}

.dashboard-btn {
    background: #28a745;
    border: 2px solid #28a745;
}

.dashboard-btn:hover {
    background: #218838;
    border-color: #218838;
}

/* User Welcome Text */
.user-welcome .welcome-text {
    color: white;
    font-weight: 500;
    padding: 8px 16px;
    background: rgba(255,255,255,0.1);
    border-radius: 5px;
    border: 1px solid rgba(255,255,255,0.2);
}

/* Mobile Menu Button (Hidden by default) */
.mobile-menu-btn {
    display: none;
    flex-direction: column;
    cursor: pointer;
}

.mobile-menu-btn span {
    width: 25px;
    height: 3px;
    background: white;
    margin: 3px 0;
    transition: 0.3s;
}

/* Responsive Design */
@media (max-width: 768px) {
    .nav-container {
        padding: 10px 0;
    }

    .mobile-menu-btn {
        display: flex;
    }

    .nav-menu {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: none;
        flex-direction: column;
        padding: 20px;
        box-shadow: 0 5px 10px rgba(0,0,0,0.2);
    }

    .nav-menu.active {
        display: flex;
    }

    .nav-links {
        flex-direction: column;
        width: 100%;
        gap: 10px;
    }

    .nav-links li {
        width: 100%;
        text-align: center;
    }

    .nav-links a {
        display: block;
        padding: 12px;
        width: 100%;
    }

    .user-welcome .welcome-text {
        display: block;
        text-align: center;
        margin: 10px 0;
    }
}
</style>

<script>
// Mobile menu toggle
document.addEventListener('DOMContentLoaded', function() {
    const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
    const navMenu = document.querySelector('.nav-menu');

    if (mobileMenuBtn) {
        mobileMenuBtn.addEventListener('click', function() {
            navMenu.classList.toggle('active');
        });
    }

    // Close mobile menu when clicking on a link
    const navLinks = document.querySelectorAll('.nav-links a');
    navLinks.forEach(link => {
        link.addEventListener('click', function() {
            navMenu.classList.remove('active');
        });
    });
});
</script>