<?php
require_once 'config.php';

// Check if user is logged in
$user_info = getUserInfo($client, $google_oauth);
if (!$user_info) {
    header('Location: login.php');
    exit();
}

// Get user payments and summary
$user_payments = getUserZakatPayments($_SESSION['user_email']);
$zakat_summary = getUserZakatSummary($_SESSION['user_email']);
$success_message = '';

// Handle success messages
if (isset($_GET['deleted']) && $_GET['deleted'] == 1) {
    $success_message = "Payment deleted successfully!";
}
if (isset($_GET['updated']) && $_GET['updated'] == 1) {
    $success_message = "Payment updated successfully!";
}
if (isset($_GET['added']) && $_GET['added'] == 1) {
    $success_message = "Payment added successfully!";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment History - Mominist</title>
    <style>
        body {
            padding-top: 80px;
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin: 0;
            min-height: 100vh;
        }

        .payments-container {
            max-width: 1200px;
            margin: 20px auto;
            padding: 0 20px;
        }

        .summary-card {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            padding: 25px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
        }

        .payments-card {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
            margin-bottom: 20px;
        }

        .payments-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .payments-table th,
        .payments-table td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #f0f0f0;
        }

        .payments-table th {
            background: #f8f9fa;
            font-weight: bold;
            color: #333;
        }

        .payment-amount {
            color: #28a745;
            font-weight: bold;
        }

        .action-btn {
            padding: 6px 10px;
            border-radius: 4px;
            text-decoration: none;
            font-size: 14px;
            transition: all 0.3s;
            display: inline-block;
            margin: 2px;
        }

        .action-btn.edit {
            background: #ffc107;
            color: #212529;
        }

        .action-btn.delete {
            background: #dc3545;
            color: white;
        }

        .action-btn:hover {
            opacity: 0.8;
            transform: scale(1.1);
        }

        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            text-decoration: none;
            display: inline-block;
            text-align: center;
            transition: all 0.3s;
        }

        .btn-success {
            background: #28a745;
            color: white;
        }

        .btn-primary {
            background: #4285f4;
            color: white;
        }

        .btn-secondary {
            background: #6c757d;
            color: white;
        }

        .btn:hover {
            opacity: 0.9;
            transform: translateY(-2px);
        }

        .button-group {
            display: flex;
            gap: 10px;
            margin-top: 20px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border: 1px solid #c3e6cb;
            text-align: center;
        }

        .empty-state {
            text-align: center;
            padding: 40px;
            color: #666;
        }

        .empty-icon {
            font-size: 4em;
            margin-bottom: 20px;
            opacity: 0.5;
        }

        .summary-item {
            margin: 10px 0;
            font-size: 1.1em;
        }

        .summary-amount {
            font-size: 1.3em;
            font-weight: bold;
            margin: 5px 0;
        }

        .remaining-warning {
            color: #ffc107;
            font-weight: bold;
        }

        .currency {
            font-family: monospace;
            font-weight: bold;
        }

        @media (max-width: 768px) {
            .payments-table {
                font-size: 14px;
            }
            
            .payments-table th,
            .payments-table td {
                padding: 8px 4px;
            }
            
            .button-group {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <!-- Include Navbar -->
    <?php include 'navbar.php'; ?>

    <div class="payments-container">
        <!-- Success Message -->
        <?php if ($success_message): ?>
            <div class="alert-success">
                ✅ <?php echo $success_message; ?>
            </div>
        <?php endif; ?>

        <!-- Zakat Summary -->
        <?php if ($zakat_summary): ?>
        <div class="summary-card">
            <h2>💰 Your Zakat Summary</h2>
            <div class="summary-item">
                Total Zakat Calculated: 
                <div class="summary-amount">Rs <?php echo number_format($zakat_summary['total_zakat'], 2); ?></div>
            </div>
            <div class="summary-item">
                Total Paid: 
                <div class="summary-amount">Rs <?php echo number_format($zakat_summary['total_paid'], 2); ?></div>
            </div>
            <div class="summary-item">
                Remaining Zakat: 
                <div class="summary-amount <?php echo $zakat_summary['remaining_zakat'] > 0 ? 'remaining-warning' : ''; ?>">
                    Rs <?php echo number_format($zakat_summary['remaining_zakat'], 2); ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <div class="payments-card">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h1 style="color: #333; margin: 0;">💳 Payment History</h1>
                <a href="add-payment.php" class="btn btn-success">➕ Add Payment</a>
            </div>

            <?php if (empty($user_payments)): ?>
                <div class="empty-state">
                    <div class="empty-icon">💳</div>
                    <h3>No payments recorded yet</h3>
                    <p>You haven't recorded any Zakat payments yet.</p>
                    <a href="add-payment.php" class="btn btn-success" style="margin-top: 15px;">
                        Record Your First Payment
                    </a>
                </div>
            <?php else: ?>
                <div style="overflow-x: auto;">
                    <table class="payments-table">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Method</th>
                                <th>Description</th>
                                <th>Linked Calculation</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $total_paid = 0;
                            foreach ($user_payments as $payment): 
                                $total_paid += $payment['payment_amount'];
                            ?>
                            <tr>
                                <td><?php echo date('M j, Y', strtotime($payment['payment_date'])); ?></td>
                                <td class="payment-amount currency">Rs <?php echo number_format($payment['payment_amount'], 2); ?></td>
                                <td><?php echo htmlspecialchars($payment['payment_method']); ?></td>
                                <td><?php echo htmlspecialchars($payment['description'] ?: '-'); ?></td>
                                <td>
                                    <?php if ($payment['calculation_id']): ?>
                                        <span style="color: #666;">Calculation #<?php echo $payment['calculation_id']; ?></span>
                                    <?php else: ?>
                                        <span style="color: #999;">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div style="display: flex; gap: 5px; flex-wrap: wrap;">
                                        <a href="edit-payment.php?id=<?php echo $payment['id']; ?>" 
                                           class="action-btn edit" 
                                           title="Edit Payment">
                                           ✏️
                                        </a>
                                        <a href="delete-payment.php?id=<?php echo $payment['id']; ?>" 
                                           class="action-btn delete" 
                                           title="Delete Payment"
                                           onclick="return confirm('Are you sure you want to delete this payment?')">
                                           🗑️
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr style="background: #f8f9fa;">
                                <td colspan="1" style="text-align: right; font-weight: bold;">Total Paid:</td>
                                <td class="payment-amount currency" style="font-size: 1.1em;">Rs <?php echo number_format($total_paid, 2); ?></td>
                                <td colspan="4"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            <?php endif; ?>

            <div class="button-group">
                <a href="add-payment.php" class="btn btn-success">➕ Add New Payment</a>
                <a href="zakat-history.php" class="btn btn-primary">📋 View Calculations</a>
                <a href="dashboard.php" class="btn btn-secondary">📊 Dashboard</a>
            </div>
        </div>
    </div>
</body>
</html>