<?php
require_once 'config.php';

// Check if user is logged in
$user_info = getUserInfo($client, $google_oauth);
if (!$user_info) {
    header('Location: login.php');
    exit();
}

// Get user's Zakat history
$zakat_history = getUserZakatHistory($_SESSION['user_email']);
$zakat_summary = getUserZakatSummary($_SESSION['user_email']);
$success_message = '';

// Handle success messages
if (isset($_GET['deleted']) && $_GET['deleted'] == 1) {
    $success_message = "Calculation deleted successfully!";
}
if (isset($_GET['updated']) && $_GET['updated'] == 1) {
    $success_message = "Calculation updated successfully!";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zakat History - Mominist</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            padding-top: 80px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin: 0;
            min-height: 100vh;
        }

        .history-container {
            max-width: 1400px;
            margin: 20px auto;
            padding: 0 20px;
        }

        .summary-card {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            padding: 25px;
            border-radius: 15px;
            margin-bottom: 20px;
            text-align: center;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }

        .history-card {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }

        .history-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .history-table th,
        .history-table td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #f0f0f0;
        }

        .history-table th {
            background: #f8f9fa;
            font-weight: bold;
            color: #333;
            border-bottom: 2px solid #dee2e6;
        }

        .payment-amount {
            color: #28a745;
            font-weight: bold;
        }

        .action-btn {
            padding: 6px 10px;
            border-radius: 6px;
            text-decoration: none;
            font-size: 14px;
            transition: all 0.3s;
            display: inline-block;
            margin: 2px;
            border: none;
        }

        .action-btn.edit {
            background: #ffc107;
            color: #212529;
        }

        .action-btn.delete {
            background: #dc3545;
            color: white;
        }

        .action-btn:hover {
            opacity: 0.8;
            transform: scale(1.1);
        }

        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            text-decoration: none;
            display: inline-block;
            text-align: center;
            transition: all 0.3s;
        }

        .btn-success {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
        }

        .btn-primary {
            background: linear-gradient(135deg, #4285f4, #6699ff);
            color: white;
        }

        .btn-secondary {
            background: linear-gradient(135deg, #6c757d, #8fa0a7);
            color: white;
        }

        .btn:hover {
            opacity: 0.9;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }

        .button-group {
            display: flex;
            gap: 10px;
            margin-top: 20px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .alert-success {
            background: linear-gradient(135deg, #d4edda, #c3e6cb);
            color: #155724;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            border: 1px solid #c3e6cb;
            text-align: center;
        }

        .empty-state {
            text-align: center;
            padding: 60px 40px;
            color: #666;
        }

        .empty-icon {
            font-size: 4em;
            margin-bottom: 20px;
            opacity: 0.5;
            color: #6c757d;
        }

        .summary-item {
            margin: 10px 0;
            font-size: 1.1em;
        }

        .summary-amount {
            font-size: 1.4em;
            font-weight: bold;
            margin: 5px 0;
        }

        .remaining-warning {
            color: #ffc107;
            font-weight: bold;
        }

        .currency {
            font-family: 'Courier New', monospace;
            font-weight: bold;
        }

        .zakat-amount {
            color: #28a745;
            font-weight: bold;
        }

        .table-responsive {
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }

        @media (max-width: 768px) {
            .history-table {
                font-size: 14px;
            }
            
            .history-table th,
            .history-table td {
                padding: 8px 4px;
            }
            
            .button-group {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
                text-align: center;
            }
            
            .action-btn {
                padding: 8px 12px;
                font-size: 12px;
            }
        }
    </style>
</head>
<body>
    <!-- Include Navbar -->
    <?php include 'navbar.php'; ?>

    <div class="history-container">
        <!-- Success Message -->
        <?php if ($success_message): ?>
            <div class="alert-success">
                <i class="fas fa-check-circle me-2"></i><?php echo $success_message; ?>
            </div>
        <?php endif; ?>

        <!-- Zakat Summary -->
        <?php if ($zakat_summary): ?>
        <div class="summary-card">
            <h2><i class="fas fa-chart-pie me-2"></i>Your Zakat Summary</h2>
            <div class="row">
                <div class="col-md-4">
                    <div class="summary-item">
                        Total Zakat Calculated: 
                        <div class="summary-amount">Rs <?php echo number_format($zakat_summary['total_zakat'], 2); ?></div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="summary-item">
                        Total Paid: 
                        <div class="summary-amount">Rs <?php echo number_format($zakat_summary['total_paid'], 2); ?></div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="summary-item">
                        Remaining Zakat: 
                        <div class="summary-amount <?php echo $zakat_summary['remaining_zakat'] > 0 ? 'remaining-warning' : ''; ?>">
                            Rs <?php echo number_format($zakat_summary['remaining_zakat'], 2); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <div class="history-card">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2 mb-0"><i class="fas fa-history me-2"></i>Zakat Calculation History</h1>
                <a href="zakat-calculator.php" class="btn btn-success">
                    <i class="fas fa-calculator me-2"></i>New Calculation
                </a>
            </div>

            <?php if (empty($zakat_history)): ?>
                <div class="empty-state">
                    <div class="empty-icon">
                        <i class="fas fa-calculator"></i>
                    </div>
                    <h3>No calculations found</h3>
                    <p class="lead">You haven't saved any Zakat calculations yet.</p>
                    <a href="zakat-calculator.php" class="btn btn-success btn-lg mt-3">
                        <i class="fas fa-calculator me-2"></i>Calculate Your First Zakat
                    </a>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="history-table table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th><i class="fas fa-calendar me-1"></i>Date</th>
                                <th><i class="fas fa-crown me-1"></i>Gold (g)</th>
                                <th><i class="fas fa-gem me-1"></i>Silver (g)</th>
                                <th><i class="fas fa-money-bill me-1"></i>Cash (Rs)</th>
                                <th><i class="fas fa-chart-line me-1"></i>Investments (Rs)</th>
                                <th><i class="fas fa-building me-1"></i>Other Assets (Rs)</th>
                                <th><i class="fas fa-credit-card me-1"></i>Liabilities (Rs)</th>
                                <th><i class="fas fa-scale-balanced me-1"></i>Zakat Due (Rs)</th>
                                <th><i class="fas fa-cog me-1"></i>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $total_all_zakat = 0;
                            foreach ($zakat_history as $calculation): 
                                $total_all_zakat += $calculation['total_zakat'];
                            ?>
                            <tr>
                                <td><?php echo date('M j, Y', strtotime($calculation['calculation_date'])); ?></td>
                                <td><?php echo number_format($calculation['gold_grams'], 2); ?></td>
                                <td><?php echo number_format($calculation['silver_grams'], 2); ?></td>
                                <td class="currency">Rs <?php echo number_format($calculation['cash_amount'], 2); ?></td>
                                <td class="currency">Rs <?php echo number_format($calculation['investments'], 2); ?></td>
                                <td class="currency">Rs <?php echo number_format($calculation['other_assets'], 2); ?></td>
                                <td class="currency">Rs <?php echo number_format($calculation['liabilities'], 2); ?></td>
                                <td class="zakat-amount currency">Rs <?php echo number_format($calculation['total_zakat'], 2); ?></td>
                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="edit-calculation.php?id=<?php echo $calculation['id']; ?>" 
                                           class="action-btn edit" 
                                           title="Edit Calculation">
                                           <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="delete-calculation.php?id=<?php echo $calculation['id']; ?>" 
                                           class="action-btn delete" 
                                           title="Delete Calculation"
                                           onclick="return confirm('Are you sure you want to delete this calculation?')">
                                           <i class="fas fa-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="7" class="text-end fw-bold">Total Zakat Calculated:</td>
                                <td class="zakat-amount currency fw-bold">Rs <?php echo number_format($total_all_zakat, 2); ?></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            <?php endif; ?>

            <div class="button-group">
                <a href="zakat-calculator.php" class="btn btn-success">
                    <i class="fas fa-calculator me-2"></i>New Calculation
                </a>
                <a href="payments.php" class="btn btn-primary">
                    <i class="fas fa-credit-card me-2"></i>View Payments
                </a>
                <a href="dashboard.php" class="btn btn-secondary">
                    <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                </a>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>