<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Laravel Google Login')</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="/">My Laravel App</a>

            <div class="collapse navbar-collapse">
                <ul class="navbar-nav ms-auto">
                    @if(session('user'))
                        <li class="nav-item d-flex align-items-center">
                            <img src="{{ session('user')->avatar }}" 
                                 alt="Avatar" width="35" height="35" 
                                 class="rounded-circle me-2">
                            <span class="text-white me-3">{{ session('user')->name }}</span>
                            <a href="/logout" class="btn btn-outline-light btn-sm">Logout</a>
                        </li>
                    @else
                        <li class="nav-item">
                            <a href="/auth/google" class="btn btn-light btn-sm">Login with Google</a>
                        </li>
                    @endif
                </ul>
            </div>
        </div>
    </nav>

    <main class="container py-5">
        @yield('content')
    </main>
</body>
</html>
