<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/3.5.0/select2.min.css" rel="stylesheet"/>
    <link href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css" rel="stylesheet" />

    <title>PURCHASE INVOICE</title> 

    <style>
    .select2-container .select2-choice {
        height:40px;
        line-height:33px;
    }
        #multiWrapper {
          width: 300px;
          margin: 0px 0 0 0px;
        }
    .def-cursor {
      cursor: default;
    }
    .form-unit .select2-container, .form-unit .select2-selection {
        width: 100% !important;
    }
    </style>
    
</head>

<body>
<div class="container">
    
    <form name="sample" id="invoice">
        <?php echo csrf_field(); ?>
    
    <div class="row">
        <div class="col-6 pt-2 pb-2 bg-success text-white">Purchase Invoice</div>
        <div class="col-6 pt-2 pb-2 bg-success text-white text-end">Last Updated <?php echo e(now()->format('d-m-Y')); ?></div>
    </div>
    <div class="row pt-2 bg-light text-dark">
        <div class="col-6">
    <div class="row mb-3">
      <label for="colFormLabelSm" class="col-sm-3 col-form-label col-form-label-sm">Project Name</label>
      <input type="hidden" id="project_id" name="project_id">
      <div class="col-sm-7">
        <input list="project_name_options" id="project_name" name="project_name" placeholder="Project Name" autocomplete="off" class="form-control form-control-sm">
        <datalist id="project_name_options">
            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option data-id="<?php echo e($data->id); ?>" value="<?php echo e($data->project_name); ?>"> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </datalist>
      </div>
    </div>

    <div class="row mb-3">
      <label for="colFormLabelSm" class="col-sm-3 col-form-label col-form-label-sm">Header code</label>
      <div class="col-sm-7">
        <input type="text" class="form-control form-control-sm" id="header_code" name="header_code" placeholder="Header Code">
      </div>
    </div>
    <div class="row mb-3">
      <label for="colFormLabelSm" class="col-sm-3 col-form-label col-form-label-sm">Account Id</label>
      <div class="col-sm-7">
        <input type="text" class="form-control form-control-sm" id="account_id" name="account_id" placeholder="Account Id">
      </div>
    </div>
    <div class="row mb-3">
      <label for="colFormLabelSm" class="col-sm-3 col-form-label col-form-label-sm">Account Name</label>
      <div class="col-sm-7">
        <input list="account_name_options" id="account_name" name="account_name" placeholder="Account Name" autocomplete="off" class="form-control form-control-sm">
        <datalist id="account_name_options">

        </datalist>
      </div>
    </div>    
</div>
        <div class="col-6">

    <div class="row mb-3">
      <label for="colFormLabelSm" class="offset-2 col-sm-3 col-form-label col-form-label-sm">Invoice #</label>
      <div class="col-sm-7 ">
        <input type="text" class="form-control form-control-sm"  id="id" placeholder="Invoice #">
      </div>
    </div>

<div class="row mb-3">
      <label for="colFormLabelSm" class="offset-2 col-sm-3 col-form-label col-form-label-sm">Manual Invoice #</label>
      <div class="col-sm-7">
        <input type="text" class="form-control form-control-sm"  id="manual_no" name="manual_no" placeholder="Manual No #">
      </div>
    </div>

<div class="row mb-3">
      <label for="colFormLabelSm" class="offset-2 col-sm-3 col-form-label col-form-label-sm">Entered By</label>
      <div class="col-sm-7">
        <input type="text" class="form-control form-control-sm" name="entered_by" id="entered_by" placeholder="Entered By" value="<?php echo e(session()->get('user_name')); ?>">
      </div>
    </div>

    <div class="row mb-3">
      <label for="colFormLabelSm" class="offset-2 col-sm-3 col-form-label col-form-label-sm">Date</label>
      <div class="col-sm-7">
        <input type="date" class="form-control form-control-sm" name="inv_date" id="date" placeholder="Date" value="<?php echo e(now()->format('Y-m-d')); ?>">
      </div>
    </div>
            
        </div>
    </div>
    <div class="row pt-2 bg-light text-dark">
        <div class="col-12">
            <table class="table table-striped table-bordered">
                <tr>
                    <td style="width:10%"><small>Item Id</small></td>
                    <td style="width:20%"><small>Item Name</small></td>
                    <td><small>Category</small></td>
                    <td><small>Type</small></td>
                    <td class="text-end"><small>Size</small></td>
                    <td class="text-end"><small>Rate</small></td>
                    <td class="text-end"><small>Quantity</small></td>
                    <td class="text-end"><small>Total</small></td>
                    
                    
                </tr>
                <tbody id="tbl">
                <tr>
                    <td><input type="text" class="form-control form-control-sm" id="item_id1" name="item_id1"></td>
                    <td>
                        <input list="item_name_options" id="item_name1"  placeholder="Item Name" autocomplete="off" class="form-control form-control-sm" name="item_name1">
                        <datalist id="item_name_options">
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-id="<?php echo e($data->id); ?>" data-size="<?php echo e($data->size); ?>" data-category="<?php echo e($data->category); ?>" data-type="<?php echo e($data->type); ?>" value="<?php echo e($data->item_name); ?>"> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </datalist>
                    </td>
                    <td>
                        <input  placeholder="Category1" autocomplete="off" class="form-control form-control-sm" id="category1" name="category1">
                        </td>                    
                    <td>
                        <input list="item_type_options" id="type1"  placeholder="Type" autocomplete="off" class="form-control form-control-sm" name="type1">
                        </td>

                    <td><input type="text" class="form-control form-control-sm text-end" name="size1" id="size1"></td>
                    <td><input type="text" class="form-control form-control-sm text-end" name="rate1" id="rate1"></td>
                    <td><input type="text" class="form-control form-control-sm text-end" name="qty1" id="qty1"></td>
                    <td><input type="text" class="form-control form-control-sm text-end" name="total1" id="total1"></td>
                    
                    
                </tr>

                </tbody>
                              <tfoot>
                <tr>
                  <td colspan="7" class="text-end">Invoice Amount</td>
                  <td><input type="text" id="FTotal" name="total_amount" class="form-control form-control-sm text-end"></td>
                </tr>
              </tfoot>  
            </table>
            

        </div>
    </div>
   
    
    <button type="button" id="savebtn" class="btn btn-sm btn-success" style="width:15%;">Save Record</button>
    <a href="/Purchase/index" class="btn btn-sm btn-info" style="width:15%;">Close Record</a>

	</form>
	
</div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/3.5.0/select2.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    
<script>

$("#total1").focusout(function(){
  addStudent();
}); 


    var spinner = '<div class="spinner-border" role="status"> <span class="sr-only">Loading...</span></div> &nbsp; Wait...';


    $('#savebtn').click(function(){
    
    var lastid = $('#id').val();
    
    console.log(lastid);
    if (lastid > 0){
        
        return;
    }
    
    $('#savebtn').html(spinner);
    var form = $('#invoice')[0];
    var formdata = new FormData(form);
    
    

    
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

    $.ajax({
                url: '<?php echo e(route("Purchase.add")); ?>',
                type: 'POST',
                processData: false, contentType: false,
                data: formdata,

                success: function(result){
                    
                            $('#id').val(result);
                            $('#savebtn').text('Save');
                                Toastify({ text: "Save Successfully !", duration: 3000, gravity: "bottom", // `top` or `bottom`
  position: "right", // `left`, `center` or `right`
        style: { background: "linear-gradient(to right, #00b09b, #96c93d)" }
    }).showToast();
                            

                },
                error: function(error){
                    console.log(error);
                    $('#savebtn').text('Save');
                                            Toastify({ text: "Sorry Could Not Save !", duration: 3000, gravity: "bottom", // `top` or `bottom`
  position: "right", // `left`, `center` or `right`
        style: { background: "linear-gradient(to right, #B32A0C, #F87255)" }
    }).showToast();
                    
                }
            });


});

    function addStudent()
    { 
         
        var item_id= document.getElementById("item_id1").value;
        var item_name= document.getElementById("item_name1").value;
        var type= document.getElementById("type1").value;
        var category= document.getElementById("category1").value;
        var size= document.getElementById("size1").value;
        var rate= document.getElementById("rate1").value;
        var qty= document.getElementById("qty1").value;
        var total= document.getElementById("total1").value;
        
        var tr = document.createElement('tr');
        
        var td1 = tr.appendChild(document.createElement('td'));
        var td2 = tr.appendChild(document.createElement('td'));
        var td3 = tr.appendChild(document.createElement('td'));
        var td4 = tr.appendChild(document.createElement('td'));
        var td5 = tr.appendChild(document.createElement('td'));
        var td6 = tr.appendChild(document.createElement('td'));
        var td7 = tr.appendChild(document.createElement('td'));
        var td8 = tr.appendChild(document.createElement('td'));
        
        
        
        
        
        td1.innerHTML='<input type="text" class="form-control form-control-sm" name="item_id[]" id="item_id" value="' + item_id + '"></td>' ;
        td2.innerHTML='<input type="text" class="form-control form-control-sm" name="item_name[]" id="item_name" value="' + item_name + '"></td>' ;
        td4.innerHTML='<input type="text" class="form-control form-control-sm" name="category[]" id="category" value="' + category + '"></td>' ;
        td3.innerHTML='<input type="text" class="form-control form-control-sm" name="type[]" id="type" value="' + type + '"></td>' ;
        td5.innerHTML='<input type="text" class="form-control form-control-sm text-end" name="size[]" id="value2" value="' + size + '"></td>' ;
        td6.innerHTML='<input type="text" class="form-control form-control-sm text-end rate" name="rate[]" id="rate" value="' + rate + '" onchange="Calc(this);"></td>';
        td7.innerHTML='<input type="text" class="form-control form-control-sm text-end qty" name="qty[]" id="qty" value="' + qty + '" onchange="Calc(this);"></td>';
        td8.innerHTML='<input type="text" class="form-control form-control-sm text-end total" name="total[]" id="total" value="' + total + '" onchange="Calc(this);"></td>';
        
        

        document.getElementById("tbl").appendChild(tr);
        clear();
        GetTotal();
        
        $("#item_name1").focus()
    }

    function delStudent(Stud){
        var s=Stud.parentNode.parentNode;
        s.parentNode.removeChild(s);
        total_amount();
    }

    $("#project_name").on('change', function () {
        
    $("#account_name_options").empty();
    
    var value = $('#project_name').val();
    projectid = $('#project_name_options [value="' + value + '"]').data('id');
    $('#project_id').val( projectid );
    
    
            $.ajax({
                url: '<?php echo e(route("Cvoucher.fetchVendors")); ?>',
                type: 'POST',
                data: 'projectid='+projectid+'&_token=<?php echo e(csrf_token()); ?>',
    
                success:function(result){
                       
                        $.each(result.accounts, function (key, value) {
                            $("#account_name_options").append('<option data-headercode="' + value.header_code + '" data-accountid="' + value.id + '" value="' + value.account_name + '">' +  value.account_name  +  '</option>');
                        });                        
    
                }
    
            });  
    
    
    
    });
    
    $("#account_name").on('change', function () {
    
    
    var value = $('#account_name').val();
    accountid = $('#account_name_options [value="' + value + '"]').data('accountid');
    headercode = $('#account_name_options [value="' + value + '"]').data('headercode');
    
    $('#header_code').val( headercode );
    $('#account_id').val( accountid );
    
    });
    
    $("#item_name1").on('change', function () {
    
    
    var value = $('#item_name1').val();
    item_id = $('#item_name_options [value="' + value + '"]').data('id');
    category = $('#item_name_options [value="' + value + '"]').data('category');
    type = $('#item_name_options [value="' + value + '"]').data('type');
    size = $('#item_name_options [value="' + value + '"]').data('size');
    
    
    $('#item_id1').val( item_id );
    $('#category1').val( category );
    $('#type1').val( type );
    $('#size1').val( size );
    
    $("#rate1").focus();
    
    });

    $("#rate1").on('change', function () {
     RowTotal();
    });

    $("#qty1").on('change', function () {
     RowTotal();
    });

    function RowTotal(){
        
        var rate1= document.getElementById("rate1").value;
        var qty1= document.getElementById("qty1").value;
        var tot1 = rate1 * qty1;
        
        
        $('#total1').val( tot1 );
        
    }
    
    function clear(){
        $('#total1').val( 0 );
        $('#rate1').val( 0 );
        $('#qty1').val( 0 );
        $('#item_id1').val( 0 );
        $('#item_name1').val( '' );
        $('#type1').val( '' );
        $('#category1').val( '' );
        $('#size1').val( 0 );
        
    }
    
    function Calc(v){
    
    var index = $(v).parent().parent().index()-1;

    qty = document.getElementsByClassName("qty")[index].value;
    rate = document.getElementsByClassName("rate")[index].value;
    
    var amt = qty * rate;
    document.getElementsByClassName("total")[index].value = amt;
    GetTotal();
    


    
}

    function GetTotal(){
        /*Footer Calculation*/   
    
        var sum=0;
        var amts =  document.getElementsByClassName("total");
    
        for (let index = 0; index < amts.length; index++)
        {
            var amt = amts[index].value;
            sum = +(sum) +  +(amt) ; 
        }
    
        document.getElementById("FTotal").value = sum;
    

    
    }
    
    
    
    
    $("input,select").bind("keydown", function(event) {
    if (event.which === 13) {
        event.stopPropagation();
        event.preventDefault();
       $(':input:eq(' + ($(':input').index(this) + 1) +')').focus();
    }
});

</script>

</body>
</html>
    
<?php /**PATH /home/alameenb/public_html/resources/views/Purchase/add.blade.php ENDPATH**/ ?>