<!DOCTYPE html>
<html lang="en">
<head>
    
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">
    <title>Cash Book</title>

    <style>
    @page {
       size: A4;
       margin: 0;
    }
        
    @media print {
      html, body{
        padding:15px;
        font-size:12px;
        line-height:1.0;
      }
    }
         
    #date_print{ 
        width:150px !important;
    }
    .btn{ 
        width:120px !important;
    }
    </style>
</head>
<body>
     
<form method="get" class="pt-3">
    <input type="hidden" name="projectid" id="projectid" class="form-control" value=<?php if(isset($_GET['projectid'])): ?><?php echo e($_GET['projectid']); ?><?php endif; ?>>
    <table>
        <tr>
            <td class="d-print-none"><span>Project Name:</span></td>  
            <td>
                <select class="form-control form-control-sm d-print-none" id="project_name" name="project_name">
                    <option>Select Your Project</option>
                    <?php $__currentLoopData = $projectdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option data-id="<?php echo e($data->id); ?>" 
                        <?php if(isset($_GET['projectid'])): ?><?php echo e($data->id ==  $_GET['projectid']  ? 'selected' : ''); ?><?php endif; ?>
                        value="<?php echo e($data->project_name); ?>"><?php echo e($data->project_name); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </td>
            <td><span class="d-print-none">Start Date:</span></td>
            <td><input type="date" class="form-control form-control-sm d-print-none" id="date_print" value="<?php echo e($start_date ?? $newDateTime->format('Y-m-d')); ?>" name="start_date"></td>
            <td><span class="d-print-none">End Date:</span></td>
            <td><input type="date" class="form-control form-control-sm d-print-none" id="date_print" value="<?php echo e($end_date ?? now()->format('Y-m-d')); ?>" name="end_date"></td>
            <td><button type="submit" class="btn btn-info btn-sm d-print-none">Try Now</button></td>
            <td><a href="/home" class="btn btn-danger btn-sm d-print-none">Back Home</a></td>
            <td><button class="btn btn-sm btn-warning d-print-none" onclick="myFunction()">Print this page</button></td>
        </tr>
    </table>
</form>

<hr class="d-print-none">

<div class="container-fluid">
<div class="row">
    <div class="col-4">
        <div class="row"><h2>Cash Book</h2></div>
        <div class="row d-none d-print-block"><span>
            <?php if(isset($start_date)): ?>Start Date : <?php echo e(date('d-M-Y', strtotime($start_date))); ?><?php endif; ?></span>
        </div>
        <div class="row d-none d-print-block mt-2"><span>
            <?php if(isset($end_date)): ?>End Date : <?php echo e(date('d-M-Y', strtotime($end_date))); ?><?php endif; ?></span>
        </div>
    </div>

    <div class="col-8 text-end mt-2">
        <div class="row d-none d-print-block"><h2 id="pname"></h2></div>
    </div>
</div>

<?php 
$running_dr = 0;
$running_cr = 0;
$balance = $openingbal; // Opening Balance
?>
<table class="table table-sm table-hover mt-3">
<thead>
    <tr>
        <th scope="col">Authorized</th>
        <th scope="col" style="width:10%;">Date</th>
        <th scope="col">Account Name</th>
        <th scope="col">Description</th>
        <th scope="col">Folio</th>
        <th scope="col" class="text-end">Debit</th>
        <th scope="col" class="text-end">Credit</th>
        <th scope="col" class="text-end">Running Balance</th>
    </tr>
</thead>
<tbody>
    <!-- Opening Balance Row -->
    <tr>
        <td></td>
        <td></td>
        <td colspan="4"><b>Opening Balance</b></td>
        <td></td>
        <td class="text-end"><b><?php echo e(number_format($openingbal,0)); ?></b></td>
    </tr>

    <?php $__currentLoopData = $voucherdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $running_cr += $datas->credit;
            $running_dr += $datas->debit;
            $balance = $balance + $datas->credit - $datas->debit;
        ?>
        <tr>
            <td class="text-center">
                <?php if($datas->checked == 1): ?> 
                    <input class="form-check-input" type="checkbox" checked disabled>
                <?php else: ?>
                    <input class="form-check-input" type="checkbox" disabled>
                <?php endif; ?>
            </td>                 
            <td><?php echo e(date('d-M-y', strtotime($datas->date))); ?></td>                 
            <td><?php echo e($datas->account_name); ?></td>
            <td>
                <span class="d-print-none"><?php echo e($datas->Description); ?></span>
                <span class="d-none d-print-block"><?php echo e(Str::of($datas->Description)->limit(25)); ?></span>
            </td>
            <td><?php echo e($datas->id); ?></td> 
            <td class="text-end"><?php echo e(number_format($datas->debit,0)); ?></td> 
            <td class="text-end"><?php echo e(number_format($datas->credit,0)); ?></td> 
            <td class="text-end"><b><?php echo e(number_format($balance,0)); ?></b></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <!-- Totals and Closing Balance -->
    <tr>
        <td colspan="5" class="text-end"><b>Total</b></td>
        <td class="text-end"><b><?php echo e(number_format($running_dr,0)); ?></b></td> 
        <td class="text-end"><b><?php echo e(number_format($running_cr,0)); ?></b></td> 
        <td class="text-end"><b><?php echo e(number_format($balance,0)); ?></b></td>
    </tr>
</tbody>
</table>

<h4 class="text-center">
    CASH IN HAND
    <br/>
    <?php echo e(number_format($balance,0)); ?>

</h4>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js"></script>
<script>
    $('#project_name').change(function(){
        var selected = $(this).find('option:selected');    
        var projectid = selected.data('id');
        $('#projectid').val(projectid);
    });
         
    function myFunction() {
        document.getElementById("pname").innerHTML = $("#project_name").val();
        window.print();
    }
</script>
</body>
</html>
<?php /**PATH /home/alameenb/public_html/resources/views/reports/cashbook.blade.php ENDPATH**/ ?>