<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="UTF-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">
      <title>Trail Balance</title>
      <style>
        @page {
           size: A4;
           margin: 0;
        }
        @media print {
          html, body{
            padding:5px;
            line-height:17px;
            font-size:15px;

          }
          /* ... the rest of the rules ... */
        }
         a{
              text-decoration: none;
         }
      </style>
   </head>
   <body><page size="A4">
      <div class="container-fluid">
         <div class="row">
             
            <div class="col-12 col-sm-8 mt-2">
               <h1>Trail Balance</h1>
                <h5></h5>Printed time: <?php echo e(date('d-M-y H:i:s')); ?></h5>
            </div>
            <div class="col-12 col-sm-4">
               <form method="GET" >
                  <input type="hidden" name="projectid" id="projectid" class="form-control rounded-0">
                  <select class="form-control mt-3 mb-2 d-print-none" id="project_name" name="project_name" >

                     <?php $__currentLoopData = $projectdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <option data-id="<?php echo e($data->id); ?>" <?php if(isset($_GET['projectid'])): ?><?php echo e($data->id ==  $_GET['projectid']  ? 'selected' : ''); ?><?php endif; ?>
                     value="<?php echo e($data->project_name); ?>"><?php echo e($data->project_name); ?></option>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     
                  </select>
                  <h1 class="d-none d-print-block text-end mt-4">
                      <? 
                      if(isset($_GET['projectid'])) {
                          echo $_GET['project_name'];
                         
                      } 
                      else{
                           echo "Star Corner";
                          
                      }
                      ?></h1>
                  <button type="submit" id="noprint" class="btn btn-sm btn-info d-print-none">Try Now</button>
                  <a href="/home">
                  <button type="button" id="noprint" class="btn btn-sm btn-danger d-print-none">Back Home</button>
                  </a>
                  <button type="button" id="noprint" onclick="window.print()" class="btn btn-sm btn-warning d-print-none">Print Page</button>
               </form>
            </div>
         </div>
         <div class="row">
           
         </div>
         <hr/>
         
         <div class="row">
             <div class="col-12 col-sm-6">
                <?php $collection=$students ?>
                <table class="table table-sm table-hover">
                   <thead class="thead-dark">
                      <tr>
                         <th scope="col"><h5>Account Name</h5></th>
                         <th class="text-end" scope="col "><h5>Debit</h5></th>
                      </tr>
                   </thead>
                   
                   <?php $TotalDebit = 0; ?>
                   <?php $SumTotalDebit = 0; ?>
                   <?php $TotalCreditCust = 0; ?>
                   <?php $TotalCredit = 0; ?>
                    <?php $SumOfCredit = 0; ?>
                    <?php $SumOfCreditCust = 0; ?>
                    

                   <?php $__currentLoopData = $collection; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year => $students): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                   <tr>
                        
                      <td>
                            <b><?php echo e($year); ?></b>
                      </td>
                        
                      
                      <td></td>
                   </tr>


                   <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                       <?php $TotalDebit += $student->SumOfDebit; ?>
                   <tr>
                        <?php if($student->SumOfDebit  != 0): ?>
                      <td ><div class="row">
                          <div class="col-1"><small class="text-muted">#<?php echo e($student->account_id); ?></small></div>
                          <div class="col-11"><?php echo e($student->account_name); ?></div>
                          </div>
                    </td>
                      
                      <td class="text-end"><?php echo e(number_format($student->SumOfDebit,0)); ?></td>
                      <?php endif; ?>
                   </tr>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   
                   <tr>
                      <td class="text-end"></td>
                      <td class="text-end"><b><?php echo e(number_format($TotalDebit,0)); ?></b></td>
                      <?php $SumTotalDebit += $TotalDebit; ?>
                      <?php $TotalDebit = 0; ?>
                   </tr>
                   </tr>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </table>
             </div>
             <div class="col-12 col-sm-6">
                <table class="table  table-sm table-hover">
                   <thead>
                      <tr>
                         <th scope="col"><h5>Account Type</h5></th>
                         
                         <th></th>
                         <th class="text-end" scope="col"><h5>Credit</h5></th>
                      </tr>
                   </thead>
                   <tbody>
                      <?php $__currentLoopData = $creditsidecust; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <?php $TotalCreditCust += $datas->SumOfCreditCust; ?>
                      <tr>
                    
                         <td><div class="row">
                          <div class="col-1"><small class="text-muted">#<?php echo e($datas->id); ?></small></div>
                          <div class="col-11"><?php echo e($datas->unit_no); ?></div>
                          </td>
                         <td></td>
                         <td class="text-end"><?php echo e(number_format($datas->SumOfCreditCust,0)); ?></td>
                         
                      </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php if($TotalCreditCust > 0 ): ?>
                          <tr>
                          <td></td>
                          <td></td>
                          <td class="text-end"><b> <?php echo e(number_format($TotalCreditCust,0)); ?></b></td>
                          </tr>  
                        <?php endif; ?>
                      
                      
                          <?php $__currentLoopData = $header_code; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $header): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <?php $SumOfCredit += $header->GroupTotal; ?>
                          <tr>
                            
                            <td>
                                <?php if($header->header_code == 601): ?>
                                    <b>CAPITAL INVESTMENT </b>
                                <?php elseif($header->header_code == 502): ?>
                                <b>OTHER INCOME</b>    
                                <?php elseif($header->header_code == 702): ?>
                                <b>LOAN </b>  
                                <?php endif; ?>
                            </td>
                        <td></td>
                        <td></td>
                            
                          </tr>
                              <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              
                                <?php if($val->header_code === $header->header_code): ?>
                                
                                    <?php if($val->SumOfCredit != 0): ?>
                                    <tr>
                                    <td><div class="row">
                                          <div class="col-1">#<small class="text-muted"><?php echo e($val->account_id); ?></small></div>
                                          <div class="col-11"><?php echo e($val->account_name); ?></div>
                                    </td>    
                                      <td> </td>
                                      
                                      <td class="text-end"> <?php echo e(number_format($val->SumOfCredit,0)); ?></td>
                                      
                                      
                                    </tr>
                                    <?php endif; ?>
                                 <?php endif; ?>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              <tr>
                                  <td></td>
                                <td></td>
                                <td class="text-end"><h6> <?php echo e(number_format($header->GroupTotal,0)); ?></h6></td>
                                
                              </tr>


                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </tbody>
                </table>
                

             </div>
          </div>

        <div class="row">
            <div class="col-6 text-end">
                  <h5>Total Debit = <?php echo e(number_format($SumTotalDebit,0)); ?></h5>
            </div>
                    <div class="col-6 text-end">
                  <h5>Total Credit = <?php echo e(number_format($TotalCreditCust+$SumOfCredit,0)); ?></h5>
            </div>
        </div>
                
                 
      <hr/>
      <h3 class="text-center">Cash In Hand</h3>
      <h3 class="text-center"><?php echo e(number_format($SumOfCredit + $TotalCreditCust - $SumTotalDebit)); ?></h3>
      <!-- jQuery CDN - Slim version (=without AJAX) -->
      <script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
      <!-- Popper.JS -->
      <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
      <!-- Bootstrap JS -->
      <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm" crossorigin="anonymous"></script>
      <script>
         $('#project_name').change(function(){
         
           var selected = $(this).find('option:selected');    
            var projectid = selected.data('id');
            $('#projectid').val( projectid );
         
         });
         
      </script>
      </page>
   </body>
</html><?php /**PATH /home/tahakash/public_html/resources/views/reports/trailbalance.blade.php ENDPATH**/ ?>