<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="UTF-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">
      <title>Trail Balance</title>
      <style>
        @page {
           size: A4;
           margin: 0;
        }
        @media print {
          html, body{
            padding:5px;
            line-height:17px;
            font-size:15px;

          }
          /* ... the rest of the rules ... */
        }
         a{
              text-decoration: none;
         }
      </style>
   </head>
   <body><page size="A4">
      <div class="container-fluid">
         <div class="row">
             
            <div class="col-12 col-sm-6 mt-2">
               <h1>Trail Balance1</h1>
                <h5></h5>printed time: <?php echo e(now()); ?></h5>
            </div>
            <div class="col-12 col-sm-6">
               <form method="GET" >
                  <input type="hidden" name="projectid" id="projectid" class="form-control rounded-0">
                  <select class="form-control mt-3 mb-2 d-print-none" id="project_name" name="project_name" >

                     <?php $__currentLoopData = $projectdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <option data-id="<?php echo e($data->id); ?>" <?php if(isset($_GET['projectid'])): ?><?php echo e($data->id ==  $_GET['projectid']  ? 'selected' : ''); ?><?php endif; ?>
                     value="<?php echo e($data->project_name); ?>"><?php echo e($data->project_name); ?></option>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     
                  </select>
                  <h1 class="d-none d-print-block text-end mt-4">
                      <? 
                      if(isset($_GET['projectid'])) {
                          echo $_GET['project_name'];
                         
                      } 
                      else{
                           echo "Star Corner";
                          
                      }
                      ?></h1>
                  <button type="submit" id="noprint" class="btn btn-sm btn-info d-print-none">Try Now</button>
                  <a href="/">
                  <button type="button" id="noprint" class="btn btn-sm btn-danger d-print-none">Back Home</button>
                  </a>
                  <button type="button" id="noprint" onclick="window.print()" class="btn btn-sm btn-warning d-print-none">Print Page</button>
               </form>
            </div>
         </div>
         <div class="row">
           
         </div>
         <hr/>
         
         <div class="row">
             <div class="col-12 col-sm-6">
                <?php $collection=$students ?>
                <table class="table table-sm table-hover">
                   <thead class="thead-dark">
                      <tr>
                         <th scope="col">Account Name</th>
                         <th class="text-end" scope="col ">Debit</th>
                      </tr>
                   </thead>
                   <?php $TotalDebit = 0; ?>
                   <?php $SumTotalDebit = 0; ?>
                   <?php $TotalCreditCust = 0; ?>
                   <?php $TotalCredit = 0; ?>
                    <?php $SumOfCredit = 0; ?>
                    <?php $SumOfCreditCust = 0; ?>
                    
                   
                   <?php $__currentLoopData = $collection; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year => $students): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                   <tr>
                      <td>
                         <?php if($year == 301): ?>
                         <b>EXPENSE</b>
                         <?php elseif($year == 401): ?>        
                         <b>STOCK </b>     
                         <?php elseif($year == 501): ?>        
                         <b>BANK/DASTI </b>       
                         <?php endif; ?>
                      </td>
                      <td></td>
                   </tr>
                   <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                   <?php $TotalDebit += $student->SumOfDebit; ?>
                   <tr>
                        <?php if($student->SumOfDebit  != 0): ?>
                      <td ><?php echo e($year . '-' . $student->account_id . ' ' . Str::of($student->account_name)->limit(25)); ?></td>
                      
                      <td class="text-end"><?php echo e(number_format($student->SumOfDebit,0)); ?></td>
                      <?php else: ?>
                      <?php endif; ?>
                   </tr>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   <tr>
                      <td class="text-end"><b>Total Of <?php echo e($year); ?></b></td>
                      <td class="text-end"><b><?php echo e(number_format($TotalDebit,0)); ?></b></td>
                      <?php $SumTotalDebit += $TotalDebit; ?>
                      <?php $TotalDebit = 0; ?>
                   </tr>
                   </tr>
                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   <tr>
                      <td class="text-end"><b>Gross Debit</b></td>
                      <td class="text-end">
                         <h5><?php echo e(number_format($SumTotalDebit,0)); ?></h5>
                      </td>
                   </tr>
                </table>
             </div>
             <div class="col-12 col-sm-6">
                <table class="table  table-sm table-hover">
                   <thead>
                      <tr>
                         <th scope="col">Account Name</th>
                         
                         <th></th>
                         <th class="text-end" scope="col">Credit</th>
                      </tr>
                   </thead>
                   <tbody>

                      
                          <?php $__currentLoopData = $header_code; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $header): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <?php $SumOfCredit += $header->GroupTotal; ?>
                          <tr>
                            
                            <td>
                         <?php if($header->header_code == 601): ?>
                         <b>OTHER INCOME</b>
                         <?php elseif($header->header_code == 502): ?>
                         <b>CAPITAL INVESTMENT </b>       
                         <?php endif; ?>
                      </td>
                      <td></td>
                        <td></td>
                            
                          </tr>
                              <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              
                                <?php if($val->header_code === $header->header_code): ?>
                                
                                    <?php if($val->SumOfCredit != 0): ?>
                                    <tr>
                                    <td><?php echo e($val->header_code ."-" . $val->account_id . " " . $val->account_name); ?></td>    
                                      <td> </td>
                                      
                                      <td class="text-end"> <?php echo e(number_format($val->SumOfCredit,0)); ?></td>
                                      
                                      
                                    </tr>
                                    <?php endif; ?>
                                 <?php endif; ?>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              <tr>
                                  <td></td>
                                <td></td>
                                <td class="text-end"><h6><?php echo e(number_format($header->GroupTotal,0)); ?></h6></td>
                                
                              </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </tbody>
                </table>
             </div>
          </div>
      </div>
      <hr/>
      <h3 class="text-center">Cash In Hand</h3>
      <h3 class="text-center"><?php echo e(number_format($SumOfCredit + $TotalCreditCust - $SumTotalDebit)); ?></h3>
      <!-- jQuery CDN - Slim version (=without AJAX) -->
      <script src="https://code.jquery.com/jquery-3.6.4.min.js" integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
      <!-- Popper.JS -->
      <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
      <!-- Bootstrap JS -->
      <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm" crossorigin="anonymous"></script>
      <script>
         $('#project_name').change(function(){
         
           var selected = $(this).find('option:selected');    
            var projectid = selected.data('id');
            $('#projectid').val( projectid );
         
         });
         
      </script>
      </page>
   </body>
</html><?php /**PATH /home/imtiazir/public_html/resources/views/reports/trailbalance.blade.php ENDPATH**/ ?>